/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLInfoAccessor;
import com.jogamp.opencl.CLObject;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;

public class CLSampler
extends CLObject
implements CLResource {
    private final CLSamplerInfoAccessor samplerInfo = new CLSamplerInfoAccessor();

    private CLSampler(CLContext context, long id, AddressingMode addrMode, FilteringMode filtMode, boolean normalizedCoords) {
        super(context, id);
    }

    static CLSampler create(CLContext context, AddressingMode addrMode, FilteringMode filtMode, boolean normalizedCoords) {
        int[] error = new int[1];
        long id = context.cl.clCreateSampler(context.ID, CLUtil.clBoolean(normalizedCoords), addrMode.MODE, filtMode.MODE, error, 0);
        CLException.checkForError(error[0], "can not create sampler");
        return new CLSampler(context, id, addrMode, filtMode, normalizedCoords);
    }

    public FilteringMode getFilteringMode() {
        int info = (int)this.samplerInfo.getLong(4436);
        return FilteringMode.valueOf(info);
    }

    public AddressingMode getAddressingMode() {
        int info = (int)this.samplerInfo.getLong(4435);
        return AddressingMode.valueOf(info);
    }

    public boolean hasNormalizedCoords() {
        return this.samplerInfo.getLong(4434) == 1L;
    }

    public void release() {
        int ret = this.cl.clReleaseSampler(this.ID);
        this.context.onSamplerReleased(this);
        if (ret != 0) {
            throw CLException.newException(ret, "can not release " + this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddressingMode {
        REPEAT(4403),
        CLAMP_TO_EDGE(4401),
        CLAMP(4402),
        NONE(4400);

        public final int MODE;

        private AddressingMode(int mode) {
            this.MODE = mode;
        }

        public static AddressingMode valueOf(int mode) {
            switch (mode) {
                case 4403: {
                    return REPEAT;
                }
                case 4401: {
                    return CLAMP_TO_EDGE;
                }
                case 4402: {
                    return CLAMP;
                }
                case 4400: {
                    return NONE;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilteringMode {
        NEAREST(4416),
        LINEAR(4417);

        public final int MODE;

        private FilteringMode(int mode) {
            this.MODE = mode;
        }

        public static FilteringMode valueOf(int mode) {
            switch (mode) {
                case 4416: {
                    return NEAREST;
                }
                case 4417: {
                    return LINEAR;
                }
            }
            return null;
        }
    }

    private class CLSamplerInfoAccessor
    extends CLInfoAccessor {
        private CLSamplerInfoAccessor() {
        }

        protected int getInfo(int name, long valueSize, Buffer value, PointerBuffer valueSizeRet) {
            return CLSampler.this.cl.clGetSamplerInfo(CLSampler.this.ID, name, valueSize, value, valueSizeRet);
        }
    }
}

