/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

abstract class CLInfoAccessor {
    protected static final ThreadLocal<ByteBuffer> localBB = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return Buffers.newDirectByteBuffer((int)512);
        }
    };
    protected static final ThreadLocal<PointerBuffer> localPB = new ThreadLocal<PointerBuffer>(){

        @Override
        protected PointerBuffer initialValue() {
            return PointerBuffer.allocateDirect((int)1);
        }
    };

    CLInfoAccessor() {
    }

    public final long getLong(int key) {
        ByteBuffer buffer = localBB.get();
        int ret = this.getInfo(key, 8L, buffer, null);
        CLException.checkForError(ret, "error while asking for info value");
        return buffer.getLong(0);
    }

    public final String getString(int key) {
        ByteBuffer buffer = localBB.get();
        PointerBuffer sizeBuffer = localPB.get();
        int ret = this.getInfo(key, buffer.capacity(), buffer, sizeBuffer);
        CLException.checkForError(ret, "error while asking for info string");
        int clSize = (int)sizeBuffer.get(0);
        byte[] array = new byte[clSize - 1];
        buffer.get(array).rewind();
        return CLUtil.clString2JavaString(array, clSize);
    }

    protected abstract int getInfo(int var1, long var2, Buffer var4, PointerBuffer var5);
}

