/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.AutoCloseable;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLEvent;
import com.jogamp.opencl.CLResource;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLEventList
implements CLResource,
AutoCloseable,
Iterable<CLEvent> {
    private final CLEvent[] events;
    final PointerBuffer IDs;
    int size;

    public CLEventList(int capacity) {
        this.events = new CLEvent[capacity];
        this.IDs = PointerBuffer.allocateDirect((int)capacity);
    }

    public CLEventList(CLEvent ... events) {
        this.events = events;
        this.IDs = PointerBuffer.allocateDirect((int)events.length);
        for (CLEvent event : events) {
            this.IDs.put(event.ID);
        }
        this.IDs.rewind();
        this.size = events.length;
    }

    void createEvent(CLContext context) {
        if (this.events[this.size] != null) {
            this.events[this.size].release();
        }
        this.events[this.size] = new CLEvent(context, this.IDs.get());
        ++this.size;
    }

    @Override
    public void release() {
        for (int i = 0; i < this.size; ++i) {
            this.events[i].release();
            this.events[i] = null;
        }
        this.size = 0;
        this.IDs.rewind();
    }

    @Override
    public final void close() throws Exception {
        this.release();
    }

    public CLEvent getEvent(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("list contains " + this.size + " events, can not return event with index " + index);
        }
        return this.events[index];
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.events.length;
    }

    @Override
    public Iterator<CLEvent> iterator() {
        return new EventIterator(this.events, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append('[');
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.events[i].toString());
            if (i + 1 == this.size) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventIterator
    implements Iterator<CLEvent> {
        private final CLEvent[] events;
        private final int size;
        private int index;

        private EventIterator(CLEvent[] events, int size) {
            this.events = events;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public CLEvent next() {
            if (this.hasNext()) {
                return this.events[this.index++];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported.");
        }
    }
}

