/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CL;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLSubBuffer;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLBuffer<B extends Buffer>
extends CLMemory<B> {
    private List<CLSubBuffer<B>> childs;

    protected CLBuffer(CLContext context, long size, long id, int flags) {
        this(context, null, size, id, flags);
    }

    protected CLBuffer(CLContext context, B directBuffer, long size, long id, int flags) {
        super(context, directBuffer, size, id, flags);
    }

    static CLBuffer<?> create(CLContext context, int size, int flags) {
        CL cl = context.cl;
        int[] result = new int[1];
        if (CLBuffer.isHostPointerFlag(flags)) {
            throw new IllegalArgumentException("no host pointer defined");
        }
        long id = cl.clCreateBuffer(context.ID, flags, size, null, result, 0);
        CLException.checkForError(result[0], "can not create cl buffer");
        return new CLBuffer(context, size, id, flags);
    }

    static <B extends Buffer> CLBuffer<B> create(CLContext context, B directBuffer, int flags) {
        if (!directBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer is not direct");
        }
        Buffer host_ptr = null;
        CL cl = context.cl;
        int[] result = new int[1];
        if (CLBuffer.isHostPointerFlag(flags)) {
            host_ptr = directBuffer;
        }
        int size = CLBuffer.sizeOfBufferElem(directBuffer) * directBuffer.capacity();
        long id = cl.clCreateBuffer(context.ID, flags, size, host_ptr, result, 0);
        CLException.checkForError(result[0], "can not create cl buffer");
        return new CLBuffer<B>(context, directBuffer, size, id, flags);
    }

    public CLSubBuffer<B> createSubBuffer(int offset, int size, CLMemory.Mem ... flags) {
        Buffer slice = null;
        if (this.buffer != null) {
            slice = Buffers.slice((Buffer)this.buffer, (int)offset, (int)size);
            int elemSize = Buffers.sizeOfBufferElem((Buffer)this.buffer);
            offset *= elemSize;
            size *= elemSize;
        }
        PointerBuffer info = PointerBuffer.allocateDirect((int)2);
        info.put((long)offset).put((long)size).rewind();
        int bitset = CLMemory.Mem.flagsToInt(flags);
        int[] err = new int[1];
        long subID = this.cl.clCreateSubBuffer(this.ID, bitset, 4640, info.getBuffer(), err, 0);
        CLException.checkForError(err[0], "can not create sub buffer");
        CLSubBuffer<Buffer> clSubBuffer = new CLSubBuffer<Buffer>(this, offset, size, slice, subID, bitset);
        if (this.childs == null) {
            this.childs = new ArrayList<CLSubBuffer<B>>();
        }
        this.childs.add(clSubBuffer);
        return clSubBuffer;
    }

    @Override
    public void release() {
        if (this.childs != null) {
            while (!this.childs.isEmpty()) {
                this.childs.get(0).release();
            }
        }
        super.release();
    }

    void onReleaseSubBuffer(CLSubBuffer sub) {
        this.childs.remove(sub);
    }

    public List<CLSubBuffer<B>> getSubBuffers() {
        if (this.childs == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.childs);
    }

    public boolean isSubBuffer() {
        return false;
    }

    @Override
    public <T extends Buffer> CLBuffer<T> cloneWith(T directBuffer) {
        return new CLBuffer<T>(this.context, directBuffer, this.size, this.ID, this.FLAGS);
    }
}

