/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl;

import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.opengl.BuildStaticGLInfo;
import com.jogamp.gluegen.opengl.GLConfiguration;
import com.jogamp.gluegen.opengl.GLJavaMethodBindingEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import com.jogamp.gluegen.runtime.opengl.GLExtensionNames;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GLEmitter
extends ProcAddressEmitter {
    private Map<MethodBinding, MethodBinding> bufferObjectMethodBindings = new IdentityHashMap<MethodBinding, MethodBinding>();

    public void beginEmission(GlueEmitterControls glueEmitterControls) throws IOException {
        this.getGLConfig().parseGLHeaders(glueEmitterControls);
        this.renameExtensionsIntoCore();
        if (this.getGLConfig().getAutoUnifyExtensions()) {
            this.unifyExtensions(glueEmitterControls);
        }
        super.beginEmission(glueEmitterControls);
    }

    protected void renameExtensionsIntoCore() {
        GLConfiguration gLConfiguration = this.getGLConfig();
        Set<String> set = gLConfiguration.getExtensionsRenamedIntoCore();
        BuildStaticGLInfo buildStaticGLInfo = gLConfiguration.getGLInfo();
        if (null == buildStaticGLInfo) {
            if (set.size() > 0) {
                throw new RuntimeException("ExtensionRenamedIntoCore (num: " + set.size() + "), but no GLHeader");
            }
            return;
        }
        for (String string : set) {
            Set<String> set2 = buildStaticGLInfo.getDeclarations(string);
            if (set2 == null) continue;
            for (String string2 : set2) {
                String string3;
                boolean bl = GLExtensionNames.isGLFunction(string2);
                boolean bl2 = false;
                if (!bl) {
                    bl2 = GLExtensionNames.isGLEnumeration(string2);
                }
                if (!bl && !bl2 || (string3 = GLExtensionNames.normalize(string2, bl)).equals(string2)) continue;
                gLConfiguration.addJavaSymbolRename(string2, string3);
            }
        }
    }

    private void unifyExtensions(GlueEmitterControls glueEmitterControls) {
        glueEmitterControls.runSymbolFilter((SymbolFilter)new ExtensionUnifier());
    }

    protected JavaConfiguration createConfig() {
        return new GLConfiguration(this);
    }

    protected List<MethodBinding> expandMethodBinding(MethodBinding methodBinding) {
        List list = super.expandMethodBinding(methodBinding);
        if (!this.getGLConfig().isBufferObjectFunction(methodBinding.getName())) {
            return list;
        }
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>(list);
        for (MethodBinding methodBinding2 : list) {
            if (methodBinding2.signatureUsesJavaPrimitiveArrays()) continue;
            MethodBinding methodBinding3 = methodBinding2;
            for (int i = 0; i < methodBinding2.getNumArguments(); ++i) {
                if (!methodBinding2.getJavaArgumentType(i).isNIOBuffer()) continue;
                methodBinding3 = methodBinding3.replaceJavaArgumentType(i, JavaType.createForClass(Long.TYPE));
            }
            if (methodBinding3 == methodBinding2) {
                throw new RuntimeException("Error: didn't find any void* arguments for BufferObject function " + methodBinding.getName());
            }
            arrayList.add(methodBinding3);
            this.bufferObjectMethodBindings.put(methodBinding3, methodBinding3);
        }
        return arrayList;
    }

    protected boolean needsModifiedEmitters(FunctionSymbol functionSymbol) {
        return (this.needsProcAddressWrapper(functionSymbol) || this.needsBufferObjectVariant(functionSymbol)) && !this.getConfig().isUnimplemented(functionSymbol.getName());
    }

    public boolean isBufferObjectMethodBinding(MethodBinding methodBinding) {
        return this.bufferObjectMethodBindings.containsKey(methodBinding);
    }

    public void emitDefine(ConstantDefinition constantDefinition, String string) throws Exception {
        BuildStaticGLInfo buildStaticGLInfo = this.getGLConfig().getGLInfo();
        if (null == buildStaticGLInfo) {
            throw new Exception("No GLInfo for: " + constantDefinition);
        }
        String string2 = constantDefinition.getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Part of <code>");
        if (0 == this.addExtensionsOfSymbols2Buffer(stringBuilder, ", ", string2, constantDefinition.getAliasedNames())) {
            if (constantDefinition.isEnum()) {
                String string3 = constantDefinition.getEnumName();
                if (null != string3) {
                    stringBuilder.append(string3);
                } else {
                    stringBuilder.append("CORE ENUM");
                }
            } else if (this.getGLConfig().getAllowNonGLExtensions()) {
                stringBuilder.append("CORE DEF");
            } else {
                return;
            }
        }
        stringBuilder.append("</code>");
        if (null != string) {
            stringBuilder.append("<br>");
            stringBuilder.append(string);
        }
        super.emitDefine(constantDefinition, stringBuilder.toString());
    }

    public int addExtensionsOfSymbols2Buffer(StringBuilder stringBuilder, String string, String string2, Collection<String> collection) {
        String string3;
        BuildStaticGLInfo buildStaticGLInfo = this.getGLConfig().getGLInfo();
        if (null == buildStaticGLInfo) {
            throw new RuntimeException("No GLInfo for: " + string2);
        }
        int n = 0;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Iterator<String> iterator = collection.iterator();
        if (null != string2 && null != (string3 = buildStaticGLInfo.getExtension(string2))) {
            stringBuilder.append(string3);
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        while (iterator.hasNext()) {
            string3 = buildStaticGLInfo.getExtension(iterator.next());
            if (null == string3) continue;
            stringBuilder.append(string3);
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        return n;
    }

    protected void generateModifiedEmitters(JavaMethodBindingEmitter javaMethodBindingEmitter, List<FunctionEmitter> list) {
        ArrayList arrayList = new ArrayList();
        super.generateModifiedEmitters(javaMethodBindingEmitter, arrayList);
        boolean bl = this.bufferObjectMethodBindings.containsKey(javaMethodBindingEmitter.getBinding());
        for (Object object : arrayList) {
            if (object instanceof ProcAddressJavaMethodBindingEmitter) {
                object = new GLJavaMethodBindingEmitter((ProcAddressJavaMethodBindingEmitter)object, this, bl);
            }
            list.add((FunctionEmitter)object);
        }
    }

    protected boolean needsBufferObjectVariant(FunctionSymbol functionSymbol) {
        return this.getGLConfig().isBufferObjectFunction(functionSymbol.getName());
    }

    protected GLConfiguration getGLConfig() {
        return (GLConfiguration)this.getConfig();
    }

    protected void endProcAddressTable() throws Exception {
        PrintWriter printWriter = this.tableWriter;
        printWriter.println("  /**");
        printWriter.println("   * This is a convenience method to get (by name) the native function");
        printWriter.println("   * pointer for a given function. It lets you avoid having to");
        printWriter.println("   * manually compute the &quot;_addressof_ + ");
        printWriter.println("   * &lt;functionName&gt;&quot; member variable name and look it up via");
        printWriter.println("   * reflection; it also will throw an exception if you try to get the");
        printWriter.println("   * address of an unknown function, or one that is statically linked");
        printWriter.println("   * and therefore does not have a function pointer in this table.");
        printWriter.println("   *");
        printWriter.println("   * @throws RuntimeException if the function pointer was not found in");
        printWriter.println("   *   this table, either because the function was unknown or because");
        printWriter.println("   *   it was statically linked.");
        printWriter.println("   */");
        printWriter.println("  public long getAddressFor(String functionNameUsr) {");
        printWriter.println("    String functionNameBase = " + GLExtensionNames.class.getName() + ".normalizeVEN(com.jogamp.gluegen.runtime.opengl.GLExtensionNames.normalizeARB(functionNameUsr, true), true);");
        printWriter.println("    String addressFieldNameBase = PROCADDRESS_VAR_PREFIX + functionNameBase;");
        printWriter.println("    java.lang.reflect.Field addressField = null;");
        printWriter.println("    int  funcNamePermNum = " + GLExtensionNames.class.getName() + ".getFuncNamePermutationNumber(functionNameBase);");
        printWriter.println("    for(int i = 0; null==addressField && i < funcNamePermNum; i++) {");
        printWriter.println("        String addressFieldName = " + GLExtensionNames.class.getName() + ".getFuncNamePermutation(addressFieldNameBase, i);");
        printWriter.println("        try {");
        printWriter.println("          addressField = getClass().getField(addressFieldName);");
        printWriter.println("        } catch (Exception e) { }");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    if(null==addressField) {");
        printWriter.println("      // The user is calling a bogus function or one which is not");
        printWriter.println("      // runtime linked");
        printWriter.println("      throw new RuntimeException(");
        printWriter.println("          \"WARNING: Address field query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        printWriter.println("          \"\\\"; it's either statically linked or address field is not a known \" +");
        printWriter.println("          \"function\");");
        printWriter.println("    } ");
        printWriter.println("    try {");
        printWriter.println("      return addressField.getLong(this);");
        printWriter.println("    } catch (Exception e) {");
        printWriter.println("      throw new RuntimeException(");
        printWriter.println("          \"WARNING: Address query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        printWriter.println("          \"\\\"; it's either statically linked or is not a known \" +");
        printWriter.println("          \"function\", e);");
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println("} // end of class " + this.tableClassName);
        printWriter.flush();
        printWriter.close();
    }

    class ExtensionUnifier
    implements SymbolFilter {
        private List<ConstantDefinition> constants;
        private List<FunctionSymbol> functions;

        ExtensionUnifier() {
        }

        public void filterSymbols(List<ConstantDefinition> list, List<FunctionSymbol> list2) {
            this.constants = list;
            this.functions = list2;
            this.doWork();
        }

        public List<ConstantDefinition> getConstants() {
            return this.constants;
        }

        public List<FunctionSymbol> getFunctions() {
            return this.functions;
        }

        private void doWork() {
            BuildStaticGLInfo buildStaticGLInfo = GLEmitter.this.getGLConfig().getGLInfo();
            if (buildStaticGLInfo == null) {
                return;
            }
            LinkedHashMap<String, ConstantDefinition> linkedHashMap = new LinkedHashMap<String, ConstantDefinition>();
            for (ConstantDefinition object22 : this.constants) {
                linkedHashMap.put(object22.getName(), object22);
            }
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            for (FunctionSymbol functionSymbol : this.functions) {
                linkedHashMap2.put(functionSymbol.getName(), functionSymbol);
            }
            Set<String> set = buildStaticGLInfo.getExtensions();
            for (String string : set) {
                boolean bl;
                Set<String> set2 = buildStaticGLInfo.getDeclarations(string);
                boolean bl2 = true;
                boolean bl3 = true;
                String string2 = null;
                for (String string3 : set2) {
                    boolean bl4 = bl = !string3.startsWith("GL_");
                    if (!GLExtensionNames.isExtension(string3, bl)) {
                        bl2 = false;
                        break;
                    }
                    if (bl) {
                        if (!linkedHashMap2.containsKey(string3)) {
                            bl2 = false;
                            break;
                        }
                    } else if (!linkedHashMap.containsKey(string3)) {
                        bl2 = false;
                        break;
                    }
                    string2 = string3;
                    String string4 = GLExtensionNames.normalize(string3, bl);
                    bl3 = buildStaticGLInfo.getExtension(string4) != null;
                    if (bl3) continue;
                    break;
                }
                if (!bl2) continue;
                if (bl3) {
                    for (String string3 : set2) {
                        boolean bl5 = bl = !string3.startsWith("GL_");
                        if (bl) {
                            linkedHashMap2.remove(string3);
                            continue;
                        }
                        linkedHashMap.remove(string3);
                    }
                    System.err.println("INFO: unified extension " + string + " into core API");
                    continue;
                }
                System.err.println("INFO: didn't unify extension " + string + " into core API because of " + string2);
            }
            this.constants = new ArrayList(linkedHashMap.values());
            this.functions = new ArrayList(linkedHashMap2.values());
        }
    }

    static enum BufferObjectKind {
        UNPACK_PIXEL,
        PACK_PIXEL,
        ARRAY,
        ELEMENT;

    }
}

