/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildStaticGLInfo {
    protected static int funcIdentifierGroup = 10;
    protected static Pattern funcPattern = Pattern.compile("^(GLAPI|GL_API|GL_APICALL|EGLAPI|extern)?(\\s*)((unsigned|const)\\s+)?(\\w+)(\\s*\\*)?(\\s+)(GLAPIENTRY|GL_APIENTRY|APIENTRY|EGLAPIENTRY|WINAPI)?(\\s*)([ew]?gl\\w+)\\s?(\\(.*)");
    protected static Pattern associationPattern = Pattern.compile("\\#ifndef ([CEW]?GL[XU]?_[A-Za-z0-9_]+)(.*)");
    protected static int defineIdentifierGroup = 1;
    protected static Pattern definePattern = Pattern.compile("\\#define ([CEW]?GL[XU]?_[A-Za-z0-9_]+)\\s*([A-Za-z0-9_]+)(.*)");
    protected Map<String, String> declarationToExtensionMap = new HashMap<String, String>();
    protected Map<String, Set<String>> extensionToDeclarationMap = new HashMap<String, Set<String>>();
    protected boolean debug = false;

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2;
        Object object;
        if (stringArray.length > 0 && stringArray[0].equals("-test")) {
            object = new BuildStaticGLInfo();
            ((BuildStaticGLInfo)object).setDebug(true);
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            ((BuildStaticGLInfo)object).parse(stringArray2);
            ((BuildStaticGLInfo)object).dump();
            System.exit(0);
        }
        object = stringArray[0];
        stringArray2 = stringArray[1];
        String[] stringArray3 = new String[stringArray.length - 2];
        System.arraycopy(stringArray, 2, stringArray3, 0, stringArray3.length);
        BuildStaticGLInfo buildStaticGLInfo = new BuildStaticGLInfo();
        try {
            Object object2;
            buildStaticGLInfo.parse(stringArray3);
            File file = new File((String)stringArray2 + File.separatorChar + "StaticGLInfo.java");
            String string = file.getParent();
            if (string != null) {
                object2 = new File(string);
                ((File)object2).mkdirs();
            }
            object2 = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            buildStaticGLInfo.emitJavaCode((PrintWriter)object2, (String)object);
            ((PrintWriter)object2).flush();
            ((PrintWriter)object2).close();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder("{ ");
            for (int i = 0; i < stringArray3.length; ++i) {
                stringBuilder.append(stringArray3[i]);
                stringBuilder.append(" ");
            }
            stringBuilder.append('}');
            throw new RuntimeException("Error building StaticGLInfo.java from " + stringBuilder.toString(), exception);
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void parse(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.parse(stringArray[i]);
        }
    }

    public void parse(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string3 = null;
        Matcher matcher = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = 0;
            if (string3 != null) {
                String string4 = null;
                matcher = funcPattern.matcher(string2);
                if (matcher.matches()) {
                    string4 = matcher.group(funcIdentifierGroup).trim();
                    n = 2;
                } else {
                    matcher = definePattern.matcher(string2);
                    if (matcher.matches()) {
                        string4 = matcher.group(defineIdentifierGroup).trim();
                        n = 1;
                    } else if (string2.startsWith("#endif")) {
                        if (this.debug) {
                            System.err.println("END ASSOCIATION BLOCK: <" + string3 + ">");
                        }
                        string3 = null;
                    }
                }
                if (string4 == null || string3 == null || string4.equals(string3)) continue;
                this.addAssociation(string4, string3);
                if (!this.debug) continue;
                System.err.println("  ADDING ASSOCIATION: <" + string4 + "> <" + string3 + "> ; type " + n);
                continue;
            }
            matcher = associationPattern.matcher(string2);
            if (!matcher.matches()) continue;
            string3 = matcher.group(1).trim();
            if (!this.debug) continue;
            System.err.println("BEGIN ASSOCIATION BLOCK: <" + string3 + ">");
        }
        bufferedReader.close();
    }

    public void dump() {
        for (String string : this.extensionToDeclarationMap.keySet()) {
            Set<String> set = this.extensionToDeclarationMap.get(string);
            System.out.println("<" + string + "> :");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(set);
            Collections.sort(arrayList);
            for (String string2 : arrayList) {
                System.out.println("  <" + string2 + ">");
            }
        }
    }

    public String getExtension(String string) {
        return this.declarationToExtensionMap.get(string);
    }

    public Set<String> getDeclarations(String string) {
        return this.extensionToDeclarationMap.get(string);
    }

    public Set<String> getExtensions() {
        return this.extensionToDeclarationMap.keySet();
    }

    public void emitJavaCode(PrintWriter printWriter, String string) {
        printWriter.println("package " + string + ";");
        printWriter.println();
        printWriter.println("import java.util.*;");
        printWriter.println();
        printWriter.println("public final class StaticGLInfo");
        printWriter.println("{");
        printWriter.println("  // maps function names to the extension string or OpenGL");
        printWriter.println("  // specification version string to which they correspond.");
        printWriter.println("  private static HashMap funcToAssocMap;");
        printWriter.println();
        printWriter.println("  /**");
        printWriter.println("   * Returns the OpenGL extension string or GL_VERSION string with which the");
        printWriter.println("   * given function is associated. <P>");
        printWriter.println("   *");
        printWriter.println("   * If the");
        printWriter.println("   * function is part of the OpenGL core, the returned value will be");
        printWriter.println("   * GL_VERSION_XXX where XXX represents the OpenGL version of which the");
        printWriter.println("   * function is a member (XXX will be of the form \"A\" or \"A_B\" or \"A_B_C\";");
        printWriter.println("   * e.g., GL_VERSION_1_2_1 for OpenGL version 1.2.1).");
        printWriter.println("   *");
        printWriter.println("   * If the function is an extension function, the returned value will the");
        printWriter.println("   * OpenGL extension string for the extension to which the function");
        printWriter.println("   * corresponds. For example, if glLoadTransposeMatrixfARB is the argument,");
        printWriter.println("   * GL_ARB_transpose_matrix will be the value returned.");
        printWriter.println("   * Please see http://oss.sgi.com/projects/ogl-sample/registry/index.html for");
        printWriter.println("   * a list of extension names and the functions they expose.");
        printWriter.println("   *");
        printWriter.println("   * If the function specified is not part of any known OpenGL core version or");
        printWriter.println("   * extension, then NULL will be returned.");
        printWriter.println("   */");
        printWriter.println("  public static String getFunctionAssociation(String glFunctionName)");
        printWriter.println("  {");
        printWriter.println("    String mappedName = null;");
        printWriter.println("    int  funcNamePermNum = com.jogamp.gluegen.runtime.opengl.GLExtensionNames.getFuncNamePermutationNumber(glFunctionName);");
        printWriter.println("    for(int i = 0; null==mappedName && i < funcNamePermNum; i++) {");
        printWriter.println("        String tmp = com.jogamp.gluegen.runtime.opengl.GLExtensionNames.getFuncNamePermutation(glFunctionName, i);");
        printWriter.println("        try {");
        printWriter.println("          mappedName = (String)funcToAssocMap.get(tmp);");
        printWriter.println("        } catch (Exception e) { }");
        printWriter.println("    }");
        printWriter.println("    return mappedName;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  static");
        printWriter.println("  {");
        int n = 0;
        for (String object2 : this.declarationToExtensionMap.keySet()) {
            if (object2.startsWith("GL")) continue;
            ++n;
        }
        printWriter.println("    funcToAssocMap = new HashMap(" + n + "); // approximate max capacity");
        printWriter.println("    String group;");
        ArrayList<String> arrayList = new ArrayList<String>(this.extensionToDeclarationMap.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Set<String> set = this.extensionToDeclarationMap.get(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.addAll(set);
            Collections.sort(arrayList2);
            Iterator iterator2 = arrayList2.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                if (string3.startsWith("GL")) continue;
                if (!bl) {
                    printWriter.println();
                    printWriter.println("    //----------------------------------------------------------------");
                    printWriter.println("    //                 " + string2);
                    printWriter.println("    //----------------------------------------------------------------");
                    printWriter.println("    group = \"" + string2 + "\";");
                    bl = true;
                }
                printWriter.println("    funcToAssocMap.put(\"" + string3 + "\", group);");
            }
        }
        printWriter.println("  }");
        printWriter.println("} // end class StaticGLInfo");
    }

    protected void addAssociation(String string, String string2) {
        this.declarationToExtensionMap.put(string, string2);
        Set<String> set = this.extensionToDeclarationMap.get(string2);
        if (set == null) {
            set = new HashSet<String>();
            this.extensionToDeclarationMap.put(string2, set);
        }
        set.add(string);
    }
}

