/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CL;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLI;
import com.jogamp.opencl.gl.CLGLImage2d;
import com.jogamp.opencl.gl.CLGLTexture;
import com.jogamp.opencl.impl.CLImageFormatImpl;
import java.nio.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLGLTexture2d<B extends Buffer>
extends CLGLImage2d<B>
implements CLGLTexture {
    public final int target;
    public final int mipMapLevel;

    public CLGLTexture2d(CLContext context, B directBuffer, CLImageFormat format, CLImage.CLImageInfoAccessor accessor, int target, int mipLevel, int width, int height, long id, int glid, int flags) {
        super(context, directBuffer, format, accessor, width, height, id, glid, flags);
        this.target = target;
        this.mipMapLevel = mipLevel;
    }

    static <B extends Buffer> CLGLTexture2d<B> createFromGLTexture2d(CLContext context, B directBuffer, int target, int texture, int mipLevel, int flags) {
        CLGLBuffer.checkBuffer(directBuffer, flags);
        CL cl = CLGLTexture2d.getCL(context);
        int[] result = new int[1];
        CLGLI clgli = (CLGLI)cl;
        long id = clgli.clCreateFromGLTexture2D(context.ID, flags, target, mipLevel, texture, result, 0);
        CLImage.CLImageInfoAccessor accessor = new CLImage.CLImageInfoAccessor(cl, id);
        CLImageFormat format = CLGLTexture2d.createUninitializedImageFormat();
        accessor.getInfo(4368, CLImageFormatImpl.size(), format.getFormatImpl().getBuffer(), null);
        int width = (int)accessor.getLong(4372);
        int height = (int)accessor.getLong(4373);
        return new CLGLTexture2d<B>(context, directBuffer, format, accessor, target, mipLevel, width, height, id, texture, flags);
    }

    @Override
    public int getTextureTarget() {
        return this.target;
    }

    @Override
    public int getMipMapLevel() {
        return this.mipMapLevel;
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_TEXTURE2D;
    }
}

