/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.util.CLBuildConfiguration;
import com.jogamp.opencl.util.CLBuildListener;
import com.jogamp.opencl.util.CLProgramConfiguration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLProgramBuilder
implements CLProgramConfiguration,
Serializable {
    static final long serialVersionUID = 42L;
    private static final byte[] NO_BINARIES = new byte[0];
    private transient CLProgram program;
    private transient Map<CLDevice, byte[]> binariesMap = new LinkedHashMap<CLDevice, byte[]>();
    private String source;
    private final Set<String> optionSet = new LinkedHashSet<String>();
    private final Set<String> defineSet = new LinkedHashSet<String>();

    private CLProgramBuilder() {
        this(null);
    }

    private CLProgramBuilder(CLProgram program) {
        this(program, null, null);
    }

    private CLProgramBuilder(CLProgram program, String source, Map<CLDevice, byte[]> map) {
        this.program = program;
        this.source = source;
        if (map != null) {
            this.binariesMap.putAll(map);
        }
    }

    public static CLBuildConfiguration createConfiguration() {
        return CLProgramBuilder.createConfiguration(null);
    }

    public static CLProgramConfiguration createConfiguration(CLProgram program) {
        return new CLProgramBuilder(program);
    }

    public static CLBuildConfiguration loadConfiguration(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (CLBuildConfiguration)ois.readObject();
    }

    public static CLProgramConfiguration loadConfiguration(ObjectInputStream ois, CLContext context) throws IOException, ClassNotFoundException {
        CLProgramBuilder config = (CLProgramBuilder)ois.readObject();
        if (config.binariesMap.size() > 0 && config.binariesMap.values().iterator().next().length > 0) {
            try {
                config.program = context.createProgram(config.binariesMap);
            }
            catch (CLException.CLInvalidBinaryException ex) {
                if (config.source != null) {
                    config.program = context.createProgram(config.source);
                }
                throw new IOException("Program configuration contained invalid program binaries and no source.", ex);
            }
        } else if (config.source != null) {
            config.program = context.createProgram(config.source);
        } else {
            throw new IOException("Program configuration did not contain program sources or binaries");
        }
        return config;
    }

    @Override
    public void save(ObjectOutputStream oos) throws IOException {
        if (this.program != null) {
            this.source = this.program.getSource();
            if (this.program.isExecutable()) {
                this.binariesMap = this.program.getBinaries();
            }
        }
        oos.writeObject(this);
    }

    @Override
    public CLProgramBuilder withOption(String option) {
        this.optionSet.add(option);
        return this;
    }

    @Override
    public CLProgramBuilder withOptions(String ... options) {
        for (String option : options) {
            this.optionSet.add(option);
        }
        return this;
    }

    @Override
    public CLProgramBuilder withDefine(String name) {
        this.defineSet.add(CLProgram.define(name));
        return this;
    }

    @Override
    public CLProgramBuilder withDefines(String ... names) {
        for (String name : names) {
            this.defineSet.add(CLProgram.define(name));
        }
        return this;
    }

    @Override
    public CLProgramBuilder withDefine(String name, Object value) {
        this.defineSet.add(CLProgram.define(name, value.toString()));
        return this;
    }

    @Override
    public CLProgramBuilder withDefines(Map<String, ? extends Object> defines) {
        for (String name : defines.keySet()) {
            this.defineSet.add(CLProgram.define(name, defines.get(name)));
        }
        return this;
    }

    @Override
    public CLProgramBuilder forDevice(CLDevice device) {
        this.binariesMap.put(device, NO_BINARIES);
        return this;
    }

    @Override
    public CLProgramBuilder forDevices(CLDevice ... devices) {
        for (CLDevice device : devices) {
            this.binariesMap.put(device, NO_BINARIES);
        }
        return this;
    }

    @Override
    public CLProgram build() {
        return this.build(this.program, null);
    }

    @Override
    public CLProgram build(CLBuildListener listener) {
        return this.build(this.program, listener);
    }

    @Override
    public CLProgram build(CLProgram program) {
        return this.build(program, null);
    }

    @Override
    public CLProgram build(CLProgram program, CLBuildListener listener) {
        if (program == null) {
            throw new NullPointerException("no program has been set");
        }
        ArrayList<String> setup = new ArrayList<String>();
        setup.addAll(this.optionSet);
        setup.addAll(this.defineSet);
        String options = CLProgram.optionsOf(setup.toArray(new String[setup.size()]));
        CLDevice[] devices = this.binariesMap.keySet().toArray(new CLDevice[this.binariesMap.size()]);
        return program.build(listener, options, devices);
    }

    @Override
    public CLProgramBuilder reset() {
        this.resetOptions();
        this.resetDefines();
        this.resetDevices();
        return this;
    }

    @Override
    public CLProgramConfiguration resetDefines() {
        this.defineSet.clear();
        return this;
    }

    @Override
    public CLProgramConfiguration resetDevices() {
        this.binariesMap.clear();
        return this;
    }

    @Override
    public CLProgramConfiguration resetOptions() {
        this.optionSet.clear();
        return this;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Set<CLDevice> devices = this.binariesMap.keySet();
        String suffix = devices.iterator().next().getPlatform().getICDSuffix();
        out.writeUTF(suffix);
        out.writeInt(this.binariesMap.size());
        for (CLDevice device : devices) {
            byte[] binaries = this.binariesMap.get(device);
            out.writeLong(device.ID);
            out.writeInt(binaries.length);
            out.write(binaries);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String suffix = in.readUTF();
        CLPlatform platform = null;
        for (CLPlatform p : CLPlatform.listCLPlatforms()) {
            if (!p.getICDSuffix().equals(suffix)) continue;
            platform = p;
            break;
        }
        this.binariesMap = new LinkedHashMap<CLDevice, byte[]>();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            long deviceID = in.readLong();
            int length = in.readInt();
            byte[] binaries = new byte[length];
            in.readFully(binaries);
            CLDevice device = new CLDevice(CLPlatform.getLowLevelCLInterface(), platform, deviceID);
            this.binariesMap.put(device, binaries);
        }
    }

    @Override
    public CLProgramBuilder asBuildConfiguration() {
        CLProgramBuilder builder = new CLProgramBuilder();
        builder.defineSet.addAll(this.defineSet);
        builder.optionSet.addAll(this.optionSet);
        return builder;
    }

    @Override
    public CLProgramBuilder clone() {
        CLProgramBuilder builder = new CLProgramBuilder(this.program, this.source, this.binariesMap);
        builder.defineSet.addAll(this.defineSet);
        builder.optionSet.addAll(this.optionSet);
        return builder;
    }

    @Override
    public CLProgram getProgram() {
        return this.program;
    }

    @Override
    public CLProgramBuilder setProgram(CLProgram program) {
        this.program = program;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CLProgramBuilder");
        sb.append("{options=").append(this.optionSet);
        sb.append(", defines=").append(this.defineSet);
        sb.append(", devices=").append(this.binariesMap);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CLProgramBuilder that = (CLProgramBuilder)o;
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.defineSet != null ? !((Object)this.defineSet).equals(that.defineSet) : that.defineSet != null) {
            return false;
        }
        if (this.optionSet != null ? !((Object)this.optionSet).equals(that.optionSet) : that.optionSet != null) {
            return false;
        }
        if (this.binariesMap != null && that.binariesMap != null) {
            if (this.binariesMap.size() != that.binariesMap.size()) {
                return false;
            }
            Iterator<CLDevice> iterator0 = this.binariesMap.keySet().iterator();
            Iterator<CLDevice> iterator1 = that.binariesMap.keySet().iterator();
            for (int i = 0; i < this.binariesMap.size(); ++i) {
                CLDevice device1;
                CLDevice device0 = iterator0.next();
                if (device0.equals(device1 = iterator1.next()) && Arrays.equals(this.binariesMap.get(device0), that.binariesMap.get(device1))) continue;
                return false;
            }
        } else if (this.binariesMap != null || that.binariesMap != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.optionSet != null ? ((Object)this.optionSet).hashCode() : 0;
        result = 31 * result + (this.defineSet != null ? ((Object)this.defineSet).hashCode() : 0);
        result = 31 * result + (this.binariesMap != null ? ((Object)this.binariesMap).hashCode() : 0);
        return result;
    }
}

