/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.opencl.CL;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLProperty;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.JOCLJNILibLoader;
import com.jogamp.opencl.impl.CLImpl;
import com.jogamp.opencl.impl.CLProcAddressTable;
import com.jogamp.opencl.util.CLUtil;
import com.jogamp.opencl.util.Filter;
import com.jogamp.opencl.util.JOCLVersion;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLPlatform {
    public final long ID;
    public final CLVersion version;
    private static CL cl;
    private Set<String> extensions;

    private CLPlatform(long id) {
        this.ID = id;
        this.version = new CLVersion(this.getInfoString(2305));
    }

    public static synchronized void initialize() throws JogampRuntimeException {
        if (cl != null) {
            return;
        }
        try {
            final CLProcAddressTable table = new CLProcAddressTable(new FunctionAddressResolver(){

                public long resolve(String name, DynamicLookupHelper lookup) {
                    long address;
                    if (name.endsWith("Impl")) {
                        name = name.substring(0, name.length() - "Impl".length());
                    }
                    if ((name.endsWith("KHR") || name.endsWith("EXT")) && (address = ((CLImpl)cl).clGetExtensionFunctionAddress(name)) != 0L) {
                        return address;
                    }
                    return lookup.dynamicLookupFunction(name);
                }
            });
            cl = new CLImpl(table);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    NativeLibrary libOpenCL = JOCLJNILibLoader.loadOpenCL();
                    if (libOpenCL == null) {
                        throw new JogampRuntimeException("OpenCL library not found.");
                    }
                    table.initEntry("clGetExtensionFunctionAddressImpl", (DynamicLookupHelper)libOpenCL);
                    table.reset((DynamicLookupHelper)libOpenCL);
                    return null;
                }
            });
        }
        catch (UnsatisfiedLinkError ex) {
            System.err.println(JOCLVersion.getAllVersions());
            throw ex;
        }
        catch (Exception ex) {
            System.err.println(JOCLVersion.getAllVersions());
            throw new JogampRuntimeException("JOCL initialization error.", (Throwable)ex);
        }
    }

    public static CLPlatform getDefault() {
        CLPlatform.initialize();
        return CLPlatform.latest(CLPlatform.listCLPlatforms());
    }

    public static CLPlatform getDefault(Filter<CLPlatform> ... filter) {
        CLPlatform[] platforms = CLPlatform.listCLPlatforms(filter);
        if (platforms.length > 0) {
            return CLPlatform.latest(platforms);
        }
        return null;
    }

    private static CLPlatform latest(CLPlatform[] platforms) {
        CLPlatform best = platforms[0];
        for (CLPlatform platform : platforms) {
            if (platform.version.compareTo(best.version) <= 0) continue;
            best = platform;
        }
        return best;
    }

    public static CLPlatform[] listCLPlatforms() {
        return CLPlatform.listCLPlatforms(null);
    }

    public static CLPlatform[] listCLPlatforms(Filter<CLPlatform> ... filter) {
        CLPlatform.initialize();
        IntBuffer ib = Buffers.newDirectIntBuffer((int)1);
        int ret = cl.clGetPlatformIDs(0, null, ib);
        CLException.checkForError(ret, "can not enumerate platforms");
        PointerBuffer platformId = PointerBuffer.allocateDirect((int)ib.get(0));
        ret = cl.clGetPlatformIDs(platformId.capacity(), platformId, null);
        CLException.checkForError(ret, "can not enumerate platforms");
        ArrayList<CLPlatform> platforms = new ArrayList<CLPlatform>();
        for (int i = 0; i < platformId.capacity(); ++i) {
            CLPlatform platform = new CLPlatform(platformId.get(i));
            if (filter == null) {
                platforms.add(platform);
                continue;
            }
            boolean accepted = true;
            for (Filter<CLPlatform> f : filter) {
                if (f.accept(platform)) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            platforms.add(platform);
        }
        return platforms.toArray(new CLPlatform[platforms.size()]);
    }

    public static CL getLowLevelCLInterface() {
        CLPlatform.initialize();
        return cl;
    }

    public static void unloadCompiler() {
        CLPlatform.initialize();
        int ret = cl.clUnloadCompiler();
        CLException.checkForError(ret, "error while sending unload compiler hint");
    }

    public CLDevice[] listCLDevices() {
        return this.listCLDevices(CLDevice.Type.ALL);
    }

    public CLDevice[] listCLDevices(CLDevice.Type ... types) {
        CLPlatform.initialize();
        IntBuffer ib = Buffers.newDirectIntBuffer((int)1);
        ArrayList<CLDevice> list = new ArrayList<CLDevice>();
        for (int t = 0; t < types.length; ++t) {
            CLDevice.Type type = types[t];
            int ret = cl.clGetDeviceIDs(this.ID, type.TYPE, 0, null, ib);
            if (ret == -1) continue;
            CLException.checkForError(ret, "error while enumerating devices");
            PointerBuffer deviceIDs = PointerBuffer.allocateDirect((int)ib.get(0));
            ret = cl.clGetDeviceIDs(this.ID, type.TYPE, deviceIDs.capacity(), deviceIDs, null);
            CLException.checkForError(ret, "error while enumerating devices");
            for (int n = 0; n < deviceIDs.capacity(); ++n) {
                list.add(new CLDevice(cl, this, deviceIDs.get(n)));
            }
        }
        CLDevice[] devices = new CLDevice[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            devices[i] = (CLDevice)list.get(i);
        }
        return devices;
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] devices) {
        return CLPlatform.findMaxFlopsDevice(devices, null);
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] devices, CLDevice.Type type) {
        CLPlatform.initialize();
        CLDevice maxFLOPSDevice = null;
        int maxflops = -1;
        for (int i = 0; i < devices.length; ++i) {
            int maxClockFrequency;
            int maxComputeUnits;
            int flops;
            CLDevice device = devices[i];
            if (type != null && !type.equals((Object)device.getType()) || (flops = (maxComputeUnits = device.getMaxComputeUnits()) * (maxClockFrequency = device.getMaxClockFrequency())) <= maxflops) continue;
            maxflops = flops;
            maxFLOPSDevice = device;
        }
        return maxFLOPSDevice;
    }

    public CLDevice getMaxFlopsDevice() {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices());
    }

    public CLDevice getMaxFlopsDevice(CLDevice.Type ... types) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(types));
    }

    @CLProperty(value="CL_PLATFORM_NAME")
    public String getName() {
        return this.getInfoString(2306);
    }

    @CLProperty(value="CL_PLATFORM_VERSION")
    public CLVersion getVersion() {
        return this.version;
    }

    public String getSpecVersion() {
        return this.version.getSpecVersion();
    }

    public boolean isAtLeast(CLVersion other) {
        return this.version.isAtLeast(other);
    }

    public boolean isAtLeast(int major, int minor) {
        return this.version.isAtLeast(major, minor);
    }

    @CLProperty(value="CL_PLATFORM_PROFILE")
    public String getProfile() {
        return this.getInfoString(2304);
    }

    @CLProperty(value="CL_PLATFORM_VENDOR")
    public String getVendor() {
        return this.getInfoString(2307);
    }

    @CLProperty(value="CL_PLATFORM_ICD_SUFFIX_KHR")
    public String getICDSuffix() {
        return this.getInfoString(2336);
    }

    public boolean isExtensionAvailable(String extension) {
        return this.getExtensions().contains(extension);
    }

    @CLProperty(value="CL_PLATFORM_EXTENSIONS")
    public Set<String> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>();
            String ext = this.getInfoString(2308);
            Scanner scanner = new Scanner(ext);
            while (scanner.hasNext()) {
                this.extensions.add(scanner.next());
            }
            this.extensions = Collections.unmodifiableSet(this.extensions);
        }
        return this.extensions;
    }

    public Map<String, String> getProperties() {
        return CLUtil.obtainPlatformProperties(this);
    }

    public String getInfoString(int key) {
        PointerBuffer size = PointerBuffer.allocateDirect((int)1);
        ByteBuffer bb = ByteBuffer.allocateDirect(512);
        int ret = cl.clGetPlatformInfo(this.ID, key, bb.capacity(), bb, size);
        CLException.checkForError(ret, "can not receive info string");
        return CLUtil.clString2JavaString(bb, (int)size.get(0));
    }

    public String toString() {
        return "CLPlatform [name:" + this.getName() + " vendor:" + this.getVendor() + " profile:" + this.getProfile() + " version:" + this.getVersion() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLPlatform other = (CLPlatform)obj;
        return this.ID == other.ID;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (int)(this.ID ^ this.ID >>> 32);
        return hash;
    }
}

