/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.opencl.impl.CLImageFormatImpl;

public final class CLImageFormat {
    private final CLImageFormatImpl format;

    CLImageFormat() {
        this.format = CLImageFormatImpl.create();
    }

    CLImageFormat(CLImageFormatImpl format) {
        this.format = format;
    }

    public CLImageFormat(ChannelOrder order, ChannelType type) {
        this.format = CLImageFormatImpl.create();
        this.setImageChannelOrder(order);
        this.setImageChannelDataType(type);
    }

    public CLImageFormat setImageChannelOrder(ChannelOrder order) {
        this.format.setImageChannelOrder(order.ORDER);
        return this;
    }

    public CLImageFormat setImageChannelDataType(ChannelType type) {
        this.format.setImageChannelDataType(type.TYPE);
        return this;
    }

    public ChannelOrder getImageChannelOrder() {
        return ChannelOrder.valueOf(this.format.getImageChannelOrder());
    }

    public ChannelType getImageChannelDataType() {
        return ChannelType.valueOf(this.format.getImageChannelDataType());
    }

    public CLImageFormatImpl getFormatImpl() {
        return this.format;
    }

    public String toString() {
        return "CLImageFormat[" + (Object)((Object)this.getImageChannelOrder()) + " " + (Object)((Object)this.getImageChannelDataType()) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLImageFormat other = (CLImageFormat)obj;
        if (this.getImageChannelDataType() != other.getImageChannelDataType()) {
            return false;
        }
        return this.getImageChannelOrder() == other.getImageChannelOrder();
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.getImageChannelDataType() != null ? this.getImageChannelDataType().hashCode() : 0);
        hash = 47 * hash + (this.getImageChannelOrder() != null ? this.getImageChannelOrder().hashCode() : 0);
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelType {
        SNORM_INT8(4304),
        SNORM_INT16(4305),
        UNORM_INT8(4306),
        UNORM_INT16(4307),
        UNORM_SHORT_565(4308),
        UNORM_SHORT_555(4309),
        UNORM_INT_101010(4310),
        SIGNED_INT8(4311),
        SIGNED_INT16(4312),
        SIGNED_INT32(4313),
        UNSIGNED_INT8(4314),
        UNSIGNED_INT16(4315),
        UNSIGNED_INT32(4316),
        HALF_FLOAT(4317),
        FLOAT(4318);

        public final int TYPE;

        private ChannelType(int channel) {
            this.TYPE = channel;
        }

        public static ChannelType valueOf(int channelFlag) {
            switch (channelFlag) {
                case 4304: {
                    return SNORM_INT8;
                }
                case 4305: {
                    return SNORM_INT16;
                }
                case 4306: {
                    return UNORM_INT8;
                }
                case 4307: {
                    return UNORM_INT16;
                }
                case 4308: {
                    return UNORM_SHORT_565;
                }
                case 4309: {
                    return UNORM_SHORT_555;
                }
                case 4310: {
                    return UNORM_INT_101010;
                }
                case 4311: {
                    return SIGNED_INT8;
                }
                case 4312: {
                    return SIGNED_INT16;
                }
                case 4313: {
                    return SIGNED_INT32;
                }
                case 4314: {
                    return UNSIGNED_INT8;
                }
                case 4315: {
                    return UNSIGNED_INT16;
                }
                case 4316: {
                    return UNSIGNED_INT32;
                }
                case 4317: {
                    return HALF_FLOAT;
                }
                case 4318: {
                    return FLOAT;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelOrder {
        R(4272),
        Rx(4282),
        A(4273),
        RG(4274),
        RGx(4283),
        RA(4275),
        RGB(4276),
        RGBx(4284),
        RGBA(4277),
        ARGB(4279),
        BGRA(4278),
        INTENSITY(4280),
        LUMINANCE(4281);

        public final int ORDER;

        private ChannelOrder(int order) {
            this.ORDER = order;
        }

        public static ChannelOrder valueOf(int orderFlag) {
            switch (orderFlag) {
                case 4272: {
                    return R;
                }
                case 4282: {
                    return Rx;
                }
                case 4273: {
                    return A;
                }
                case 4280: {
                    return INTENSITY;
                }
                case 4281: {
                    return LUMINANCE;
                }
                case 4274: {
                    return RG;
                }
                case 4283: {
                    return RGx;
                }
                case 4275: {
                    return RA;
                }
                case 4276: {
                    return RGB;
                }
                case 4284: {
                    return RGBx;
                }
                case 4277: {
                    return RGBA;
                }
                case 4279: {
                    return ARGB;
                }
                case 4278: {
                    return BGRA;
                }
            }
            return null;
        }
    }
}

