/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opencl.CL;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImageFormat;
import java.nio.Buffer;
import java.nio.IntBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLImage2d<B extends Buffer>
extends CLImage<B> {
    private CLImage2d(CLContext context, B directBuffer, CLImageFormat format, int width, int height, long id, int flags) {
        super(context, directBuffer, format, width, height, id, flags);
    }

    protected CLImage2d(CLContext context, B directBuffer, CLImageFormat format, CLImage.CLImageInfoAccessor accessor, int width, int height, long id, int flags) {
        super(context, directBuffer, format, accessor, width, height, id, flags);
    }

    static <B extends Buffer> CLImage2d<B> createImage(CLContext context, B directBuffer, int width, int height, int rowPitch, CLImageFormat format, int flags) {
        CL cl = context.cl;
        IntBuffer err = Buffers.newDirectIntBuffer((int)1);
        Buffer host_ptr = null;
        if (CLImage2d.isHostPointerFlag(flags)) {
            host_ptr = directBuffer;
        }
        long id = cl.clCreateImage2D(context.ID, flags, format.getFormatImpl(), width, height, rowPitch, host_ptr, err);
        CLException.checkForError(err.get(), "can not create 2d image");
        return new CLImage2d<B>(context, directBuffer, format, width, height, id, flags);
    }

    @Override
    public <T extends Buffer> CLImage2d<T> cloneWith(T directBuffer) {
        return new CLImage2d<T>(this.context, directBuffer, this.format, this.width, this.height, this.ID, this.FLAGS);
    }

    @Override
    public String toString() {
        return "CLImage2d [id: " + this.ID + " width: " + this.width + " height: " + this.height + "]";
    }
}

