/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CL;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLInfoAccessor;
import com.jogamp.opencl.CLMemory;
import java.nio.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLImage<B extends Buffer>
extends CLMemory<B> {
    protected CLImageFormat format;
    final CLInfoAccessor imageInfo;
    public final int width;
    public final int height;

    protected CLImage(CLContext context, B directBuffer, CLImageFormat format, int width, int height, long id, int flags) {
        this(context, directBuffer, format, new CLImageInfoAccessor(context.cl, id), width, height, id, flags);
    }

    protected CLImage(CLContext context, B directBuffer, CLImageFormat format, CLImageInfoAccessor accessor, int width, int height, long id, int flags) {
        super(context, directBuffer, CLImage.getSizeImpl(context.cl, id), id, flags);
        this.imageInfo = accessor;
        this.format = format;
        this.width = width;
        this.height = height;
    }

    protected static CLImageFormat createUninitializedImageFormat() {
        return new CLImageFormat();
    }

    public CLImageFormat getFormat() {
        return this.format;
    }

    public int getElementSize() {
        return (int)this.imageInfo.getLong(4369);
    }

    public int getRowPitch() {
        return (int)this.imageInfo.getLong(4370);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected static final class CLImageInfoAccessor
    extends CLInfoAccessor {
        private final long id;
        private final CL cl;

        public CLImageInfoAccessor(CL cl, long id) {
            this.cl = cl;
            this.id = id;
        }

        public int getInfo(int name, long valueSize, Buffer value, PointerBuffer valueSizeRet) {
            return this.cl.clGetImageInfo(this.id, name, valueSize, value, valueSizeRet);
        }
    }
}

