/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.newt.Display;
import com.jogamp.newt.impl.Debug;
import com.jogamp.newt.impl.NEWTJNILibLoader;
import com.jogamp.newt.util.EDTUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;

public class MainThread
implements EDTUtil {
    private static AccessControlContext localACC = AccessController.getContext();
    public static final boolean MAIN_THREAD_CRITERIA = !NativeWindowFactory.isAWTAvailable() && "MacOSX".equals(NativeWindowFactory.getNativeWindowType((boolean)false)) || Debug.getBooleanProperty("newt.MainThread.force", true, localACC);
    protected static final boolean DEBUG = Debug.debug("MainThread");
    private static MainThread singletonMainThread = new MainThread();
    private static boolean isExit = false;
    private static volatile boolean isRunning = false;
    private static Object taskWorkerLock = new Object();
    private static boolean shouldStop;
    private static ArrayList tasks;
    private static Thread mainThread;
    private static Timer pumpMessagesTimer;
    private static TimerTask pumpMessagesTimerTask;
    private static Map pumpMessageDisplayMap;
    private static boolean useMainThread;
    private static Class cAWTEventQueue;
    private static Method mAWTInvokeAndWait;
    private static Method mAWTInvokeLater;
    private static Method mAWTIsDispatchThread;
    private static MainAction mainAction;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] stringArray) {
        useMainThread = MAIN_THREAD_CRITERIA;
        if (DEBUG) {
            System.err.println("MainThread.main(): " + Thread.currentThread().getName() + " useMainThread " + useMainThread);
        }
        if (stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        if (stringArray.length > 1) {
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        }
        NEWTJNILibLoader.loadNEWT();
        mainAction = new MainAction(string, stringArray2);
        if ("MacOSX".equals(NativeWindowFactory.getNativeWindowType((boolean)false))) {
            ReflectionUtil.callStaticMethod((String)"com.jogamp.newt.impl.macosx.MacDisplay", (String)"initSingleton", null, null, (ClassLoader)MainThread.class.getClassLoader());
        }
        if (useMainThread) {
            shouldStop = false;
            tasks = new ArrayList();
            mainThread = Thread.currentThread();
            mainAction.start();
            singletonMainThread.run();
        } else {
            mainAction.run();
        }
    }

    public static final MainThread getSingleton() {
        return singletonMainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runnable removePumpMessage(Display display) {
        Map map = pumpMessageDisplayMap;
        synchronized (map) {
            return (Runnable)pumpMessageDisplayMap.remove(display);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPumpMessage(Display display, Runnable runnable) {
        Object object;
        if (useMainThread) {
            return;
        }
        if (null == pumpMessagesTimer) {
            object = MainThread.class;
            synchronized (object) {
                if (null == pumpMessagesTimer) {
                    pumpMessagesTimer = new Timer();
                    pumpMessagesTimerTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Map map = pumpMessageDisplayMap;
                            synchronized (map) {
                                Iterator iterator = pumpMessageDisplayMap.values().iterator();
                                while (iterator.hasNext()) {
                                    ((Runnable)iterator.next()).run();
                                }
                            }
                        }
                    };
                    pumpMessagesTimer.scheduleAtFixedRate(pumpMessagesTimerTask, 0L, 10L);
                }
            }
        }
        object = pumpMessageDisplayMap;
        synchronized (object) {
            pumpMessageDisplayMap.put(display, runnable);
        }
    }

    private void initAWTReflection() {
        if (null == cAWTEventQueue) {
            ClassLoader classLoader = MainThread.class.getClassLoader();
            cAWTEventQueue = ReflectionUtil.getClass((String)"java.awt.EventQueue", (boolean)true, (ClassLoader)classLoader);
            mAWTInvokeAndWait = ReflectionUtil.getMethod((Class)cAWTEventQueue, (String)"invokeAndWait", (Class[])new Class[]{Runnable.class}, (ClassLoader)classLoader);
            mAWTInvokeLater = ReflectionUtil.getMethod((Class)cAWTEventQueue, (String)"invokeLater", (Class[])new Class[]{Runnable.class}, (ClassLoader)classLoader);
            mAWTIsDispatchThread = ReflectionUtil.getMethod((Class)cAWTEventQueue, (String)"isDispatchThread", (Class[])new Class[0], (ClassLoader)classLoader);
        }
    }

    public void reset() {
    }

    public void start() {
    }

    public boolean isCurrentThreadEDT() {
        if (NativeWindowFactory.isAWTAvailable()) {
            this.initAWTReflection();
            return (Boolean)ReflectionUtil.callMethod(null, (Method)mAWTIsDispatchThread, null);
        }
        return this.isRunning() && mainThread == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        if (useMainThread) {
            Object object = taskWorkerLock;
            synchronized (object) {
                return isRunning;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeLater(Runnable runnable) {
        Object object = taskWorkerLock;
        synchronized (object) {
            if (this.isRunning() && mainThread != Thread.currentThread()) {
                tasks.add(runnable);
                taskWorkerLock.notifyAll();
            } else {
                runnable.run();
            }
        }
    }

    public void invokeStop(Runnable runnable) {
        this.invokeImpl(true, runnable, true);
    }

    public void invoke(boolean bl, Runnable runnable) {
        this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        if (runnable == null) {
            return;
        }
        if (NativeWindowFactory.isAWTAvailable()) {
            this.initAWTReflection();
            try {
                if (((Boolean)ReflectionUtil.callMethod(null, (Method)mAWTIsDispatchThread, null)).booleanValue()) {
                    runnable.run();
                    return;
                }
                if (bl) {
                    ReflectionUtil.callMethod(null, (Method)mAWTInvokeAndWait, (Object[])new Object[]{runnable});
                } else {
                    ReflectionUtil.callMethod(null, (Method)mAWTInvokeLater, (Object[])new Object[]{runnable});
                }
            }
            catch (Exception exception) {
                throw new NativeWindowException((Throwable)exception);
            }
            return;
        }
        if (!this.isRunning() || mainThread == Thread.currentThread()) {
            runnable.run();
            return;
        }
        boolean bl3 = bl && this.isRunning() && mainThread != Thread.currentThread();
        Object object = new Object();
        RunnableTask runnableTask = new RunnableTask(runnable, bl3 ? object : null, true);
        Throwable throwable = null;
        Object object2 = object;
        synchronized (object2) {
            this.invokeLater((Runnable)runnableTask);
            Object object3 = taskWorkerLock;
            synchronized (object3) {
                if (isRunning) {
                    shouldStop = true;
                    if (DEBUG) {
                        System.err.println("MainThread.stop(): " + Thread.currentThread().getName() + " start");
                    }
                }
                taskWorkerLock.notifyAll();
            }
            if (bl3) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
            }
        }
        if (null == throwable) {
            throwable = runnableTask.getThrowable();
        }
        if (null != throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void waitUntilIdle() {
    }

    public void waitUntilStopped() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilRunning() {
        Object object = taskWorkerLock;
        synchronized (object) {
            if (isExit) {
                return;
            }
            while (!isRunning) {
                try {
                    taskWorkerLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (DEBUG) {
            System.err.println("MainThread.run(): " + Thread.currentThread().getName());
        }
        Object object = taskWorkerLock;
        synchronized (object) {
            isRunning = true;
            taskWorkerLock.notifyAll();
        }
        while (!shouldStop) {
            Object var5_6;
            try {
                try {
                    object = taskWorkerLock;
                    synchronized (object) {
                        while (!shouldStop && tasks.size() == 0) {
                            try {
                                taskWorkerLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        if (!shouldStop && tasks.size() > 0) {
                            Runnable runnable = (Runnable)tasks.remove(0);
                            runnable.run();
                        }
                        taskWorkerLock.notifyAll();
                    }
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    var5_6 = null;
                }
            }
            catch (Throwable throwable) {
                var5_6 = null;
                throw throwable;
            }
        }
        if (DEBUG) {
            System.err.println("MainThread.run(): " + Thread.currentThread().getName() + " fin");
        }
        object = taskWorkerLock;
        synchronized (object) {
            isRunning = false;
            isExit = true;
            taskWorkerLock.notifyAll();
        }
    }

    static {
        pumpMessagesTimer = null;
        pumpMessagesTimerTask = null;
        pumpMessageDisplayMap = new HashMap();
        useMainThread = false;
        cAWTEventQueue = null;
        mAWTInvokeAndWait = null;
        mAWTInvokeLater = null;
        mAWTIsDispatchThread = null;
    }

    static class MainAction
    extends Thread {
        private String mainClassName;
        private String[] mainClassArgs;
        private Class mainClass;
        private Method mainClassMain;

        public MainAction(String string, String[] stringArray) {
            this.mainClassName = string;
            this.mainClassArgs = stringArray;
        }

        public void run() {
            if (useMainThread) {
                singletonMainThread.waitUntilRunning();
            }
            try {
                Class clazz = ReflectionUtil.getClass((String)this.mainClassName, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
                if (null == clazz) {
                    throw new RuntimeException(new ClassNotFoundException("MainThread couldn't find main class " + this.mainClassName));
                }
                try {
                    this.mainClassMain = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = MainThread.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    this.mainClassMain.setAccessible(true);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (DEBUG) {
                    System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " invoke " + this.mainClassName);
                }
                this.mainClassMain.invoke(null, new Object[]{this.mainClassArgs});
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (DEBUG) {
                System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " user app fin");
            }
            if (useMainThread) {
                singletonMainThread.invokeStop(new Runnable(){

                    public void run() {
                    }
                });
                if (DEBUG) {
                    System.err.println("MainAction.run(): " + Thread.currentThread().getName() + " MainThread fin - stop");
                }
                System.exit(0);
            }
        }
    }
}

