/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.NewtVersion;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.impl.WindowImpl;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.impl.GLDrawableHelper;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;

public class GLWindow
implements GLAutoDrawable,
Window,
NEWTEventConsumer {
    private WindowImpl window;
    private GLContext sharedContext = null;
    private GLDrawableFactory factory;
    private GLDrawable drawable;
    private GLContext context;
    private GLDrawableHelper helper = new GLDrawableHelper();
    private boolean sendReshape = false;
    private boolean sendDestroy = false;
    private boolean perfLog = false;
    private long startTime;
    private long curTime;
    private long lastCheck;
    private int totalFrames;
    private int lastFrames;
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();

    protected GLWindow(Window window) {
        this.resetCounter();
        this.window = (WindowImpl)window;
        this.window.setHandleDestroyNotify(false);
        window.addWindowListener(new WindowAdapter(){

            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                if (!GLWindow.this.window.isSurfaceLockedByOtherThread() && !GLWindow.this.helper.isExternalAnimatorAnimating()) {
                    GLWindow.this.display();
                }
            }

            public void windowResized(WindowEvent windowEvent) {
                GLWindow.this.sendReshape = true;
                if (!GLWindow.this.window.isSurfaceLockedByOtherThread() && !GLWindow.this.helper.isExternalAnimatorAnimating()) {
                    GLWindow.this.display();
                }
            }

            public void windowDestroyNotify(WindowEvent windowEvent) {
                if (GLWindow.this.helper.isExternalAnimatorRunning()) {
                    GLAnimatorControl gLAnimatorControl = GLWindow.this.helper.getAnimator();
                    boolean bl = gLAnimatorControl.pause();
                    GLWindow.this.destroy();
                    if (bl) {
                        gLAnimatorControl.resume();
                    }
                } else if (GLWindow.this.window.isSurfaceLockedByOtherThread()) {
                    GLWindow.this.sendDestroy = true;
                } else {
                    GLWindow.this.destroy();
                }
            }
        });
        this.window.setLifecycleHook(new GLLifecycleHook());
    }

    public static GLWindow create(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow((CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public static GLWindow create(Screen screen, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public static GLWindow create(Window window) {
        return new GLWindow(window);
    }

    public static GLWindow create(NativeWindow nativeWindow, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return new GLWindow(NewtFactory.createWindow(nativeWindow, (CapabilitiesImmutable)gLCapabilitiesImmutable));
    }

    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        return this.window.setCapabilitiesChooser(capabilitiesChooser);
    }

    public final CapabilitiesImmutable getChosenCapabilities() {
        if (this.drawable == null) {
            return this.window.getChosenCapabilities();
        }
        return this.drawable.getChosenGLCapabilities();
    }

    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.window.getRequestedCapabilities();
    }

    public final Window getWindow() {
        return this.window;
    }

    public final NativeWindow getParent() {
        return this.window.getParent();
    }

    public final Screen getScreen() {
        return this.window.getScreen();
    }

    public final void setTitle(String string) {
        this.window.setTitle(string);
    }

    public final String getTitle() {
        return this.window.getTitle();
    }

    public final void setUndecorated(boolean bl) {
        this.window.setUndecorated(bl);
    }

    public final boolean isUndecorated() {
        return this.window.isUndecorated();
    }

    public final void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.window.setFocusAction(focusRunnable);
    }

    public final void requestFocus() {
        this.window.requestFocus();
    }

    public boolean hasFocus() {
        return this.window.hasFocus();
    }

    public final Insets getInsets() {
        return this.window.getInsets();
    }

    public final void setPosition(int n, int n2) {
        this.window.setPosition(n, n2);
    }

    public final boolean setFullscreen(boolean bl) {
        return this.window.setFullscreen(bl);
    }

    public final boolean isFullscreen() {
        return this.window.isFullscreen();
    }

    public final boolean isVisible() {
        return this.window.isVisible();
    }

    public final String toString() {
        return "NEWT-GLWindow[ \n\tHelper: " + this.helper + ", \n\tDrawable: " + this.drawable + ", \n\tContext: " + this.context + "]";
    }

    public final int reparentWindow(NativeWindow nativeWindow) {
        return this.window.reparentWindow(nativeWindow);
    }

    public final int reparentWindow(NativeWindow nativeWindow, boolean bl) {
        return this.window.reparentWindow(nativeWindow, bl);
    }

    public final void removeChild(NativeWindow nativeWindow) {
        this.window.removeChild(nativeWindow);
    }

    public final void addChild(NativeWindow nativeWindow) {
        this.window.addChild(nativeWindow);
    }

    public final void destroy() {
        this.window.destroy();
    }

    public final void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    public final void setSize(int n, int n2) {
        this.window.setSize(n, n2);
    }

    public final boolean isValid() {
        return this.window.isValid();
    }

    public final boolean isNativeValid() {
        return this.window.isNativeValid();
    }

    public Point getLocationOnScreen(Point point) {
        return this.window.getLocationOnScreen(point);
    }

    public GLDrawableFactory getFactory() {
        return this.factory;
    }

    public void setSharedContext(GLContext gLContext) {
        this.sharedContext = gLContext;
    }

    public void setContext(GLContext gLContext) {
        this.context = gLContext;
    }

    public GLContext getContext() {
        return this.context;
    }

    public GL getGL() {
        if (this.context == null) {
            return null;
        }
        return this.context.getGL();
    }

    public GL setGL(GL gL) {
        if (this.context != null) {
            this.context.setGL(gL);
            return gL;
        }
        return null;
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.addGLEventListener(gLEventListener);
        }
    }

    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.addGLEventListener(n, gLEventListener);
        }
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        if (null != this.helper) {
            this.helper.removeGLEventListener(gLEventListener);
        }
    }

    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        if (null != this.helper) {
            this.helper.setAnimator(gLAnimatorControl);
        }
    }

    public GLAnimatorControl getAnimator() {
        if (null != this.helper) {
            return this.helper.getAnimator();
        }
        return null;
    }

    public boolean getPerfLogEnabled() {
        return this.perfLog;
    }

    public void enablePerfLog(boolean bl) {
        this.perfLog = bl;
    }

    public void invoke(boolean bl, GLRunnable gLRunnable) {
        if (null != this.helper) {
            this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
        }
    }

    public void display() {
        this.display(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(boolean bl) {
        if (null == this.window) {
            return;
        }
        if (this.sendDestroy || null != this.window && this.window.hasDeviceChanged() && GLAutoDrawable.SCREEN_CHANGE_ACTION_ENABLED) {
            this.sendDestroy = false;
            this.destroy();
            return;
        }
        if (null == this.context && this.isVisible() && 0 < this.getWidth() * this.getHeight()) {
            this.setVisible(true);
        }
        if (bl) {
            this.sendReshape = true;
        }
        if (this.isVisible() && null != this.context && 1 < this.lockSurface()) {
            try {
                this.helper.invokeGL(this.drawable, this.context, (Runnable)this.displayAction, (Runnable)this.initAction);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.unlockSurface();
                throw throwable;
            }
            this.unlockSurface();
            {
            }
        }
    }

    public void setAutoSwapBufferMode(boolean bl) {
        if (null != this.helper) {
            this.helper.setAutoSwapBufferMode(bl);
        }
    }

    public boolean getAutoSwapBufferMode() {
        if (null != this.helper) {
            return this.helper.getAutoSwapBufferMode();
        }
        return false;
    }

    public void swapBuffers() {
        if (this.drawable != null && this.context != null) {
            if (this.context != GLContext.getCurrent()) {
                this.helper.invokeGL(this.drawable, this.context, (Runnable)this.swapBuffersAction, (Runnable)this.initAction);
            } else {
                this.drawable.swapBuffers();
            }
        }
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getCurrentTime() {
        return this.curTime;
    }

    public final long getDuration() {
        return this.getCurrentTime() - this.getStartTime();
    }

    public final int getTotalFrames() {
        return this.totalFrames;
    }

    public synchronized void resetCounter() {
        this.curTime = this.startTime = System.currentTimeMillis();
        this.lastCheck = this.startTime;
        this.totalFrames = 0;
        this.lastFrames = 0;
    }

    public final NativeSurface getNativeSurface() {
        return null != this.drawable ? this.drawable.getNativeSurface() : null;
    }

    public final long getHandle() {
        return null != this.drawable ? this.drawable.getHandle() : 0L;
    }

    public final int getX() {
        return this.window.getX();
    }

    public final int getY() {
        return this.window.getY();
    }

    public final int getWidth() {
        return this.window.getWidth();
    }

    public final int getHeight() {
        return this.window.getHeight();
    }

    public final GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    public final void setRealized(boolean bl) {
    }

    public final boolean isRealized() {
        return null != this.drawable ? this.drawable.isRealized() : false;
    }

    public final GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getChosenGLCapabilities();
    }

    public final GLProfile getGLProfile() {
        if (this.drawable == null) {
            throw new GLException("No drawable yet");
        }
        return this.drawable.getGLProfile();
    }

    public boolean consumeEvent(NEWTEvent nEWTEvent) {
        return this.window.consumeEvent(nEWTEvent);
    }

    public final void windowRepaint(int n, int n2, int n3, int n4) {
        this.window.windowRepaint(n, n2, n3, n4);
    }

    public final void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        this.window.enqueueEvent(bl, nEWTEvent);
    }

    public final void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        this.window.runOnEDTIfAvail(bl, runnable);
    }

    public final SurfaceUpdatedListener getSurfaceUpdatedListener(int n) {
        return this.window.getSurfaceUpdatedListener(n);
    }

    public final SurfaceUpdatedListener[] getSurfaceUpdatedListeners() {
        return this.window.getSurfaceUpdatedListeners();
    }

    public final void removeAllSurfaceUpdatedListener() {
        this.window.removeAllSurfaceUpdatedListener();
    }

    public final void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    public final void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.window.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    public final void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.window.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    public void sendWindowEvent(int n) {
        this.window.sendWindowEvent(n);
    }

    public final WindowListener getWindowListener(int n) {
        return this.window.getWindowListener(n);
    }

    public final WindowListener[] getWindowListeners() {
        return this.window.getWindowListeners();
    }

    public final void removeWindowListener(WindowListener windowListener) {
        this.window.removeWindowListener(windowListener);
    }

    public final void addWindowListener(WindowListener windowListener) {
        this.window.addWindowListener(windowListener);
    }

    public final void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        this.window.addWindowListener(n, windowListener);
    }

    public final void addKeyListener(KeyListener keyListener) {
        this.window.addKeyListener(keyListener);
    }

    public final void addKeyListener(int n, KeyListener keyListener) {
        this.window.addKeyListener(n, keyListener);
    }

    public final void removeKeyListener(KeyListener keyListener) {
        this.window.removeKeyListener(keyListener);
    }

    public final KeyListener getKeyListener(int n) {
        return this.window.getKeyListener(n);
    }

    public final KeyListener[] getKeyListeners() {
        return this.window.getKeyListeners();
    }

    public final void addMouseListener(MouseListener mouseListener) {
        this.window.addMouseListener(mouseListener);
    }

    public final void addMouseListener(int n, MouseListener mouseListener) {
        this.window.addMouseListener(n, mouseListener);
    }

    public final void removeMouseListener(MouseListener mouseListener) {
        this.window.removeMouseListener(mouseListener);
    }

    public final MouseListener getMouseListener(int n) {
        return this.window.getMouseListener(n);
    }

    public final MouseListener[] getMouseListeners() {
        return this.window.getMouseListeners();
    }

    public final int lockSurface() {
        return this.window.lockSurface();
    }

    public final void unlockSurface() throws NativeWindowException {
        this.window.unlockSurface();
    }

    public final boolean isSurfaceLockedByOtherThread() {
        return this.window.isSurfaceLockedByOtherThread();
    }

    public final boolean isSurfaceLocked() {
        return this.window.isSurfaceLocked();
    }

    public final Thread getSurfaceLockOwner() {
        return this.window.getSurfaceLockOwner();
    }

    public final boolean surfaceSwap() {
        return this.window.surfaceSwap();
    }

    public final void invalidate() {
        this.window.invalidate();
    }

    public final long getWindowHandle() {
        return this.window.getWindowHandle();
    }

    public final long getSurfaceHandle() {
        return this.window.getSurfaceHandle();
    }

    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.window.getGraphicsConfiguration();
    }

    public final long getDisplayHandle() {
        return this.window.getDisplayHandle();
    }

    public final int getScreenIndex() {
        return this.window.getScreenIndex();
    }

    public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.window.surfaceUpdated(object, nativeSurface, l);
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(NativeWindowVersion.getInstance());
        System.err.println(JoglVersion.getInstance());
        System.err.println((Object)NewtVersion.getInstance());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(128, 128);
        gLWindow.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                JoglVersion.getInstance();
                System.err.println(JoglVersion.getGLInfo((GL)gL, null));
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLWindow.setVisible(true);
        gLWindow.invalidate();
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLWindow.this.drawable.swapBuffers();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            if (GLWindow.this.sendReshape) {
                GLWindow.this.helper.reshape((GLAutoDrawable)GLWindow.this, 0, 0, GLWindow.this.getWidth(), GLWindow.this.getHeight());
                GLWindow.this.sendReshape = false;
            }
            GLWindow.this.helper.display((GLAutoDrawable)GLWindow.this);
            GLWindow.this.curTime = System.currentTimeMillis();
            GLWindow.this.totalFrames++;
            if (GLWindow.this.perfLog) {
                GLWindow.this.lastFrames++;
                long l = GLWindow.this.curTime - GLWindow.this.lastCheck;
                if (l > 5000L) {
                    long l2 = GLWindow.this.curTime - GLWindow.this.startTime;
                    System.err.println(l / 1000L + "s: " + GLWindow.this.lastFrames + "f, " + (long)(GLWindow.this.lastFrames * 1000) / l + " fps, " + l / (long)GLWindow.this.lastFrames + " ms/f; " + "total: " + l2 / 1000L + "s, " + (long)(GLWindow.this.totalFrames * 1000) / l2 + " fps, " + l2 / (long)GLWindow.this.totalFrames + " ms/f");
                    GLWindow.this.lastCheck = GLWindow.this.curTime;
                    GLWindow.this.lastFrames = 0;
                }
            }
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLWindow.this.helper.init((GLAutoDrawable)GLWindow.this);
            GLWindow.this.resetCounter();
        }
    }

    protected class GLLifecycleHook
    implements WindowImpl.LifecycleHook {
        DisposeAction disposeAction = new DisposeAction();

        protected GLLifecycleHook() {
        }

        public synchronized void destroyActionPreLock() {
        }

        public synchronized void destroyActionInLock() {
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                String string = new String("GLWindow.destroy() " + Thread.currentThread() + ", start");
                System.err.println(string);
            }
            if (GLWindow.this.window.isNativeValid() && null != GLWindow.this.drawable && GLWindow.this.drawable.isRealized()) {
                if (null != GLWindow.this.context && GLWindow.this.context.isCreated()) {
                    try {
                        GLWindow.this.helper.invokeGL(GLWindow.this.drawable, GLWindow.this.context, (Runnable)this.disposeAction, null);
                    }
                    catch (GLException gLException) {
                        gLException.printStackTrace();
                    }
                    GLWindow.this.context.destroy();
                }
                GLWindow.this.drawable.setRealized(false);
            }
            GLWindow.this.context = null;
            GLWindow.this.drawable = null;
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.destroy() " + Thread.currentThread() + ", fin");
            }
        }

        public synchronized void invalidate(boolean bl) {
            Object object;
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                object = new String("GLWindow.invalidate(" + bl + ") " + Thread.currentThread() + ", start");
                System.err.println((String)object);
            }
            if (bl) {
                object = GLWindow.this.getAnimator();
                if (null != object) {
                    object.remove((GLAutoDrawable)GLWindow.this);
                }
                GLWindow.this.helper = null;
            }
        }

        public synchronized void resetCounter() {
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                System.err.println("GLWindow.resetCounter() " + Thread.currentThread());
            }
            GLWindow.this.resetCounter();
        }

        public synchronized void setVisibleActionPost(boolean bl, boolean bl2) {
            Object object;
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                object = new String("GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + Thread.currentThread() + ", start");
                System.err.println((String)object);
            }
            if (null == GLWindow.this.context && bl && 0L != GLWindow.this.window.getWindowHandle() && 0 < GLWindow.this.getWidth() * GLWindow.this.getHeight()) {
                object = GLWindow.this.window.getWrappedWindow() != null ? NativeWindowFactory.getNativeWindow((Object)GLWindow.this.window.getWrappedWindow(), (AbstractGraphicsConfiguration)GLWindow.this.window.getGraphicsConfiguration()) : GLWindow.this.window;
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)object.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
                if (null == GLWindow.this.factory) {
                    GLWindow.this.factory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
                }
                if (null == GLWindow.this.drawable) {
                    GLWindow.this.drawable = GLWindow.this.factory.createGLDrawable((NativeSurface)object);
                }
                GLWindow.this.drawable.setRealized(true);
                GLWindow.this.context = GLWindow.this.drawable.createContext(GLWindow.this.sharedContext);
            }
            if (Window.DEBUG_WINDOW_EVENT || Window.DEBUG_IMPLEMENTATION) {
                object = new String("GLWindow.setVisibleActionPost(" + bl + ", " + bl2 + ") " + Thread.currentThread() + ", fin");
                System.err.println((String)object);
            }
        }

        public synchronized boolean pauseRenderingAction() {
            boolean bl = false;
            GLAnimatorControl gLAnimatorControl = GLWindow.this.getAnimator();
            if (null != gLAnimatorControl) {
                bl = gLAnimatorControl.pause();
            }
            return bl;
        }

        public synchronized void resumeRenderingAction() {
            GLAnimatorControl gLAnimatorControl = GLWindow.this.getAnimator();
            if (null != gLAnimatorControl && gLAnimatorControl.isPaused()) {
                gLAnimatorControl.resume();
            }
        }

        class DisposeAction
        implements Runnable {
            DisposeAction() {
            }

            public void run() {
                GLWindow.this.helper.dispose((GLAutoDrawable)GLWindow.this);
            }
        }
    }
}

