/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.impl.x11;

import com.jogamp.nativewindow.impl.x11.X11Util;
import com.jogamp.newt.impl.WindowImpl;
import com.jogamp.newt.impl.x11.X11Display;
import com.jogamp.newt.impl.x11.X11Screen;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;

public class X11Window
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private long windowHandleClose;
    private volatile long reparentHandle;
    private volatile int reparentCount;

    protected void createNativeImpl() {
        X11Screen x11Screen = (X11Screen)this.getScreen();
        X11Display x11Display = (X11Display)x11Screen.getDisplay();
        this.config = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)x11Display.getGraphicsDevice()).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, x11Screen.getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        X11GraphicsConfiguration x11GraphicsConfiguration = (X11GraphicsConfiguration)this.config;
        long l = x11GraphicsConfiguration.getVisualID();
        long l2 = this.CreateWindow0(this.getParentWindowHandle(), x11Display.getHandle(), x11Screen.getIndex(), l, x11Display.getJavaObjectAtom(), x11Display.getWindowDeleteAtom(), this.x, this.y, this.width, this.height, this.isUndecorated());
        if (l2 == 0L) {
            throw new NativeWindowException("Error creating window: " + l2);
        }
        this.setWindowHandle(l2);
        this.windowHandleClose = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeNativeImpl() {
        if (0L != this.windowHandleClose && null != this.getScreen()) {
            X11Display x11Display = (X11Display)this.getScreen().getDisplay();
            try {
                try {
                    this.CloseWindow0(x11Display.getHandle(), this.windowHandleClose, x11Display.getJavaObjectAtom(), x11Display.getWindowDeleteAtom());
                }
                catch (Throwable throwable) {
                    if (DEBUG_IMPLEMENTATION) {
                        Exception exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                        exception.printStackTrace();
                    }
                    Object var5_3 = null;
                    this.windowHandleClose = 0L;
                }
                Object var5_2 = null;
                this.windowHandleClose = 0L;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.windowHandleClose = 0L;
                throw throwable;
            }
        }
    }

    protected void windowDestroyed() {
        this.windowHandleClose = 0L;
        super.windowDestroyed();
    }

    protected void setVisibleImpl(boolean bl, int n, int n2, int n3, int n4) {
        this.setVisible0(this.getDisplayHandle(), this.getWindowHandle(), bl, n, n2, n3, n4);
    }

    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this.reparentHandle = 0L;
        this.reparentCount = 0;
        long l = n5 > 0 ? 0L : this.getParentWindowHandle();
        this.reconfigureWindow0(this.getDisplayHandle(), this.getScreenIndex(), l, this.getWindowHandle(), n, n2, n3, n4, this.isVisible(), bl, n5, n6);
        return true;
    }

    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getDisplayHandle(), this.getWindowHandle(), bl);
    }

    protected void setTitleImpl(String string) {
        this.setTitle0(this.getDisplayHandle(), this.getWindowHandle(), string);
    }

    protected Point getLocationOnScreenImpl(int n, int n2) {
        return X11Util.GetRelativeLocation((long)this.getDisplayHandle(), (int)this.getScreenIndex(), (long)this.getWindowHandle(), (long)0L, (int)n, (int)n2);
    }

    protected static native boolean initIDs0();

    private native long CreateWindow0(long var1, long var3, int var5, long var6, long var8, long var10, int var12, int var13, int var14, int var15, boolean var16);

    private native void CloseWindow0(long var1, long var3, long var5, long var7);

    private native void setVisible0(long var1, long var3, boolean var5, int var6, int var7, int var8, int var9);

    private native void reconfigureWindow0(long var1, int var3, long var4, long var6, int var8, int var9, int var10, int var11, boolean var12, boolean var13, int var14, int var15);

    private native void setTitle0(long var1, long var3, String var5);

    private native void requestFocus0(long var1, long var3, boolean var5);

    private native Object getRelativeLocation0(long var1, int var3, long var4, long var6, int var8, int var9);

    private void windowReparented(long l) {
        this.reparentHandle = l;
        ++this.reparentCount;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("******** new parent (" + this.reparentCount + "): " + X11Window.toHexString(this.reparentHandle));
        }
    }

    static {
        X11Display.initSingleton();
    }
}

