/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.impl.x11;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.impl.x11.X11Util;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.impl.ScreenImpl;
import com.jogamp.newt.impl.x11.X11Display;
import com.jogamp.newt.util.ScreenModeUtil;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;

public class X11Screen
extends ScreenImpl {
    private int[] nrotations;
    private int nrotation_index;
    private int nres_number;
    private int nres_index;
    private int[] nrates;
    private int nrate_index;
    private int nmode_number;

    protected void createNativeImpl() {
        long l = X11Screen.GetScreen0(this.display.getHandle(), this.screen_idx);
        if (l == 0L) {
            throw new RuntimeException("Error creating screen: " + this.screen_idx);
        }
        this.aScreen = new X11GraphicsScreen((X11GraphicsDevice)this.getDisplay().getGraphicsDevice(), this.screen_idx);
        this.setScreenSize(X11Screen.getWidth0(this.display.getHandle(), this.screen_idx), X11Screen.getHeight0(this.display.getHandle(), this.screen_idx));
    }

    protected void closeNativeImpl() {
    }

    protected int[] getScreenModeFirstImpl() {
        this.nrotations = X11Screen.getAvailableScreenModeRotations0(this.display.getHandle(), this.screen_idx);
        if (null == this.nrotations || 0 == this.nrotations.length) {
            return null;
        }
        this.nrotation_index = 0;
        this.nres_number = X11Screen.getNumScreenModeResolutions0(this.display.getHandle(), this.screen_idx);
        if (0 == this.nres_number) {
            return null;
        }
        this.nres_index = 0;
        this.nrates = X11Screen.getScreenModeRates0(this.display.getHandle(), this.screen_idx, this.nres_index);
        if (null == this.nrates || 0 == this.nrates.length) {
            return null;
        }
        this.nrate_index = 0;
        this.nmode_number = 0;
        return this.getScreenModeNextImpl();
    }

    protected int[] getScreenModeNextImpl() {
        int[] nArray = X11Screen.getScreenModeResolution0(this.display.getHandle(), this.screen_idx, this.nres_index);
        if (null == nArray || 0 == nArray.length) {
            return null;
        }
        if (0 >= nArray[0] || 0 >= nArray[1]) {
            throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + this.nres_index + "/" + this.nres_number);
        }
        int n = 32;
        int n2 = this.nrates[this.nrate_index];
        if (0 >= n2) {
            throw new InternalError("invalid rate: " + n2 + " at index " + this.nrate_index + "/" + this.nrates.length);
        }
        int n3 = this.nrotations[this.nrotation_index];
        int[] nArray2 = new int[9];
        int n4 = 0;
        nArray2[n4++] = this.nres_index;
        nArray2[n4++] = 0;
        nArray2[n4++] = nArray[0];
        nArray2[n4++] = nArray[1];
        nArray2[n4++] = n;
        nArray2[n4++] = nArray[2];
        nArray2[n4++] = nArray[3];
        nArray2[n4++] = n2;
        nArray2[n4++] = n3;
        nArray2[n4 - 8] = n4 - 1;
        ++this.nmode_number;
        ++this.nrotation_index;
        if (this.nrotation_index == this.nrotations.length) {
            this.nrotation_index = 0;
            ++this.nrate_index;
            if (null == this.nrates || this.nrate_index == this.nrates.length) {
                ++this.nres_index;
                if (this.nres_index == this.nres_number) {
                    this.nrates = null;
                    this.nrotations = null;
                    return null;
                }
                this.nrates = X11Screen.getScreenModeRates0(this.display.getHandle(), this.screen_idx, this.nres_index);
                if (null == this.nrates || 0 == this.nrates.length) {
                    return null;
                }
                this.nrate_index = 0;
            }
        }
        return nArray2;
    }

    protected ScreenMode getCurrentScreenModeImpl() {
        int n = X11Screen.getNumScreenModeResolutions0(this.display.getHandle(), this.screen_idx);
        if (0 == n) {
            return null;
        }
        int n2 = X11Screen.getCurrentScreenResolutionIndex0(this.display.getHandle(), this.screen_idx);
        if (0 > n2) {
            return null;
        }
        if (n2 >= n) {
            throw new RuntimeException("Invalid resolution index: ! " + n2 + " < " + n);
        }
        int[] nArray = X11Screen.getScreenModeResolution0(this.display.getHandle(), this.screen_idx, n2);
        if (null == nArray || 0 == nArray.length) {
            return null;
        }
        if (0 >= nArray[0] || 0 >= nArray[1]) {
            throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + n2 + "/" + n);
        }
        int n3 = X11Screen.getCurrentScreenRate0(this.display.getHandle(), this.screen_idx);
        if (0 > n3) {
            return null;
        }
        int n4 = X11Screen.getCurrentScreenRotation0(this.display.getHandle(), this.screen_idx);
        if (0 > n4) {
            return null;
        }
        int[] nArray2 = new int[8];
        int n5 = 0;
        nArray2[n5++] = 0;
        nArray2[n5++] = nArray[0];
        nArray2[n5++] = nArray[1];
        nArray2[n5++] = 32;
        nArray2[n5++] = nArray[2];
        nArray2[n5++] = nArray[3];
        nArray2[n5++] = n3;
        nArray2[n5++] = n4;
        nArray2[n5 - 8] = n5;
        return ScreenModeUtil.streamIn(nArray2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setCurrentScreenModeImpl(ScreenMode screenMode) {
        ArrayHashSet arrayHashSet = this.getScreenModesOrig();
        int n = arrayHashSet.indexOf(screenMode);
        if (0 > n) {
            throw new RuntimeException("ScreenMode not element of ScreenMode list: " + screenMode);
        }
        int n2 = X11Screen.getNumScreenModeResolutions0(this.display.getHandle(), this.screen_idx);
        int n3 = this.getScreenModesIdx2NativeIdx().get(n);
        if (0 > n3 || n3 >= n2) {
            throw new RuntimeException("Invalid resolution index: ! 0 < " + n3 + " < " + n2 + ", screenMode[" + n + "] " + screenMode);
        }
        long l = X11Util.createDisplay((String)this.display.getName());
        if (0L == l) {
            throw new RuntimeException("Error creating display: " + this.display.getName());
        }
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        try {
            int n4 = screenMode.getMonitorMode().getRefreshRate();
            int n5 = screenMode.getRotation();
            if (X11Screen.setCurrentScreenModeStart0(l, this.screen_idx, n3, n4, n5)) {
                while (!bl && System.currentTimeMillis() - l2 < 10000L) {
                    bl = X11Screen.setCurrentScreenModePollEnd0(l, this.screen_idx, n3, n4, n5);
                    if (bl) continue;
                    Thread.yield();
                }
            }
            Object var14_11 = null;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            X11Util.closeDisplay((long)l);
            throw throwable;
        }
        X11Util.closeDisplay((long)l);
        if (!bl) {
            System.err.println("X11Screen.setCurrentScreenModeImpl: TO (10000) reached: " + (System.currentTimeMillis() - l2) + "ms");
        }
        return bl;
    }

    private static native long GetScreen0(long var0, int var2);

    private static native int getWidth0(long var0, int var2);

    private static native int getHeight0(long var0, int var2);

    private static native int[] getAvailableScreenModeRotations0(long var0, int var2);

    private static native int getNumScreenModeResolutions0(long var0, int var2);

    private static native int[] getScreenModeResolution0(long var0, int var2, int var3);

    private static native int[] getScreenModeRates0(long var0, int var2, int var3);

    private static native int getCurrentScreenResolutionIndex0(long var0, int var2);

    private static native int getCurrentScreenRate0(long var0, int var2);

    private static native int getCurrentScreenRotation0(long var0, int var2);

    private static native boolean setCurrentScreenModeStart0(long var0, int var2, int var3, int var4, int var5);

    private static native boolean setCurrentScreenModePollEnd0(long var0, int var2, int var3, int var4, int var5);

    static {
        X11Display.initSingleton();
    }
}

