/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.impl.awt;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.newt.impl.WindowImpl;
import com.jogamp.newt.impl.awt.AWTCanvas;
import com.jogamp.newt.impl.awt.AWTDisplay;
import com.jogamp.newt.impl.awt.AWTScreen;
import com.jogamp.newt.util.EDTUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.nativewindow.util.Point;

public class AWTWindow
extends WindowImpl {
    private boolean owningFrame;
    private Container container = null;
    private Frame frame = null;
    private AWTCanvas canvas;

    public AWTWindow() {
        this(null);
    }

    public static Class[] getCustomConstructorArgumentTypes() {
        return new Class[]{Container.class};
    }

    public AWTWindow(Container container) {
        this.title = "AWT NewtWindow";
        this.container = container;
        if (container instanceof Frame) {
            this.frame = (Frame)container;
        }
    }

    protected void requestFocusImpl(boolean bl) {
        this.runOnEDT(true, new Runnable(){

            public void run() {
                AWTWindow.this.container.requestFocus();
            }
        });
    }

    protected void setTitleImpl(final String string) {
        this.runOnEDT(true, new Runnable(){

            public void run() {
                if (AWTWindow.this.frame != null) {
                    AWTWindow.this.frame.setTitle(string);
                }
            }
        });
    }

    protected void createNativeImpl() {
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported in AWT, use AWTWindow(Frame) cstr for wrapping instead");
        }
        final AWTWindow aWTWindow = this;
        this.runOnEDT(true, new Runnable(){

            public void run() {
                if (null == AWTWindow.this.container) {
                    AWTWindow.this.frame = new Frame();
                    AWTWindow.this.container = AWTWindow.this.frame;
                    AWTWindow.this.owningFrame = true;
                } else {
                    AWTWindow.this.owningFrame = false;
                    AWTWindow.this.width = AWTWindow.this.container.getWidth();
                    AWTWindow.this.height = AWTWindow.this.container.getHeight();
                    AWTWindow.this.x = AWTWindow.this.container.getX();
                    AWTWindow.this.y = AWTWindow.this.container.getY();
                }
                if (null != AWTWindow.this.frame) {
                    AWTWindow.this.frame.setTitle(AWTWindow.this.getTitle());
                }
                AWTWindow.this.container.setLayout(new BorderLayout());
                AWTWindow.this.canvas = new AWTCanvas(AWTWindow.this.capsRequested, AWTWindow.this.capabilitiesChooser);
                AWTWindow.this.addWindowListener(new LocalWindowListener());
                new AWTMouseAdapter(aWTWindow).addTo(AWTWindow.this.canvas);
                new AWTKeyAdapter(aWTWindow).addTo(AWTWindow.this.canvas);
                AWTWindow.this.container.add((Component)AWTWindow.this.canvas, "Center");
                AWTWindow.this.container.setSize(AWTWindow.this.width, AWTWindow.this.height);
                AWTWindow.this.container.setLocation(AWTWindow.this.x, AWTWindow.this.y);
                new AWTWindowAdapter(aWTWindow).addTo(AWTWindow.this.container);
                if (null != AWTWindow.this.frame) {
                    AWTWindow.this.frame.setUndecorated(AWTWindow.this.undecorated || AWTWindow.this.fullscreen);
                }
            }
        });
        this.setWindowHandle(1L);
    }

    protected void closeNativeImpl() {
        this.setWindowHandle(0L);
        if (null != this.container) {
            this.runOnEDT(true, new Runnable(){

                public void run() {
                    AWTWindow.this.container.setVisible(false);
                    AWTWindow.this.container.remove(AWTWindow.this.canvas);
                    AWTWindow.this.container.setEnabled(false);
                    AWTWindow.this.canvas.setEnabled(false);
                }
            });
        }
        if (this.owningFrame && null != this.frame) {
            this.runOnEDT(true, new Runnable(){

                public void run() {
                    AWTWindow.this.frame.dispose();
                    AWTWindow.this.owningFrame = false;
                    AWTWindow.this.frame = null;
                }
            });
        }
    }

    public boolean hasDeviceChanged() {
        boolean bl = this.canvas.hasDeviceChanged();
        if (bl) {
            this.config = this.canvas.getAWTGraphicsConfiguration();
            if (this.config == null) {
                throw new NativeWindowException("Error Device change null GraphicsConfiguration: " + this);
            }
            this.updateDeviceData();
        }
        return bl;
    }

    protected void setVisibleImpl(final boolean bl, int n, int n2, int n3, int n4) {
        this.runOnEDT(true, new Runnable(){

            public void run() {
                AWTWindow.this.container.setVisible(bl);
            }
        });
        this.reconfigureWindowImpl(n, n2, n3, n4, false, 0, 0);
        this.config = this.canvas.getAWTGraphicsConfiguration();
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.updateDeviceData();
        this.visibleChanged(bl);
    }

    private void updateDeviceData() {
        ((AWTScreen)this.getScreen()).setAWTGraphicsScreen((AWTGraphicsScreen)this.config.getScreen());
        ((AWTDisplay)this.getScreen().getDisplay()).setAWTGraphicsDevice((AWTGraphicsDevice)this.config.getScreen().getDevice());
        DisplayMode displayMode = ((AWTGraphicsDevice)this.config.getScreen().getDevice()).getGraphicsDevice().getDisplayMode();
        int n = displayMode.getWidth();
        int n2 = displayMode.getHeight();
        ((AWTScreen)this.getScreen()).setScreenSize(n, n2);
    }

    public javax.media.nativewindow.util.Insets getInsets() {
        final int[] nArray = new int[]{0, 0, 0, 0};
        this.runOnEDT(true, new Runnable(){

            public void run() {
                Insets insets = AWTWindow.this.container.getInsets();
                nArray[0] = insets.top;
                nArray[1] = insets.left;
                nArray[2] = insets.bottom;
                nArray[3] = insets.right;
            }
        });
        return new javax.media.nativewindow.util.Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    protected boolean reconfigureWindowImpl(final int n, final int n2, final int n3, final int n4, boolean bl, int n5, final int n6) {
        this.runOnEDT(false, new Runnable(){

            public void run() {
                if (n6 != 0 && null != AWTWindow.this.frame) {
                    if (!AWTWindow.this.container.isDisplayable()) {
                        AWTWindow.this.frame.setUndecorated(AWTWindow.this.isUndecorated());
                    } else if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                        System.err.println("AWTWindow can't undecorate already created frame");
                    }
                }
                int n5 = n >= 0 ? n : AWTWindow.this.x;
                int n22 = n >= 0 ? n2 : AWTWindow.this.y;
                int n32 = n3 > 0 ? n3 : AWTWindow.this.width;
                int n42 = n4 > 0 ? n4 : AWTWindow.this.height;
                AWTWindow.this.container.setLocation(n5, n22);
                Insets insets = AWTWindow.this.container.getInsets();
                AWTWindow.this.container.setSize(n32 + insets.left + insets.right, n42 + insets.top + insets.bottom);
            }
        });
        return true;
    }

    protected Point getLocationOnScreenImpl(int n, int n2) {
        java.awt.Point point = this.canvas.getLocationOnScreen();
        point.translate(n, n2);
        return new Point((int)(point.getX() + 0.5), (int)(point.getY() + 0.5));
    }

    public Object getWrappedWindow() {
        return this.canvas;
    }

    private void runOnEDT(boolean bl, Runnable runnable) {
        EDTUtil eDTUtil = this.getScreen().getDisplay().getEDTUtil();
        if (null != eDTUtil && eDTUtil.isCurrentThreadEDT() || EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                if (bl) {
                    EventQueue.invokeAndWait(runnable);
                } else {
                    EventQueue.invokeLater(runnable);
                }
            }
            catch (Exception exception) {
                throw new NativeWindowException((Throwable)exception);
            }
        }
    }

    class LocalWindowListener
    extends WindowAdapter {
        LocalWindowListener() {
        }

        public void windowMoved(WindowEvent windowEvent) {
            if (null != AWTWindow.this.container) {
                AWTWindow.this.x = AWTWindow.this.container.getX();
                AWTWindow.this.y = AWTWindow.this.container.getY();
            }
        }

        public void windowResized(WindowEvent windowEvent) {
            if (null != AWTWindow.this.canvas) {
                AWTWindow.this.width = AWTWindow.this.canvas.getWidth();
                AWTWindow.this.height = AWTWindow.this.canvas.getHeight();
            }
        }
    }
}

