/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.impl;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.event.ScreenModeListener;
import com.jogamp.newt.impl.Debug;
import com.jogamp.newt.impl.DisplayImpl;
import com.jogamp.newt.impl.ScreenModeStatus;
import com.jogamp.newt.util.ScreenModeUtil;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeWindowException;

public abstract class ScreenImpl
extends Screen
implements ScreenModeListener {
    protected static final boolean DEBUG_TEST_SCREENMODE_DISABLED = Debug.isPropertyDefined("newt.test.Screen.disableScreenMode", true);
    protected DisplayImpl display;
    protected int screen_idx;
    protected String fqname;
    protected int hashCode;
    protected AbstractGraphicsScreen aScreen;
    protected int refCount;
    protected int width = -1;
    protected int height = -1;
    protected static int usrWidth = -1;
    protected static int usrHeight = -1;
    private static AccessControlContext localACC = AccessController.getContext();
    private List referencedScreenModeListener = new ArrayList();
    long t0;

    private static Class getScreenClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "Screen");
        if (null == clazz) {
            if ("EGL".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.opengl.kd.KDScreen");
            } else if ("Windows".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.windows.WindowsScreen");
            } else if ("MacOSX".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.macosx.MacScreen");
            } else if ("X11".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.x11.X11Screen");
            } else if ("AWT".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.awt.AWTScreen");
            } else {
                throw new RuntimeException("Unknown window type \"" + string + "\"");
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Screen create(Display display, int n) {
        try {
            Serializable serializable;
            if (usrWidth < 0 || usrHeight < 0) {
                serializable = Screen.class;
                synchronized (serializable) {
                    if (usrWidth < 0 || usrHeight < 0) {
                        usrWidth = Debug.getIntProperty("newt.ws.swidth", true, localACC);
                        usrHeight = Debug.getIntProperty("newt.ws.sheight", true, localACC);
                        if (usrWidth > 0 || usrHeight > 0) {
                            System.err.println("User screen size " + usrWidth + "x" + usrHeight);
                        }
                    }
                }
            }
            serializable = screenList;
            synchronized (serializable) {
                Object object = ScreenImpl.getLastScreenOf(display, n, -1);
                if (null != object) {
                    if (DEBUG) {
                        System.err.println("Screen.create() REUSE: " + object + " " + Display.getThreadName());
                    }
                    return object;
                }
                object = ScreenImpl.getScreenClass(display.getType());
                ScreenImpl screenImpl = (ScreenImpl)((Class)object).newInstance();
                screenImpl.display = (DisplayImpl)display;
                screenImpl.screen_idx = n;
                screenImpl.fqname = (display.getFQName() + n).intern();
                screenImpl.hashCode = screenImpl.fqname.hashCode();
                screenList.add(screenImpl);
                if (DEBUG) {
                    System.err.println("Screen.create() NEW: " + screenImpl + " " + Display.getThreadName());
                }
                return screenImpl;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void createNative() throws NativeWindowException {
        if (null == this.aScreen) {
            if (DEBUG) {
                System.err.println("Screen.createNative() START (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            this.t0 = System.currentTimeMillis();
            this.display.addReference();
            this.createNativeImpl();
            if (null == this.aScreen) {
                throw new NativeWindowException("Screen.createNative() failed to instanciate an AbstractGraphicsScreen");
            }
            if (DEBUG) {
                System.err.println("Screen.createNative() END (" + DisplayImpl.getThreadName() + ", " + this + ")");
            }
            ArrayList arrayList = screenList;
            synchronized (arrayList) {
                ++screensActive;
            }
        }
        this.initScreenModeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void destroy() {
        this.releaseScreenModeStatus();
        ArrayList arrayList = screenList;
        synchronized (arrayList) {
            screenList.remove(this);
            if (0 < screensActive) {
                --screensActive;
            }
        }
        if (null != this.aScreen) {
            this.closeNativeImpl();
            this.aScreen = null;
        }
        this.refCount = 0;
        this.display.removeReference();
    }

    public final synchronized int addReference() throws NativeWindowException {
        if (DEBUG) {
            System.err.println("Screen.addReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount + 1));
        }
        if (0 == this.refCount) {
            this.createNative();
        }
        if (null == this.aScreen) {
            throw new NativeWindowException("Screen.addReference() (refCount " + this.refCount + ") null AbstractGraphicsScreen");
        }
        return ++this.refCount;
    }

    public final synchronized int removeReference() {
        if (DEBUG) {
            String string = "Screen.removeReference() (" + DisplayImpl.getThreadName() + "): " + this.refCount + " -> " + (this.refCount - 1);
            System.err.println(string);
        }
        --this.refCount;
        if (0 >= this.refCount) {
            this.destroy();
            this.refCount = 0;
        }
        return this.refCount;
    }

    public final synchronized int getReferenceCount() {
        return this.refCount;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    public final String getFQName() {
        return this.fqname;
    }

    protected void setScreenSize(int n, int n2) {
        System.err.println("Detected screen size " + n + "x" + n2);
        this.width = n;
        this.height = n2;
    }

    public final Display getDisplay() {
        return this.display;
    }

    public final int getIndex() {
        return this.screen_idx;
    }

    public final AbstractGraphicsScreen getGraphicsScreen() {
        return this.aScreen;
    }

    public final boolean isNativeValid() {
        return null != this.aScreen;
    }

    public final int getWidth() {
        return usrWidth > 0 ? usrWidth : (this.width > 0 ? this.width : 480);
    }

    public final int getHeight() {
        return usrHeight > 0 ? usrHeight : (this.height > 0 ? this.height : 480);
    }

    public String toString() {
        return "NEWT-Screen[" + this.getFQName() + ", idx " + this.screen_idx + ", refCount " + this.refCount + ", " + this.getWidth() + "x" + this.getHeight() + ", " + this.aScreen + ", " + this.display + "]";
    }

    public final List getScreenModes() {
        ArrayHashSet arrayHashSet = this.getScreenModesOrig();
        if (null != arrayHashSet && 0 < arrayHashSet.size()) {
            return arrayHashSet.toArrayList();
        }
        return null;
    }

    public ScreenMode getOriginalScreenMode() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        return null != screenModeStatus ? screenModeStatus.getOriginalScreenMode() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenMode getCurrentScreenMode() {
        ScreenMode screenMode = null;
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            ScreenMode screenMode2;
            ScreenMode screenMode3 = screenMode2 = DEBUG_TEST_SCREENMODE_DISABLED ? null : this.getCurrentScreenModeImpl();
            if (null == screenMode2) {
                return null;
            }
            screenModeStatus.lock();
            try {
                screenMode = (ScreenMode)screenModeStatus.getScreenModes().get((Object)screenMode2);
                if (null == screenMode) {
                    throw new RuntimeException(screenMode2 + " could not be hashed from ScreenMode list");
                }
                if (screenModeStatus.getCurrentScreenMode().hashCode() != screenMode.hashCode()) {
                    screenModeStatus.fireScreenModeChanged(screenMode, true);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                screenModeStatus.unlock();
                throw throwable;
            }
            screenModeStatus.unlock();
            {
            }
        }
        return screenMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentScreenMode(ScreenMode screenMode) {
        ScreenMode screenMode2 = (ScreenMode)this.getScreenModesOrig().get((Object)screenMode);
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            boolean bl;
            screenModeStatus.lock();
            try {
                boolean bl2;
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - this.t0) + "): 0.0 " + screenMode);
                }
                screenModeStatus.fireScreenModeChangeNotify(screenMode2);
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - this.t0) + "): 0.1 " + screenMode);
                }
                if (bl2 = this.setCurrentScreenModeImpl(screenMode2)) {
                    this.setScreenSize(screenMode.getMonitorMode().getSurfaceSize().getResolution().getWidth(), screenMode.getMonitorMode().getSurfaceSize().getResolution().getHeight());
                }
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - this.t0) + "): X.0 " + screenMode + ", success: " + bl2);
                }
                screenModeStatus.fireScreenModeChanged(screenMode2, bl2);
                if (DEBUG) {
                    System.err.println("Screen.setCurrentScreenMode (" + (System.currentTimeMillis() - this.t0) + "): X.X " + screenMode + ", success: " + bl2);
                }
                bl = bl2;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                screenModeStatus.unlock();
                throw throwable;
            }
            screenModeStatus.unlock();
            return bl;
        }
        return false;
    }

    public void screenModeChangeNotify(ScreenMode screenMode) {
        for (int i = 0; i < this.referencedScreenModeListener.size(); ++i) {
            ((ScreenModeListener)this.referencedScreenModeListener.get(i)).screenModeChangeNotify(screenMode);
        }
    }

    public void screenModeChanged(ScreenMode screenMode, boolean bl) {
        for (int i = 0; i < this.referencedScreenModeListener.size(); ++i) {
            ((ScreenModeListener)this.referencedScreenModeListener.get(i)).screenModeChanged(screenMode, bl);
        }
    }

    public final synchronized void addScreenModeListener(ScreenModeListener screenModeListener) {
        this.referencedScreenModeListener.add(screenModeListener);
    }

    public final synchronized void removeScreenModeListener(ScreenModeListener screenModeListener) {
        this.referencedScreenModeListener.remove(screenModeListener);
    }

    protected final ArrayHashSet getScreenModesOrig() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            return screenModeStatus.getScreenModes();
        }
        return null;
    }

    protected final IntIntHashMap getScreenModesIdx2NativeIdx() {
        ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
        if (null != screenModeStatus) {
            return screenModeStatus.getScreenModesIdx2NativeIdx();
        }
        return null;
    }

    protected int[] getScreenModeFirstImpl() {
        return null;
    }

    protected int[] getScreenModeNextImpl() {
        return null;
    }

    protected ScreenMode getCurrentScreenModeImpl() {
        return null;
    }

    protected boolean setCurrentScreenModeImpl(ScreenMode screenMode) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScreenModeStatus() {
        ScreenModeStatus.lockScreenModeStatus();
        try {
            ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
            if (null == screenModeStatus) {
                IntIntHashMap intIntHashMap = new IntIntHashMap();
                ArrayHashSet arrayHashSet = this.collectNativeScreenModes(intIntHashMap);
                screenModeStatus = new ScreenModeStatus(arrayHashSet, intIntHashMap);
                if (null != arrayHashSet && arrayHashSet.size() > 0) {
                    ScreenMode screenMode;
                    ScreenMode screenMode2 = screenMode = DEBUG_TEST_SCREENMODE_DISABLED ? null : this.getCurrentScreenModeImpl();
                    if (null != screenMode) {
                        ScreenMode screenMode3 = (ScreenMode)arrayHashSet.get((Object)screenMode);
                        if (null == screenMode3) {
                            throw new RuntimeException(screenMode + " could not be hashed from ScreenMode list");
                        }
                        screenModeStatus.setOriginalScreenMode(screenMode3);
                    }
                }
                ScreenModeStatus.mapScreenModeStatus(this.getFQName(), screenModeStatus);
            }
            screenModeStatus.addListener(this);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ScreenModeStatus.unlockScreenModeStatus();
            throw throwable;
        }
        ScreenModeStatus.unlockScreenModeStatus();
    }

    private ArrayHashSet collectNativeScreenModes(IntIntHashMap intIntHashMap) {
        ArrayHashSet arrayHashSet = new ArrayHashSet();
        ArrayHashSet arrayHashSet2 = new ArrayHashSet();
        ArrayHashSet arrayHashSet3 = new ArrayHashSet();
        ArrayHashSet arrayHashSet4 = new ArrayHashSet();
        ArrayHashSet arrayHashSet5 = null;
        arrayHashSet5 = new ArrayHashSet();
        int[] nArray = null;
        int n = 0;
        do {
            if (null != (nArray = DEBUG_TEST_SCREENMODE_DISABLED ? null : (0 == n ? this.getScreenModeFirstImpl() : this.getScreenModeNextImpl())) && 0 < nArray.length && nArray[4] >= 15) {
                int n2 = nArray[0];
                int n3 = ScreenModeUtil.streamIn(arrayHashSet, arrayHashSet2, arrayHashSet3, arrayHashSet4, arrayHashSet5, nArray, 1);
                if (n3 >= 0) {
                    intIntHashMap.put(n3, n2);
                }
            }
            ++n;
        } while (null != nArray && 0 < nArray.length);
        if (DEBUG) {
            System.err.println("ScreenImpl.collectNativeScreenModes: ScreenMode number  : " + arrayHashSet5.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: MonitorMode number : " + arrayHashSet4.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: ScreenSizeMM number: " + arrayHashSet3.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: SurfaceSize number : " + arrayHashSet2.size());
            System.err.println("ScreenImpl.collectNativeScreenModes: Resolution number  : " + arrayHashSet.size());
        }
        return arrayHashSet5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseScreenModeStatus() {
        ScreenModeStatus.lockScreenModeStatus();
        try {
            ScreenModeStatus screenModeStatus = ScreenModeStatus.getScreenModeStatus(this.getFQName());
            if (null != screenModeStatus) {
                screenModeStatus.lock();
                try {
                    if (0 == screenModeStatus.removeListener(this)) {
                        if (!screenModeStatus.isOriginalMode()) {
                            this.setCurrentScreenMode(screenModeStatus.getOriginalScreenMode());
                        }
                        ScreenModeStatus.unmapScreenModeStatus(this.getFQName());
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    screenModeStatus.unlock();
                    throw throwable;
                }
                screenModeStatus.unlock();
                {
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ScreenModeStatus.unlockScreenModeStatus();
            throw throwable;
        }
        ScreenModeStatus.unlockScreenModeStatus();
    }
}

