/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.awt;

import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtFactoryAWT;
import com.jogamp.newt.event.awt.AWTAdapter;
import com.jogamp.newt.event.awt.AWTParentWindowAdapter;
import com.jogamp.newt.impl.Debug;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;

public class NewtCanvasAWT
extends Canvas {
    public static final boolean DEBUG = Debug.debug("Window");
    NativeWindow nativeWindow = null;
    Window newtChild = null;
    AWTAdapter awtAdapter = null;
    FocusAction focusAction = new FocusAction();
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;
    static /* synthetic */ Class class$java$awt$Canvas;

    public NewtCanvasAWT() {
    }

    public NewtCanvasAWT(Window window) {
        this.setNEWTChild(window);
    }

    public NewtCanvasAWT setNEWTChild(Window window) {
        if (this.newtChild != window) {
            this.newtChild = window;
            if (null != this.nativeWindow) {
                Container container = NewtCanvasAWT.getContainer(this);
                this.reparentWindow(null != this.newtChild, container);
            }
        }
        return this;
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    public NativeWindow getNativeWindow() {
        return this.nativeWindow;
    }

    void setWindowAdapter(boolean bl) {
        if (null != this.awtAdapter) {
            this.awtAdapter.removeFrom(this);
            this.awtAdapter = null;
        }
        if (bl && null != this.newtChild) {
            this.awtAdapter = new AWTParentWindowAdapter(this.newtChild).addTo(this);
        }
    }

    static Container getContainer(Component component) {
        while (null != component) {
            if (component instanceof Container) {
                return (Container)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public void addNotify() {
        this.disableBackgroundErase();
        super.addNotify();
        this.disableBackgroundErase();
        Container container = NewtCanvasAWT.getContainer(this);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.addNotify: " + this.newtChild + ", " + this + ", visible " + this.isVisible() + ", showing " + this.isShowing() + ", displayable " + this.isDisplayable() + " -> " + container);
        }
        this.reparentWindow(true, container);
    }

    public void removeNotify() {
        Container container = NewtCanvasAWT.getContainer(this);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.removeNotify: " + this.newtChild + ", from " + container);
        }
        this.reparentWindow(false, container);
        super.removeNotify();
    }

    void reparentWindow(boolean bl, Container container) {
        if (null == this.newtChild) {
            return;
        }
        this.newtChild.setFocusAction(null);
        if (bl) {
            this.nativeWindow = NewtFactoryAWT.getNativeWindow(this, this.newtChild.getRequestedCapabilities());
            if (null != this.nativeWindow) {
                if (DEBUG) {
                    System.err.println("NewtCanvasAWT.reparentWindow: " + this.newtChild);
                }
                int n = container.getWidth();
                int n2 = container.getHeight();
                this.setSize(n, n2);
                this.newtChild.setSize(n, n2);
                this.newtChild.reparentWindow(this.nativeWindow);
                this.newtChild.setVisible(true);
                this.setWindowAdapter(true);
                this.newtChild.sendWindowEvent(100);
                this.newtChild.windowRepaint(0, 0, n, n2);
                this.newtChild.setFocusAction(this.focusAction);
            }
        } else {
            this.setWindowAdapter(false);
            this.nativeWindow = null;
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null);
        }
    }

    public final void destroy() {
        if (null != this.newtChild) {
            Container container = NewtCanvasAWT.getContainer(this);
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.destroy(): " + this.newtChild + ", from " + container);
            }
            this.nativeWindow = null;
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null);
            this.newtChild.destroy();
            this.newtChild = null;
            if (null != container) {
                container.remove(this);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (null != this.newtChild) {
            this.newtChild.windowRepaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void update(Graphics graphics) {
        if (null != this.newtChild) {
            this.newtChild.windowRepaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    final void requestFocusAWTParent() {
        super.requestFocus();
    }

    final void requestFocusNEWTChild() {
        if (null != this.newtChild) {
            this.newtChild.setFocusAction(null);
            this.newtChild.requestFocus();
            this.newtChild.setFocusAction(this.focusAction);
        }
    }

    public void requestFocus() {
        this.requestFocusAWTParent();
        this.requestFocusNEWTChild();
    }

    public boolean requestFocus(boolean bl) {
        boolean bl2 = super.requestFocus(bl);
        if (bl2) {
            this.requestFocusNEWTChild();
        }
        return bl2;
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (bl) {
            this.requestFocusNEWTChild();
        }
        return bl;
    }

    public boolean requestFocusInWindow(boolean bl) {
        boolean bl2 = super.requestFocusInWindow(bl);
        if (bl2) {
            this.requestFocusNEWTChild();
        }
        return bl2;
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = NewtCanvasAWT.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", class$java$awt$Canvas == null ? NewtCanvasAWT.class$("java.awt.Canvas") : class$java$awt$Canvas);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    class FocusAction
    implements Window.FocusRunnable {
        FocusActionImpl focusActionImpl = new FocusActionImpl();

        FocusAction() {
        }

        public boolean run() {
            if (EventQueue.isDispatchThread()) {
                this.focusActionImpl.run();
            } else {
                try {
                    EventQueue.invokeAndWait(this.focusActionImpl);
                }
                catch (Exception exception) {
                    throw new NativeWindowException((Throwable)exception);
                }
            }
            return this.focusActionImpl.result;
        }

        class FocusActionImpl
        implements Runnable {
            public final boolean result = false;

            FocusActionImpl() {
            }

            public void run() {
                if (DEBUG) {
                    System.err.println("FocusActionImpl.run() " + Display.getThreadName());
                }
                NewtCanvasAWT.this.requestFocusAWTParent();
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.clearGlobalFocusOwner();
            }
        }
    }
}

