/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import org.joda.time.Years;

public class YearsPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Years) {
            super.setValueInternal(value);
        } else if (value instanceof Number) {
            super.setValueInternal((Object)this.parse((Number)value));
        } else {
            throw this.illegalValue(value, Years.class);
        }
    }

    protected String getAsTextInternal() {
        return this.getValue() == null ? "" : String.valueOf(((Years)this.getValue()).getYears());
    }

    public String getFormattedValue() {
        return this.getValue() == null ? "" : this.getValue().toString();
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)this.parse(Integer.parseInt(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            try {
                super.setValueInternal((Object)Years.parseYears((String)str));
            }
            catch (IllegalArgumentException e) {
                throw this.illegalValue(str, Years.class, e);
            }
            return;
        }
    }

    private Years parse(Number number) {
        return Years.years((int)Math.abs(number.intValue()));
    }
}

