/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.core.resources.formatters.Formatter;
import griffon.core.resources.formatters.ParseException;
import griffon.plugins.jodatime.formatters.DateTimeFormatter;
import griffon.util.GriffonNameUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class LocalTimePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof LocalTime) {
            super.setValueInternal(value);
        } else if (value instanceof LocalDateTime) {
            super.setValueInternal((Object)((LocalDateTime)value).toLocalTime());
        } else if (value instanceof DateTime) {
            super.setValueInternal((Object)((DateTime)value).toLocalTime());
        } else if (value instanceof DateMidnight) {
            super.setValueInternal((Object)new LocalTime(((DateMidnight)value).toDate().getTime()));
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Calendar) {
            super.setValueInternal((Object)new LocalTime(value));
        } else if (value instanceof Date) {
            super.setValueInternal((Object)new LocalTime(value));
        } else if (value instanceof Number) {
            super.setValueInternal((Object)new LocalTime(((Number)value).longValue()));
        } else {
            throw this.illegalValue(value, LocalTime.class);
        }
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)new LocalTime(Long.parseLong(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            try {
                super.setValueInternal((Object)new DateTimeFormatter(DateTimeFormatter.Pattern.FULL_TIME).parse(str));
            }
            catch (ParseException e) {
                throw this.illegalValue(str, LocalTime.class, (Exception)((Object)e));
            }
            return;
        }
    }

    protected Formatter resolveFormatter() {
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? null : new DateTimeFormatter(this.getFormat());
    }
}

