/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.Interval;

public class IntervalPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Interval) {
            super.setValueInternal(value);
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else {
            throw this.illegalValue(value, Interval.class);
        }
    }

    private void handleAsList(List list) {
        switch (list.size()) {
            case 2: {
                long s = this.parseValue(list.get(0));
                long e = this.parseValue(list.get(1));
                super.setValueInternal((Object)new Interval(s, e));
                break;
            }
            default: {
                throw this.illegalValue(list, Interval.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        long s = this.getMapValue(map, "start", 0L);
        long e = this.getMapValue(map, "end", 0L);
        super.setValueInternal((Object)new Interval(s, e));
    }

    private long getMapValue(Map map, String key, long defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Interval.class);
    }

    private long parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Interval.class);
    }

    private long parse(String val) {
        try {
            return Long.parseLong(val.trim());
        }
        catch (NumberFormatException nfe) {
            try {
                return DateTime.parse((String)val).toDate().getTime();
            }
            catch (IllegalArgumentException iae) {
                throw this.illegalValue(val, Interval.class, iae);
            }
        }
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)Instant.parse((String)str));
        }
        catch (IllegalArgumentException e) {
            throw this.illegalValue(str, Interval.class, e);
        }
    }

    private long parse(Number number) {
        return Math.abs(number.longValue());
    }
}

