/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class InstantPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Instant) {
            super.setValueInternal(value);
        } else if (value instanceof DateTime) {
            super.setValueInternal((Object)((DateTime)value).toInstant());
        } else if (value instanceof DateMidnight) {
            super.setValueInternal((Object)((DateMidnight)value).toInstant());
        } else if (value instanceof LocalDate) {
            super.setValueInternal((Object)new Instant((Object)((LocalDate)value).toDate()));
        } else if (value instanceof LocalDateTime) {
            super.setValueInternal((Object)new Instant((Object)((LocalDateTime)value).toDate()));
        } else if (value instanceof LocalTime) {
            super.setValueInternal((Object)((LocalTime)value).toDateTimeToday().toInstant());
        } else if (value instanceof Calendar) {
            super.setValueInternal((Object)new Instant(value));
        } else if (value instanceof Date) {
            super.setValueInternal((Object)new Instant(value));
        } else if (value instanceof Number) {
            super.setValueInternal((Object)this.parse((Number)value));
        } else {
            throw this.illegalValue(value, Instant.class);
        }
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)this.parse(Long.parseLong(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            try {
                super.setValueInternal((Object)Instant.parse((String)str));
            }
            catch (IllegalArgumentException e) {
                throw this.illegalValue(str, Instant.class, e);
            }
            return;
        }
    }

    private Instant parse(Number number) {
        return new Instant(Math.abs(number.longValue()));
    }
}

