/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.formatters;

import griffon.core.resources.formatters.AbstractFormatter;
import griffon.core.resources.formatters.ParseException;
import griffon.util.GriffonNameUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class DateTimeFormatter
extends AbstractFormatter<DateTime> {
    private final org.joda.time.format.DateTimeFormatter dateTimeFormatter;

    public DateTimeFormatter() {
        this((Pattern)null);
    }

    public DateTimeFormatter(String pattern) {
        this.dateTimeFormatter = GriffonNameUtils.isBlank((String)pattern) ? DateTimeFormat.fullDateTime() : Pattern.parse(pattern);
    }

    public DateTimeFormatter(Pattern pattern) {
        this.dateTimeFormatter = pattern == null ? DateTimeFormat.fullDateTime() : pattern.getDateTimeFormatter();
    }

    public String format(DateTime dateTime) {
        return this.dateTimeFormatter.print((ReadableInstant)dateTime);
    }

    public DateTime parse(String str) throws ParseException {
        if (GriffonNameUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return this.dateTimeFormatter.parseDateTime(str);
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e);
        }
    }

    public static enum Pattern {
        SHORT_TIME(DateTimeFormat.shortTime()),
        SHORT_DATE(DateTimeFormat.shortDate()),
        SHORT_DATE_TIME(DateTimeFormat.shortDateTime()),
        MEDIUM_TIME(DateTimeFormat.mediumTime()),
        MEDIUM_DATE(DateTimeFormat.mediumDate()),
        MEDIUM_DATE_TIME(DateTimeFormat.mediumDateTime()),
        LONG_TIME(DateTimeFormat.longTime()),
        LONG_DATE(DateTimeFormat.longDate()),
        LONG_DATE_TIME(DateTimeFormat.longDateTime()),
        FULL_TIME(DateTimeFormat.fullTime()),
        FULL_DATE(DateTimeFormat.fullDate()),
        FULL_DATE_TIME(DateTimeFormat.fullDateTime());

        private final org.joda.time.format.DateTimeFormatter dateTimeFormatter;

        private Pattern(org.joda.time.format.DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        private org.joda.time.format.DateTimeFormatter getDateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public static org.joda.time.format.DateTimeFormatter parse(String str) {
            try {
                return Pattern.valueOf((String)str.toUpperCase().replace((CharSequence)" ", (CharSequence)"_")).dateTimeFormatter;
            }
            catch (Exception e) {
                return DateTimeFormat.forPattern((String)str);
            }
        }
    }
}

