/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.core.resources.formatters.Formatter;
import griffon.plugins.jodatime.formatters.DateTimeFormatter;
import griffon.util.GriffonNameUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class LocalDateTimePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof LocalDateTime) {
            super.setValueInternal(value);
        } else if (value instanceof LocalDate) {
            super.setValueInternal((Object)((LocalDate)value).toDateTimeAtStartOfDay());
        } else if (value instanceof LocalTime) {
            super.setValueInternal((Object)((LocalTime)value).toDateTimeToday());
        } else if (value instanceof DateMidnight) {
            super.setValueInternal((Object)((DateMidnight)value).toDateTime().toLocalDateTime());
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Calendar) {
            super.setValueInternal((Object)LocalDateTime.fromCalendarFields((Calendar)((Calendar)value)));
        } else if (value instanceof Date) {
            super.setValueInternal((Object)LocalDateTime.fromDateFields((Date)((Date)value)));
        } else if (value instanceof Number) {
            super.setValueInternal((Object)new LocalDateTime(((Number)value).longValue()));
        } else {
            throw this.illegalValue(value, LocalDateTime.class);
        }
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)new LocalDateTime(Long.parseLong(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            try {
                super.setValueInternal((Object)LocalDateTime.parse((String)str));
            }
            catch (IllegalArgumentException e) {
                throw this.illegalValue(str, LocalDateTime.class, e);
            }
            return;
        }
    }

    protected Formatter resolveFormatter() {
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? null : new DateTimeFormatter(this.getFormat());
    }
}

