/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.core.resources.formatters.Formatter;
import griffon.core.resources.formatters.ParseException;
import griffon.plugins.jodatime.formatters.DateTimeFormatter;
import griffon.util.GriffonNameUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class LocalDatePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof LocalDate) {
            super.setValueInternal(value);
        } else if (value instanceof DateTime) {
            super.setValueInternal((Object)((DateTime)value).toLocalDate());
        } else if (value instanceof LocalDateTime) {
            super.setValueInternal((Object)((LocalDateTime)value).toLocalDate());
        } else if (value instanceof DateMidnight) {
            super.setValueInternal((Object)((DateMidnight)value).toLocalDate());
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Calendar) {
            super.setValueInternal((Object)new LocalDate(value));
        } else if (value instanceof Date) {
            super.setValueInternal((Object)new LocalDate(value));
        } else if (value instanceof Number) {
            super.setValueInternal((Object)new LocalDate(((Number)value).longValue()));
        } else {
            throw this.illegalValue(value, LocalDate.class);
        }
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)new LocalDate(Long.parseLong(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            try {
                super.setValueInternal((Object)new DateTimeFormatter(DateTimeFormatter.Pattern.FULL_DATE).parse(str));
            }
            catch (ParseException e) {
                throw this.illegalValue(str, LocalDate.class, (Exception)((Object)e));
            }
            return;
        }
    }

    protected Formatter resolveFormatter() {
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? null : new DateTimeFormatter(this.getFormat());
    }
}

