/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import org.joda.time.Hours;

public class HoursPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Hours) {
            super.setValueInternal(value);
        } else if (value instanceof Number) {
            super.setValueInternal((Object)this.parse((Number)value));
        } else {
            throw this.illegalValue(value, Hours.class);
        }
    }

    protected String getAsTextInternal() {
        return this.getValue() == null ? "" : String.valueOf(((Hours)this.getValue()).getHours());
    }

    public String getFormattedValue() {
        return this.getValue() == null ? "" : this.getValue().toString();
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)this.parse(Integer.parseInt(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            try {
                super.setValueInternal((Object)Hours.parseHours((String)str));
            }
            catch (IllegalArgumentException e) {
                throw this.illegalValue(str, Hours.class, e);
            }
            return;
        }
    }

    private Hours parse(Number number) {
        return Hours.hours((int)Math.abs(number.intValue()));
    }
}

