/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import org.joda.time.Duration;

public class DurationPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Duration) {
            super.setValueInternal(value);
        } else if (value instanceof Number) {
            super.setValueInternal((Object)new Duration(((Number)value).longValue()));
        } else {
            throw this.illegalValue(value, Duration.class);
        }
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)new Duration(Long.parseLong(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            try {
                super.setValueInternal((Object)Duration.parse((String)str));
            }
            catch (IllegalArgumentException e) {
                throw this.illegalValue(str, Duration.class, e);
            }
            return;
        }
    }
}

