/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import org.joda.time.Days;

public class DaysPropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Days) {
            super.setValueInternal(value);
        } else if (value instanceof Number) {
            super.setValueInternal((Object)this.parse((Number)value));
        } else {
            throw this.illegalValue(value, Days.class);
        }
    }

    protected String getAsTextInternal() {
        return this.getValue() == null ? "" : String.valueOf(((Days)this.getValue()).getDays());
    }

    public String getFormattedValue() {
        return this.getValue() == null ? "" : this.getValue().toString();
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)this.parse(Integer.parseInt(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            try {
                super.setValueInternal((Object)Days.parseDays((String)str));
            }
            catch (IllegalArgumentException e) {
                throw this.illegalValue(str, Days.class, e);
            }
            return;
        }
    }

    private Days parse(Number number) {
        return Days.days((int)Math.abs(number.intValue()));
    }
}

