/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jodatime.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.core.resources.formatters.Formatter;
import griffon.core.resources.formatters.ParseException;
import griffon.plugins.jodatime.formatters.DateTimeFormatter;
import griffon.util.GriffonNameUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class DateTimePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof DateTime) {
            super.setValueInternal(value);
        } else if (value instanceof DateMidnight) {
            super.setValueInternal((Object)((DateMidnight)value).toDateTime());
        } else if (value instanceof Instant) {
            super.setValueInternal((Object)((Instant)value).toDateTime());
        } else if (value instanceof LocalDate) {
            super.setValueInternal((Object)((LocalDate)value).toDateTimeAtStartOfDay());
        } else if (value instanceof LocalDateTime) {
            super.setValueInternal((Object)((LocalDateTime)value).toDateTime());
        } else if (value instanceof LocalTime) {
            super.setValueInternal((Object)((LocalTime)value).toDateTimeToday());
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof Calendar) {
            super.setValueInternal((Object)new DateTime(value));
        } else if (value instanceof Date) {
            super.setValueInternal((Object)new DateTime(value));
        } else if (value instanceof Number) {
            super.setValueInternal((Object)new DateTime(((Number)value).longValue()));
        } else {
            throw this.illegalValue(value, DateTime.class);
        }
    }

    private void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)new DateTime(Long.parseLong(str)));
            return;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            try {
                super.setValueInternal((Object)new DateTimeFormatter().parse(str));
            }
            catch (ParseException e) {
                throw this.illegalValue(str, DateTime.class, (Exception)((Object)e));
            }
            return;
        }
    }

    protected Formatter resolveFormatter() {
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? null : new DateTimeFormatter(this.getFormat());
    }
}

