/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.util.Converter;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;

public class RigidBodyMotionState
extends MotionState {
    private Transform motionStateTrans = new Transform(Converter.convert(new Matrix3f()));
    private Vector3f worldLocation = new Vector3f();
    private Matrix3f worldRotation = new Matrix3f();
    private Quaternion worldRotationQuat = new Quaternion();
    private Vector3f localLocation = new Vector3f();
    private Quaternion localRotationQuat = new Quaternion();
    private boolean physicsLocationDirty = false;
    private boolean jmeLocationDirty = false;
    private Quaternion tmp_inverseWorldRotation = new Quaternion();
    private PhysicsVehicle vehicle;
    private boolean applyPhysicsLocal = false;

    public synchronized Transform getWorldTransform(Transform t) {
        t.set(this.motionStateTrans);
        return t;
    }

    public synchronized void setWorldTransform(Transform worldTrans) {
        if (this.jmeLocationDirty) {
            return;
        }
        this.motionStateTrans.set(worldTrans);
        Converter.convert(worldTrans.origin, this.worldLocation);
        Converter.convert(worldTrans.basis, this.worldRotation);
        this.worldRotationQuat.fromRotationMatrix(this.worldRotation);
        this.physicsLocationDirty = true;
        if (this.vehicle != null) {
            this.vehicle.updateWheels();
        }
    }

    public synchronized boolean applyTransform(Spatial spatial) {
        if (!this.physicsLocationDirty) {
            return false;
        }
        if (!this.applyPhysicsLocal && spatial.getParent() != null) {
            this.localLocation.set(this.worldLocation).subtractLocal(spatial.getParent().getWorldTranslation());
            this.localLocation.divideLocal(spatial.getParent().getWorldScale());
            this.tmp_inverseWorldRotation.set(spatial.getParent().getWorldRotation()).inverseLocal().multLocal(this.localLocation);
            this.localRotationQuat.set(this.worldRotationQuat);
            this.tmp_inverseWorldRotation.set(spatial.getParent().getWorldRotation()).inverseLocal().mult(this.localRotationQuat, this.localRotationQuat);
            spatial.setLocalTranslation(this.localLocation);
            spatial.setLocalRotation(this.localRotationQuat);
        } else {
            spatial.setLocalTranslation(this.worldLocation);
            spatial.setLocalRotation(this.worldRotationQuat);
        }
        this.physicsLocationDirty = false;
        return true;
    }

    public Vector3f getWorldLocation() {
        return this.worldLocation;
    }

    public Matrix3f getWorldRotation() {
        return this.worldRotation;
    }

    public Quaternion getWorldRotationQuat() {
        return this.worldRotationQuat;
    }

    public void setVehicle(PhysicsVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyPhysicsLocal;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyPhysicsLocal = applyPhysicsLocal;
    }
}

