/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;

public class VehicleWheel
implements Savable {
    protected WheelInfo wheelInfo;
    protected boolean frontWheel;
    protected Vector3f location = new Vector3f();
    protected Vector3f direction = new Vector3f();
    protected Vector3f axle = new Vector3f();
    protected float suspensionStiffness = 20.0f;
    protected float wheelsDampingRelaxation = 2.3f;
    protected float wheelsDampingCompression = 4.4f;
    protected float frictionSlip = 10.5f;
    protected float rollInfluence = 1.0f;
    protected float maxSuspensionTravelCm = 500.0f;
    protected float maxSuspensionForce = 6000.0f;
    protected float radius = 0.5f;
    protected float restLength = 1.0f;
    protected Vector3f wheelWorldLocation = new Vector3f();
    protected Quaternion wheelWorldRotation = new Quaternion();
    protected Spatial wheelSpatial;
    protected Matrix3f tmp_Matrix = new Matrix3f();
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();
    private boolean applyLocal = false;

    public VehicleWheel() {
    }

    public VehicleWheel(Spatial spat, Vector3f location, Vector3f direction, Vector3f axle, float restLength, float radius, boolean frontWheel) {
        this(location, direction, axle, restLength, radius, frontWheel);
        this.wheelSpatial = spat;
    }

    public VehicleWheel(Vector3f location, Vector3f direction, Vector3f axle, float restLength, float radius, boolean frontWheel) {
        this.location.set(location);
        this.direction.set(direction);
        this.axle.set(axle);
        this.frontWheel = frontWheel;
        this.restLength = restLength;
        this.radius = radius;
    }

    public synchronized void updatePhysicsState() {
        Converter.convert(this.wheelInfo.worldTransform.origin, this.wheelWorldLocation);
        Converter.convert(this.wheelInfo.worldTransform.basis, this.tmp_Matrix);
        this.wheelWorldRotation.fromRotationMatrix(this.tmp_Matrix);
    }

    public synchronized void applyWheelTransform() {
        if (this.wheelSpatial == null) {
            return;
        }
        Quaternion localRotationQuat = this.wheelSpatial.getLocalRotation();
        Vector3f localLocation = this.wheelSpatial.getLocalTranslation();
        if (!this.applyLocal && this.wheelSpatial.getParent() != null) {
            localLocation.set(this.wheelWorldLocation).subtractLocal(this.wheelSpatial.getParent().getWorldTranslation());
            localLocation.divideLocal(this.wheelSpatial.getParent().getWorldScale());
            this.tmp_inverseWorldRotation.set(this.wheelSpatial.getParent().getWorldRotation()).inverseLocal().multLocal(localLocation);
            localRotationQuat.set(this.wheelWorldRotation);
            this.tmp_inverseWorldRotation.set(this.wheelSpatial.getParent().getWorldRotation()).inverseLocal().mult(localRotationQuat, localRotationQuat);
            this.wheelSpatial.setLocalTranslation(localLocation);
            this.wheelSpatial.setLocalRotation(localRotationQuat);
        } else {
            this.wheelSpatial.setLocalTranslation(this.wheelWorldLocation);
            this.wheelSpatial.setLocalRotation(this.wheelWorldRotation);
        }
    }

    public WheelInfo getWheelInfo() {
        return this.wheelInfo;
    }

    public void setWheelInfo(WheelInfo wheelInfo) {
        this.wheelInfo = wheelInfo;
        this.applyInfo();
    }

    public boolean isFrontWheel() {
        return this.frontWheel;
    }

    public void setFrontWheel(boolean frontWheel) {
        this.frontWheel = frontWheel;
        this.applyInfo();
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public Vector3f getAxle() {
        return this.axle;
    }

    public float getSuspensionStiffness() {
        return this.suspensionStiffness;
    }

    public void setSuspensionStiffness(float suspensionStiffness) {
        this.suspensionStiffness = suspensionStiffness;
        this.applyInfo();
    }

    public float getWheelsDampingRelaxation() {
        return this.wheelsDampingRelaxation;
    }

    public void setWheelsDampingRelaxation(float wheelsDampingRelaxation) {
        this.wheelsDampingRelaxation = wheelsDampingRelaxation;
        this.applyInfo();
    }

    public float getWheelsDampingCompression() {
        return this.wheelsDampingCompression;
    }

    public void setWheelsDampingCompression(float wheelsDampingCompression) {
        this.wheelsDampingCompression = wheelsDampingCompression;
        this.applyInfo();
    }

    public float getFrictionSlip() {
        return this.frictionSlip;
    }

    public void setFrictionSlip(float frictionSlip) {
        this.frictionSlip = frictionSlip;
        this.applyInfo();
    }

    public float getRollInfluence() {
        return this.rollInfluence;
    }

    public void setRollInfluence(float rollInfluence) {
        this.rollInfluence = rollInfluence;
        this.applyInfo();
    }

    public float getMaxSuspensionTravelCm() {
        return this.maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(float maxSuspensionTravelCm) {
        this.maxSuspensionTravelCm = maxSuspensionTravelCm;
        this.applyInfo();
    }

    public float getMaxSuspensionForce() {
        return this.maxSuspensionForce;
    }

    public void setMaxSuspensionForce(float maxSuspensionForce) {
        this.maxSuspensionForce = maxSuspensionForce;
        this.applyInfo();
    }

    private void applyInfo() {
        if (this.wheelInfo == null) {
            return;
        }
        this.wheelInfo.suspensionStiffness = this.suspensionStiffness;
        this.wheelInfo.wheelsDampingRelaxation = this.wheelsDampingRelaxation;
        this.wheelInfo.wheelsDampingCompression = this.wheelsDampingCompression;
        this.wheelInfo.frictionSlip = this.frictionSlip;
        this.wheelInfo.rollInfluence = this.rollInfluence;
        this.wheelInfo.maxSuspensionTravelCm = this.maxSuspensionTravelCm;
        this.wheelInfo.maxSuspensionForce = this.maxSuspensionForce;
        this.wheelInfo.wheelsRadius = this.radius;
        this.wheelInfo.bIsFrontWheel = this.frontWheel;
        this.wheelInfo.suspensionRestLength1 = this.restLength;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.applyInfo();
    }

    public float getRestLength() {
        return this.restLength;
    }

    public void setRestLength(float restLength) {
        this.restLength = restLength;
        this.applyInfo();
    }

    public PhysicsCollisionObject getGroundObject() {
        if (this.wheelInfo.raycastInfo.groundObject == null) {
            return null;
        }
        if (this.wheelInfo.raycastInfo.groundObject instanceof RigidBody) {
            System.out.println("RigidBody");
            return (PhysicsRigidBody)((RigidBody)this.wheelInfo.raycastInfo.groundObject).getUserPointer();
        }
        return null;
    }

    public Vector3f getCollisionLocation(Vector3f vec) {
        Converter.convert(this.wheelInfo.raycastInfo.contactPointWS, vec);
        return vec;
    }

    public Vector3f getCollisionLocation() {
        return Converter.convert(this.wheelInfo.raycastInfo.contactPointWS);
    }

    public Vector3f getCollisionNormal(Vector3f vec) {
        Converter.convert(this.wheelInfo.raycastInfo.contactNormalWS, vec);
        return vec;
    }

    public Vector3f getCollisionNormal() {
        return Converter.convert(this.wheelInfo.raycastInfo.contactNormalWS);
    }

    public float getSkidInfo() {
        return this.wheelInfo.skidInfo;
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.wheelSpatial = (Spatial)capsule.readSavable("wheelSpatial", null);
        this.frontWheel = capsule.readBoolean("frontWheel", false);
        this.location = (Vector3f)capsule.readSavable("wheelLocation", (Savable)new Vector3f());
        this.direction = (Vector3f)capsule.readSavable("wheelDirection", (Savable)new Vector3f());
        this.axle = (Vector3f)capsule.readSavable("wheelAxle", (Savable)new Vector3f());
        this.suspensionStiffness = capsule.readFloat("suspensionStiffness", 20.0f);
        this.wheelsDampingRelaxation = capsule.readFloat("wheelsDampingRelaxation", 2.3f);
        this.wheelsDampingCompression = capsule.readFloat("wheelsDampingCompression", 4.4f);
        this.frictionSlip = capsule.readFloat("frictionSlip", 10.5f);
        this.rollInfluence = capsule.readFloat("rollInfluence", 1.0f);
        this.maxSuspensionTravelCm = capsule.readFloat("maxSuspensionTravelCm", 500.0f);
        this.maxSuspensionForce = capsule.readFloat("maxSuspensionForce", 6000.0f);
        this.radius = capsule.readFloat("wheelRadius", 0.5f);
        this.restLength = capsule.readFloat("restLength", 1.0f);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.wheelSpatial, "wheelSpatial", null);
        capsule.write(this.frontWheel, "frontWheel", false);
        capsule.write((Savable)this.location, "wheelLocation", (Savable)new Vector3f());
        capsule.write((Savable)this.direction, "wheelDirection", (Savable)new Vector3f());
        capsule.write((Savable)this.axle, "wheelAxle", (Savable)new Vector3f());
        capsule.write(this.suspensionStiffness, "suspensionStiffness", 20.0f);
        capsule.write(this.wheelsDampingRelaxation, "wheelsDampingRelaxation", 2.3f);
        capsule.write(this.wheelsDampingCompression, "wheelsDampingCompression", 4.4f);
        capsule.write(this.frictionSlip, "frictionSlip", 10.5f);
        capsule.write(this.rollInfluence, "rollInfluence", 1.0f);
        capsule.write(this.maxSuspensionTravelCm, "maxSuspensionTravelCm", 500.0f);
        capsule.write(this.maxSuspensionForce, "maxSuspensionForce", 6000.0f);
        capsule.write(this.radius, "wheelRadius", 0.5f);
        capsule.write(this.restLength, "restLength", 1.0f);
    }

    public Spatial getWheelSpatial() {
        return this.wheelSpatial;
    }

    public void setWheelSpatial(Spatial wheelSpatial) {
        this.wheelSpatial = wheelSpatial;
    }

    public boolean isApplyLocal() {
        return this.applyLocal;
    }

    public void setApplyLocal(boolean applyLocal) {
        this.applyLocal = applyLocal;
    }
}

