/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.SphereShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class SphereCollisionShape
extends CollisionShape {
    protected float radius;

    public SphereCollisionShape() {
    }

    public SphereCollisionShape(float radius) {
        this.radius = radius;
        this.createShape();
    }

    public float getRadius() {
        return this.radius;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.radius, "radius", 0.5f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.radius = capsule.readFloat("radius", 0.5f);
        this.createShape();
    }

    protected void createShape() {
        this.cShape = new SphereShape(this.radius);
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

