/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.Frame;
import de.jarnbjo.flac.Properties;
import de.jarnbjo.flac.StreamInfo;
import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class Subframe {
    public static Subframe createInstance(BitInputStream source, Frame frame, StreamInfo streamInfo, boolean sideChannel) throws FlacFormatException, IOException {
        if (source.getBit()) {
            throw new FlacFormatException("Sync error when trying to read subframe");
        }
        int type = source.getInt(6);
        int wastedBits = 0;
        if (source.getBit()) {
            do {
                ++wastedBits;
            } while (!source.getBit());
        }
        if (type == 0) {
            return new Constant(source, frame, streamInfo);
        }
        if (type == 1) {
            return new Verbatim(source, frame, streamInfo);
        }
        if ((type & 0x38) == 8 && (type & 7) <= 4) {
            int order = type & 7;
            return new Fixed(source, frame, streamInfo, wastedBits, order, sideChannel);
        }
        if ((type & 0x20) == 32) {
            int order = (type & 0x1F) + 1;
            return new Lpc(source, frame, streamInfo, wastedBits, order, sideChannel);
        }
        throw new FlacFormatException("Unknown or unsupported subframe type");
    }

    public abstract int[] getPcm();

    public static class Lpc
    extends Subframe {
        int[] pcm;
        int[] warmup;
        int[] residue;
        int[] coeffs;

        public Lpc(BitInputStream source, Frame frame, StreamInfo streamInfo, int wastedBits, int order, boolean sideChannel) throws FlacFormatException, IOException {
            int i;
            int bitsPerSample = frame.getBitsPerSample();
            if (sideChannel) {
                ++bitsPerSample;
            }
            this.warmup = new int[order];
            for (int i2 = 0; i2 < order; ++i2) {
                this.warmup[i2] = source.getSignedInt(bitsPerSample - wastedBits);
            }
            int coeffPrecision = source.getInt(4) + 1;
            if (coeffPrecision == 16) {
                throw new FlacFormatException("Illegal linear predictor coefficients' precision in SUBFRAME_LPC");
            }
            int quantizationLevel = source.getSignedInt(5);
            this.coeffs = new int[order];
            for (int i3 = 0; i3 < order; ++i3) {
                this.coeffs[i3] = source.getSignedInt(coeffPrecision);
            }
            int codingMethod = source.getInt(2);
            if (codingMethod != 0) {
                throw new FlacFormatException("SUBFRAME_FIXED: residual coding method " + codingMethod + " not supported", (ByteArrayBitInputStream)source);
            }
            int partitionOrder = source.getInt(4);
            int partitions = 1 << partitionOrder;
            int partitionSamples = partitionOrder > 0 ? frame.getBlockSize() >> partitionOrder : frame.getBlockSize() - order;
            this.pcm = new int[frame.getBlockSize()];
            this.residue = new int[frame.getBlockSize()];
            int sample = 0;
            for (int partition = 0; partition < partitions; ++partition) {
                int u;
                int riceParameter = source.getInt(4);
                if (riceParameter < 15) {
                    u = partitionOrder == 0 || partition > 0 ? partitionSamples : partitionSamples - order;
                    source.readSignedRice(riceParameter, this.residue, sample, u);
                    sample += u;
                    continue;
                }
                riceParameter = source.getInt(5);
                int n = u = partitionOrder == 0 || partition > 0 ? 0 : order;
                while (u < partitionSamples) {
                    this.residue[sample] = source.getSignedInt(riceParameter);
                    ++u;
                    ++sample;
                }
            }
            if (Properties.analyze()) {
                System.out.print("\tsubframe=?\twasted_bits=" + wastedBits + "\t");
                System.out.print("type=LPC\t");
                System.out.print("order=" + order + "\t");
                System.out.print("partition_order=" + partitionOrder + "\t");
                System.out.print("qlp_coeff_precision=" + coeffPrecision + "\t");
                System.out.println("quantization_level=" + quantizationLevel);
            }
            for (i = 0; i < order; ++i) {
                this.pcm[i] = this.warmup[i];
                if (!Properties.analyze()) continue;
                System.out.println("\t\twarmup[" + i + "]=" + this.warmup[i]);
            }
            for (i = 0; i < frame.getBlockSize() - order; ++i) {
                long sum = 0L;
                int history = i + order;
                for (int j = 0; j < order; ++j) {
                    sum += (long)this.coeffs[j] * (long)this.pcm[--history];
                }
                this.pcm[i + order] = quantizationLevel >= 0 ? this.residue[i] + (int)(sum >> quantizationLevel) : this.residue[i] + (int)(sum << -quantizationLevel);
            }
            if (wastedBits > 0) {
                i = 0;
                while (i < this.pcm.length) {
                    int n = i++;
                    this.pcm[n] = this.pcm[n] << wastedBits;
                }
            }
        }

        public int[] getPcm() {
            return this.pcm;
        }
    }

    public static class Fixed
    extends Subframe {
        int[] pcm;
        int[] warmup;
        int[] residue;

        public Fixed(BitInputStream source, Frame frame, StreamInfo streamInfo, int wastedBits, int order, boolean sideChannel) throws FlacFormatException, IOException {
            int i;
            int partitionSamples;
            int bitsPerSample = frame.getBitsPerSample();
            if (sideChannel) {
                ++bitsPerSample;
            }
            this.warmup = new int[order];
            for (int i2 = 0; i2 < order; ++i2) {
                this.warmup[i2] = source.getSignedInt(bitsPerSample - wastedBits);
            }
            int codingMethod = source.getInt(2);
            if (codingMethod != 0) {
                throw new FlacFormatException("SUBFRAME_FIXED: residual coding method " + codingMethod + " not supported");
            }
            int partitionOrder = source.getInt(4);
            int partitions = 1 << partitionOrder;
            int n = partitionSamples = partitionOrder > 0 ? frame.getBlockSize() >> partitionOrder : frame.getBlockSize() - order;
            if (Properties.analyze()) {
                System.out.print("\tsubframe=?\twasted_bits=" + wastedBits + "\t");
                System.out.print("type=FIXED\t");
                System.out.print("order=" + order + "\t");
                System.out.println("partition_order=" + partitionOrder);
            }
            this.pcm = new int[frame.getBlockSize()];
            this.residue = new int[frame.getBlockSize()];
            int sample = 0;
            for (int partition = 0; partition < partitions; ++partition) {
                int u;
                int riceParameter = source.getInt(4);
                if (riceParameter < 15) {
                    u = partitionOrder == 0 || partition > 0 ? partitionSamples : partitionSamples - order;
                    source.readSignedRice(riceParameter, this.residue, sample, u);
                    sample += u;
                    continue;
                }
                riceParameter = source.getInt(5);
                int n2 = u = partitionOrder == 0 || partition > 0 ? 0 : order;
                while (u < partitionSamples) {
                    this.residue[sample] = source.getSignedInt(riceParameter);
                    ++u;
                    ++sample;
                }
            }
            for (i = 0; i < order; ++i) {
                this.pcm[i] = this.warmup[i];
                if (!Properties.analyze()) continue;
                System.out.println("\t\twarmup[" + i + "]=" + this.warmup[i]);
            }
            int len = frame.getBlockSize() - order;
            switch (order) {
                case 0: {
                    for (i = 0; i < len; ++i) {
                        this.pcm[i] = this.residue[i];
                    }
                    break;
                }
                case 1: {
                    for (i = 0; i < len; ++i) {
                        this.pcm[i + 1] = this.residue[i] + this.pcm[i];
                    }
                    break;
                }
                case 2: {
                    for (i = 0; i < len; ++i) {
                        this.pcm[i + 2] = this.residue[i] + (this.pcm[i + 1] << 1) - this.pcm[i];
                    }
                    break;
                }
                case 3: {
                    for (i = 0; i < len; ++i) {
                        this.pcm[i + 3] = this.residue[i] + ((this.pcm[i + 2] - this.pcm[i + 1] << 1) + (this.pcm[i + 2] - this.pcm[i + 1])) + this.pcm[i];
                    }
                    break;
                }
                case 4: {
                    for (i = 0; i < len; ++i) {
                        this.pcm[i + 4] = this.residue[i] + (this.pcm[i + 3] + this.pcm[i + 1] << 2) - ((this.pcm[i + 2] << 2) + (this.pcm[i + 2] << 1)) - this.pcm[i];
                    }
                    break;
                }
                default: {
                    throw new FlacFormatException("Illegal SUBFRAME_FIXED order");
                }
            }
            if (wastedBits > 0) {
                i = 0;
                while (i < this.pcm.length) {
                    int n3 = i++;
                    this.pcm[n3] = this.pcm[n3] << wastedBits;
                }
            }
        }

        public int[] getPcm() {
            return this.pcm;
        }
    }

    public static class Verbatim
    extends Subframe {
        int[] pcm;

        public Verbatim(BitInputStream source, Frame frame, StreamInfo streamInfo) throws FlacFormatException, IOException {
            int bps = frame.getBitsPerSample();
            int blockSize = frame.getBlockSize();
            this.pcm = new int[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                this.pcm[i] = source.getSignedInt(bps);
            }
        }

        public int[] getPcm() {
            return this.pcm;
        }
    }

    public static class Constant
    extends Subframe {
        int[] pcm;

        public Constant(BitInputStream source, Frame frame, StreamInfo streamInfo) throws FlacFormatException, IOException {
            int c = source.getSignedInt(frame.getBitsPerSample());
            this.pcm = new int[frame.getBlockSize()];
            Arrays.fill(this.pcm, c);
        }

        public int[] getPcm() {
            return this.pcm;
        }
    }
}

