/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.nvtex;

import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.system.JmeSystem;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.plugins.HDRLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jme3tools.converters.ImageToAwt;
import jme3tools.converters.MipMapGenerator;

public class NVCompress
extends JFrame {
    private static Preferences pref = Preferences.userNodeForPackage(NVCompress.class);
    private static File texToolsPath;
    private static final String appName = "NVCompress GUI 1.00";
    private Thread workThread = null;
    private AssetManager manager;
    private JProgressBar barProgress;
    private JButton btnAddFiles;
    private JButton btnBrowse;
    private JButton btnCompress;
    private JButton btnDecompress;
    private JButton btnRemoveFiles;
    private JCheckBox chkAsSource;
    private JCheckBox chkCuda;
    private JCheckBox chkLowQuality;
    private JCheckBox chkMips;
    private JCheckBox chkRepeat;
    private JComboBox cmbCompressType;
    private JComboBox cmbMapType;
    private JMenuItem itemExit;
    private JMenuBar jMenuBar1;
    private JLabel lblCompressType;
    private JLabel lblMapType;
    private JLabel lblTargetDir;
    private JList lstFileList;
    private JMenuItem menuAbout;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JPanel pnlCompressOpt;
    private JPanel pnlExportOpt;
    private JPanel pnlMapType;
    private JScrollPane sclFileList;
    private JTextField txtTargetDir;

    public NVCompress() {
        this.initComponents();
        this.barProgress.setVisible(false);
        this.setLocationRelativeTo(null);
        System.out.println(appName);
        this.setTitle(appName);
    }

    private void initComponents() {
        this.pnlMapType = new JPanel();
        this.cmbMapType = new JComboBox();
        this.chkMips = new JCheckBox();
        this.lblMapType = new JLabel();
        this.chkRepeat = new JCheckBox();
        this.pnlCompressOpt = new JPanel();
        this.cmbCompressType = new JComboBox();
        this.chkLowQuality = new JCheckBox();
        this.lblCompressType = new JLabel();
        this.chkCuda = new JCheckBox();
        this.sclFileList = new JScrollPane();
        this.lstFileList = new JList();
        this.btnAddFiles = new JButton();
        this.btnRemoveFiles = new JButton();
        this.pnlExportOpt = new JPanel();
        this.lblTargetDir = new JLabel();
        this.txtTargetDir = new JTextField();
        this.btnBrowse = new JButton();
        this.chkAsSource = new JCheckBox();
        this.btnCompress = new JButton();
        this.btnDecompress = new JButton();
        this.barProgress = new JProgressBar();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.itemExit = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuAbout = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("NVCompress GUI");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NVCompress.this.formWindowClosing(evt);
            }
        });
        this.pnlMapType.setBorder(BorderFactory.createTitledBorder("Input Options"));
        this.cmbMapType.setModel(new DefaultComboBoxModel<String>(new String[]{"Color Map", "Normal Map", "Height/Convert to Normal Map"}));
        this.chkMips.setSelected(true);
        this.chkMips.setText("Generate Mipmaps");
        this.lblMapType.setText("Map Type: ");
        this.chkRepeat.setText("Repeating");
        GroupLayout pnlMapTypeLayout = new GroupLayout(this.pnlMapType);
        this.pnlMapType.setLayout(pnlMapTypeLayout);
        pnlMapTypeLayout.setHorizontalGroup(pnlMapTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMapTypeLayout.createSequentialGroup().addContainerGap().addGroup(pnlMapTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkRepeat).addComponent(this.chkMips).addGroup(pnlMapTypeLayout.createSequentialGroup().addComponent(this.lblMapType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbMapType, -2, -1, -2))).addContainerGap(118, Short.MAX_VALUE)));
        pnlMapTypeLayout.setVerticalGroup(pnlMapTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMapTypeLayout.createSequentialGroup().addGroup(pnlMapTypeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMapType).addComponent(this.cmbMapType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkMips).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkRepeat).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlCompressOpt.setBorder(BorderFactory.createTitledBorder("Compression Options"));
        this.cmbCompressType.setModel(new DefaultComboBoxModel<String>(new String[]{"RGBA", "DXT1", "DXT1nm", "DXT1a", "DXT3", "DXT5", "DXT5nm", "ATI1", "ATI2/3Dc", "P4RGB565", "P8RGB565", "AWT", "PNG-RGBE"}));
        this.cmbCompressType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.cmbCompressTypeActionPerformed(evt);
            }
        });
        this.chkLowQuality.setText("Low Quality");
        this.lblCompressType.setText("Compression Type: ");
        this.chkCuda.setSelected(true);
        this.chkCuda.setText("Use GPU Compression (faster)");
        GroupLayout pnlCompressOptLayout = new GroupLayout(this.pnlCompressOpt);
        this.pnlCompressOpt.setLayout(pnlCompressOptLayout);
        pnlCompressOptLayout.setHorizontalGroup(pnlCompressOptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCompressOptLayout.createSequentialGroup().addContainerGap().addGroup(pnlCompressOptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCompressOptLayout.createSequentialGroup().addComponent(this.chkLowQuality).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCuda)).addGroup(pnlCompressOptLayout.createSequentialGroup().addComponent(this.lblCompressType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbCompressType, -2, -1, -2))).addContainerGap(117, Short.MAX_VALUE)));
        pnlCompressOptLayout.setVerticalGroup(pnlCompressOptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCompressOptLayout.createSequentialGroup().addGroup(pnlCompressOptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkLowQuality).addComponent(this.chkCuda)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlCompressOptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCompressType).addComponent(this.cmbCompressType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.lstFileList.setModel(new DefaultListModel());
        this.lstFileList.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                NVCompress.this.lstFileListKeyTyped(evt);
            }
        });
        this.sclFileList.setViewportView(this.lstFileList);
        this.btnAddFiles.setText("Add files..");
        this.btnAddFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.btnAddFilesActionPerformed(evt);
            }
        });
        this.btnRemoveFiles.setText("Remove Selected");
        this.btnRemoveFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.btnRemoveFilesActionPerformed(evt);
            }
        });
        this.pnlExportOpt.setBorder(BorderFactory.createTitledBorder("Export Options"));
        this.lblTargetDir.setText("Target Folder: ");
        this.btnBrowse.setText("Browse..");
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.btnBrowseActionPerformed(evt);
            }
        });
        this.chkAsSource.setText("Same as source");
        this.chkAsSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.chkAsSourceActionPerformed(evt);
            }
        });
        this.btnCompress.setText("Compress");
        this.btnCompress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.btnCompressActionPerformed(evt);
            }
        });
        this.btnDecompress.setText("Decompress");
        this.btnDecompress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.btnDecompressActionPerformed(evt);
            }
        });
        GroupLayout pnlExportOptLayout = new GroupLayout(this.pnlExportOpt);
        this.pnlExportOpt.setLayout(pnlExportOptLayout);
        pnlExportOptLayout.setHorizontalGroup(pnlExportOptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExportOptLayout.createSequentialGroup().addContainerGap().addGroup(pnlExportOptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExportOptLayout.createSequentialGroup().addComponent(this.lblTargetDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtTargetDir, -1, 217, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnBrowse)).addComponent(this.chkAsSource).addGroup(pnlExportOptLayout.createSequentialGroup().addComponent(this.btnCompress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDecompress))).addContainerGap()));
        pnlExportOptLayout.setVerticalGroup(pnlExportOptLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExportOptLayout.createSequentialGroup().addGroup(pnlExportOptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTargetDir).addComponent(this.txtTargetDir, -2, -1, -2).addComponent(this.btnBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkAsSource).addGap(7, 7, 7).addGroup(pnlExportOptLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCompress).addComponent(this.btnDecompress)).addContainerGap(-1, Short.MAX_VALUE)));
        this.barProgress.setStringPainted(true);
        this.menuFile.setText("File");
        this.itemExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.itemExit.setText("Exit");
        this.itemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.itemExitActionPerformed(evt);
            }
        });
        this.menuFile.add(this.itemExit);
        this.jMenuBar1.add(this.menuFile);
        this.menuHelp.setText("Help");
        this.menuAbout.setText("About");
        this.menuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NVCompress.this.menuAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuAbout);
        this.jMenuBar1.add(this.menuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.barProgress, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlCompressOpt, -1, -1, Short.MAX_VALUE).addComponent(this.pnlExportOpt, -1, -1, Short.MAX_VALUE).addComponent(this.pnlMapType, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnAddFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveFiles)).addComponent(this.sclFileList, -1, 263, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlMapType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlCompressOpt, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlExportOpt, -2, -1, -2)).addComponent(this.sclFileList, -1, 380, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.barProgress, -1, 30, Short.MAX_VALUE).addComponent(this.btnRemoveFiles, -2, 24, Short.MAX_VALUE).addComponent(this.btnAddFiles, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private String[] computeCompressParameters() {
        ArrayList<String> params = new ArrayList<String>();
        if (!this.chkCuda.isSelected()) {
            params.add("-nocuda");
        }
        switch (this.cmbMapType.getSelectedIndex()) {
            case 0: {
                params.add("-color");
                break;
            }
            case 1: {
                params.add("-normal");
                break;
            }
            case 2: {
                params.add("-tonormal");
            }
        }
        if (!this.chkMips.isSelected()) {
            params.add("-nomips");
        }
        if (this.chkRepeat.isSelected()) {
            params.add("-repeat");
        }
        if (this.chkLowQuality.isSelected()) {
            params.add("-fast");
        }
        switch (this.cmbCompressType.getSelectedIndex()) {
            case 0: {
                params.add("-rgb");
                break;
            }
            case 1: {
                params.add("-bc1");
                break;
            }
            case 2: {
                params.add("-bc1n");
                break;
            }
            case 3: {
                params.add("-bc1a");
                break;
            }
            case 4: {
                params.add("-bc2");
                break;
            }
            case 5: {
                params.add("-bc3");
                break;
            }
            case 6: {
                params.add("-bc3n");
                break;
            }
            case 7: {
                params.add("-bc4");
                break;
            }
            case 8: {
                params.add("-bc5");
            }
        }
        return params.toArray(new String[0]);
    }

    private void updateWork(String workStatus, int percent) {
        this.barProgress.setString(workStatus + " - " + percent + "%");
        this.barProgress.setValue(percent);
    }

    private void setComponentEnabled(Container c, boolean enabled) {
        c.setEnabled(enabled);
        for (Component child : c.getComponents()) {
            if (child instanceof Container) {
                this.setComponentEnabled((Container)child, enabled);
                continue;
            }
            child.setEnabled(enabled);
        }
    }

    private void startWork() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.barProgress.setVisible(true);
        this.barProgress.setValue(0);
        this.barProgress.setString("Status: Working");
        this.setComponentEnabled(this.pnlCompressOpt, false);
        this.setComponentEnabled(this.pnlExportOpt, false);
        this.setComponentEnabled(this.pnlMapType, false);
        this.lstFileList.setEnabled(false);
        this.btnAddFiles.setEnabled(false);
        this.btnRemoveFiles.setEnabled(false);
    }

    private void endWork() {
        this.workThread = null;
        this.setCursor(null);
        this.barProgress.setVisible(false);
        this.barProgress.setString("Status: Done");
        this.setComponentEnabled(this.pnlCompressOpt, true);
        this.setComponentEnabled(this.pnlExportOpt, true);
        this.setComponentEnabled(this.pnlMapType, true);
        this.lstFileList.setEnabled(true);
        this.btnAddFiles.setEnabled(true);
        this.btnRemoveFiles.setEnabled(true);
        this.chkAsSourceActionPerformed(null);
        this.btnCompress.setText("Compress");
        this.btnDecompress.setText("Decompress");
    }

    private void runJ3(File input, File output, String statusStr) throws InterruptedException {
        this.updateWork(statusStr, 0);
        if (this.manager == null) {
            this.manager = JmeSystem.newAssetManager();
        }
        this.manager.registerLocator(input.getParent().toString(), FileLocator.class.getName());
        String format = (String)this.cmbCompressType.getSelectedItem();
        if (format.equals("PNG-RGBE")) {
            HDRLoader loader = new HDRLoader(true);
            try {
                FileInputStream in = new FileInputStream(input);
                Image image = loader.load(in, false);
                in.close();
                BufferedImage rgbeImage = ImageToAwt.convert(image, false, true, 0);
                if (output == null) {
                    output = new File(input.getParent(), input.getName() + ".png");
                }
                ImageIO.write((RenderedImage)rgbeImage, "png", output);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            Texture tex = this.manager.loadTexture(input.getName());
            Image image = tex.getImage();
            boolean mips = this.chkMips.isSelected();
            if (mips && !image.hasMipmaps()) {
                MipMapGenerator.generateMipMaps(image);
            }
            if (output == null) {
                output = new File(input.getParent(), input.getName() + ".j3i");
            }
            try {
                BinaryExporter.getInstance().save((Savable)image, output);
                BufferedImage preview = ImageToAwt.convert(image, false, true, 0);
                ImageIO.write((RenderedImage)preview, "png", new File(output + ".png"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void runCommand(String[] args, String statusStr) throws InterruptedException {
        Process p = null;
        try {
            String ln;
            ProcessBuilder builder = new ProcessBuilder(args);
            this.updateWork(statusStr, 0);
            p = builder.start();
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((ln = r.readLine()) != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (ln.endsWith("%")) {
                    int percent = Integer.parseInt(ln.substring(0, ln.length() - 1));
                    this.updateWork(statusStr, percent);
                    continue;
                }
                if (!ln.startsWith("time taken")) continue;
                ln = ln.substring(12, ln.length() - 7).trim();
                System.out.println("Time Taken: " + ln + " seconds");
            }
            r.close();
            int error = p.waitFor();
            if (error != 0) {
                System.out.println("Error Code: " + error);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            if (p != null) {
                p.destroy();
            }
            throw ex;
        }
    }

    private void runNVDecompress(File inFile) throws InterruptedException {
        if (!inFile.getName().toLowerCase().endsWith(".dds")) {
            return;
        }
        String[] args = new String[]{new File(texToolsPath, "nvdecompress").toString(), inFile.toString()};
        System.out.println("Decompressing file " + inFile);
        this.runCommand(args, "Decompressing file " + inFile.getName());
    }

    private void runNVCompress(File inFile, File outFile) throws InterruptedException {
        String nvcompressCmd = new File(texToolsPath, "nvcompress").toString();
        int argCount = 2;
        if (outFile != null) {
            ++argCount;
        }
        String[] params = this.computeCompressParameters();
        String[] args = new String[argCount += params.length];
        args[0] = nvcompressCmd;
        System.arraycopy(params, 0, args, 1, params.length);
        args[params.length + 1] = inFile.toString();
        if (outFile != null) {
            args[params.length + 2] = outFile.toString();
        }
        System.out.println("Converting file " + inFile);
        this.runCommand(args, "Converting " + inFile.getName());
    }

    private void runJ3Compress(File inFile, File outFile) throws InterruptedException {
        System.out.println("Converting file " + inFile);
        this.runJ3(inFile, outFile, "Converting " + inFile.getName());
    }

    private Object[] compileFileList() {
        Object[] values = this.lstFileList.getSelectedValues();
        if (values == null || values.length == 0) {
            DefaultListModel listModel = (DefaultListModel)this.lstFileList.getModel();
            values = listModel.toArray();
        }
        return values;
    }

    private void runNVCompressAll(final File exportDir) {
        final Object[] fileList = this.compileFileList();
        if (fileList != null && fileList.length > 0) {
            this.startWork();
            this.workThread = new Thread(){

                public void run() {
                    for (Object val : fileList) {
                        File inFile = (File)val;
                        File outFile = null;
                        if (exportDir != null) {
                            String name = inFile.getName();
                            int extPt = name.lastIndexOf(".");
                            if (extPt > 0) {
                                name = name.substring(0, extPt);
                            }
                            outFile = new File(exportDir, name + ".dds");
                        }
                        try {
                            NVCompress.this.runNVCompress(inFile, outFile);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    NVCompress.this.endWork();
                }
            };
            this.workThread.setDaemon(true);
            this.workThread.start();
        }
    }

    private void runJ3CompressAll(final File exportDir, final String ext) {
        final Object[] fileList = this.compileFileList();
        if (fileList != null && fileList.length > 0) {
            this.startWork();
            this.workThread = new Thread(){

                public void run() {
                    for (Object val : fileList) {
                        File inFile = (File)val;
                        File outFile = null;
                        if (exportDir != null) {
                            String name = inFile.getName();
                            int extPt = name.lastIndexOf(".");
                            if (extPt > 0) {
                                name = name.substring(0, extPt);
                            }
                            outFile = new File(exportDir, name + "." + ext);
                        }
                        try {
                            NVCompress.this.runJ3Compress(inFile, outFile);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    NVCompress.this.endWork();
                }
            };
            this.workThread.setDaemon(true);
            this.workThread.start();
        }
    }

    private void runNVDecompressAll() {
        final Object[] fileList = this.compileFileList();
        if (fileList != null && fileList.length > 0) {
            this.startWork();
            this.workThread = new Thread(){

                public void run() {
                    for (Object val : fileList) {
                        File inFile = (File)val;
                        try {
                            NVCompress.this.runNVDecompress(inFile);
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    NVCompress.this.endWork();
                }
            };
            this.workThread.setDaemon(true);
            this.workThread.start();
        }
    }

    private void cmbCompressTypeActionPerformed(ActionEvent evt) {
    }

    private void btnCompressActionPerformed(ActionEvent evt) {
        if (this.btnCompress.getText().equals("Cancel")) {
            if (this.workThread != null) {
                this.workThread.interrupt();
                System.out.println("User canceled decompression");
                this.endWork();
            }
        } else {
            String compression;
            String exportPath;
            File exportDir = null;
            if (!this.chkAsSource.isSelected() && (exportPath = this.txtTargetDir.getText()) != null && !exportPath.equals("")) {
                exportDir = new File(exportPath);
            }
            if ((compression = (String)this.cmbCompressType.getSelectedItem()).equals("AWT") || compression.equals("PNG-RGBE")) {
                this.runJ3CompressAll(exportDir, compression.equals("AWT") ? "j3i" : "pnge");
            } else {
                this.runNVCompressAll(exportDir);
            }
            this.btnCompress.setEnabled(true);
            this.btnCompress.setText("Cancel");
        }
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select export directory");
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        if (this.txtTargetDir.getText() != null && !this.txtTargetDir.getText().equals("")) {
            chooser.setSelectedFile(new File(this.txtTargetDir.getText()));
        }
        if (chooser.showOpenDialog(null) == 0) {
            File f = chooser.getSelectedFile();
            if (f != null && f.exists() && f.isDirectory()) {
                this.txtTargetDir.setText(f.toString());
            } else {
                JOptionPane.showMessageDialog(this, "Invalid export directory specified", "Error", 0);
            }
        }
    }

    private void chkAsSourceActionPerformed(ActionEvent evt) {
        this.lblTargetDir.setEnabled(!this.chkAsSource.isSelected());
        this.txtTargetDir.setEnabled(!this.chkAsSource.isSelected());
        this.btnBrowse.setEnabled(!this.chkAsSource.isSelected());
    }

    private void btnAddFilesActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Add input files");
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(0);
        if (chooser.showOpenDialog(this) == 0) {
            File[] files;
            for (File file : files = chooser.getSelectedFiles()) {
                DefaultListModel listModel;
                if (!file.exists() || file.isDirectory() || (listModel = (DefaultListModel)this.lstFileList.getModel()).contains(file)) continue;
                listModel.addElement(file);
            }
        }
    }

    private void btnRemoveFilesActionPerformed(ActionEvent evt) {
        Object[] selected = this.lstFileList.getSelectedValues();
        DefaultListModel listModel = (DefaultListModel)this.lstFileList.getModel();
        for (Object val : selected) {
            listModel.removeElement(val);
        }
    }

    private void itemExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        String aboutText = "NVCompress GUI 1.00\nCreated by Kirill Vainer.\n\nNVIDIA Texture Tools is Copyright\u00a9 2009 NVIDIA Corporation.\n\nUsage: \n   Press \"Add Files..\" to add files to convert\n   Select conversion options on the left, then\n   click \"Export\" to convert files to DDS\n";
        JOptionPane.showMessageDialog(this, aboutText, "About", -1);
    }

    private void lstFileListKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.btnRemoveFilesActionPerformed(null);
        }
    }

    private void btnDecompressActionPerformed(ActionEvent evt) {
        if (this.btnDecompress.getText().equals("Cancel")) {
            if (this.workThread != null) {
                this.workThread.interrupt();
                System.out.println("User canceled decompression");
                this.endWork();
            }
        } else {
            this.runNVDecompressAll();
            this.btnDecompress.setEnabled(true);
            this.btnDecompress.setText("Cancel");
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.workThread != null) {
            this.workThread.interrupt();
        }
    }

    private static boolean verifyTexToolsPath(File path) {
        if (path.exists()) {
            File[] files;
            for (File f : files = path.listFiles()) {
                if (!f.getName().startsWith("nvcompress")) continue;
                return true;
            }
        }
        return false;
    }

    private static File showToolsPathChooser(File prevPath) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select directory of NVTextureTools");
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        if (prevPath != null) {
            chooser.setSelectedFile(prevPath);
        }
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static String attemptLocateToolsPath() {
        String path = pref.get("NVTextureToolsPath", null);
        if (path == null) {
            path = System.getenv("TEXTURE_TOOLS_DIR");
        }
        return path;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Verifiying texture tools path..");
        String path = NVCompress.attemptLocateToolsPath();
        File file = texToolsPath = path == null ? null : new File(path);
        if (texToolsPath != null) {
            System.out.println("Found existing path: " + texToolsPath);
        }
        if (texToolsPath == null || !NVCompress.verifyTexToolsPath(texToolsPath)) {
            while (true) {
                File f;
                if ((f = NVCompress.showToolsPathChooser(texToolsPath)) == null) {
                    return;
                }
                if (NVCompress.verifyTexToolsPath(f)) {
                    texToolsPath = f;
                    pref.put("NVTextureToolsPath", texToolsPath.toString());
                    System.out.println("User specified valid path: " + texToolsPath);
                    try {
                        pref.flush();
                    }
                    catch (BackingStoreException backingStoreException) {}
                    break;
                }
                JOptionPane.showMessageDialog(null, "Directory must contain nvcompress", "Error", 0);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new NVCompress().setVisible(true);
            }
        });
    }
}

