/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.dummy.DummyKeyInput;
import com.jme3.input.dummy.DummyMouseInput;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.NanoTimer;
import com.jme3.system.NullRenderer;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NullContext
implements JmeContext,
Runnable {
    protected static final Logger logger = Logger.getLogger(NullContext.class.getName());
    protected AtomicBoolean created = new AtomicBoolean(false);
    protected AtomicBoolean needClose = new AtomicBoolean(false);
    protected final Object createdLock = new Object();
    protected int frameRate;
    protected AppSettings settings = new AppSettings(true);
    protected Timer timer;
    protected SystemListener listener;
    protected NullRenderer renderer;
    private static long timeThen;
    private static long timeLate;

    public JmeContext.Type getType() {
        return JmeContext.Type.Headless;
    }

    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInThread() {
        logger.info("NullContext created.");
        logger.log(Level.FINE, "Running on thread: {0}", Thread.currentThread().getName());
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable thrown) {
                NullContext.this.listener.handleError("Uncaught exception thrown in " + thread.toString(), thrown);
            }
        });
        this.timer = new NanoTimer();
        this.renderer = new NullRenderer();
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(true);
            this.createdLock.notifyAll();
        }
        this.listener.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deinitInThread() {
        this.listener.destroy();
        this.timer = null;
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(false);
            this.createdLock.notifyAll();
        }
    }

    public void sync(int fps) {
        long gapTo = this.timer.getResolution() / (long)fps + timeThen;
        long timeNow = this.timer.getTime();
        long savedTimeLate = timeLate;
        try {
            while (gapTo > timeNow + savedTimeLate) {
                Thread.sleep(1L);
                timeNow = this.timer.getTime();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        timeLate = gapTo < timeNow ? timeNow - gapTo : 0L;
        timeThen = timeNow;
    }

    public void run() {
        this.initInThread();
        while (!this.needClose.get()) {
            this.listener.update();
            if (this.frameRate <= 0) continue;
            this.sync(this.frameRate);
        }
        this.deinitInThread();
        logger.info("NullContext destroyed.");
    }

    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (waitFor) {
            this.waitFor(false);
        }
    }

    public void create(boolean waitFor) {
        if (this.created.get()) {
            logger.warning("create() called when NullContext is already created!");
            return;
        }
        new Thread((Runnable)this, "Headless Application Thread").start();
        if (waitFor) {
            this.waitFor(true);
        }
    }

    public void restart() {
    }

    public void setAutoFlushFrames(boolean enabled) {
    }

    public MouseInput getMouseInput() {
        return new DummyMouseInput();
    }

    public KeyInput getKeyInput() {
        return new DummyKeyInput();
    }

    public JoyInput getJoyInput() {
        return null;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public void setTitle(String title) {
    }

    public void create() {
        this.create(false);
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(boolean createdVal) {
        Object object = this.createdLock;
        synchronized (object) {
            while (this.created.get() != createdVal) {
                try {
                    this.createdLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isCreated() {
        return this.created.get();
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.frameRate = settings.getFrameRate();
        if (this.frameRate <= 0) {
            this.frameRate = 60;
        }
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public boolean isRenderable() {
        return true;
    }
}

