/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.app.SettingsDialog;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.DesktopAssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.Natives;
import com.jme3.system.NullContext;
import com.jme3.system.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class JmeSystem {
    private static final Logger logger = Logger.getLogger(JmeSystem.class.getName());
    private static boolean initialized = false;
    private static boolean lowPermissions = false;
    private static File storageFolder = null;

    public static synchronized File getStorageFolder() {
        if (lowPermissions) {
            throw new UnsupportedOperationException("File system access restricted");
        }
        if (storageFolder == null && !(storageFolder = new File(System.getProperty("user.home"), ".jme3")).exists()) {
            storageFolder.mkdir();
        }
        return storageFolder;
    }

    public static String getFullName() {
        return "jMonkeyEngine 3.0.0 Beta";
    }

    public static InputStream getResourceAsStream(String name) {
        return JmeSystem.class.getResourceAsStream(name);
    }

    public static URL getResource(String name) {
        return JmeSystem.class.getResource(name);
    }

    public static boolean trackDirectMemory() {
        return false;
    }

    public static void setLowPermissions(boolean lowPerm) {
        lowPermissions = lowPerm;
    }

    public static boolean isLowPermissions() {
        return lowPermissions;
    }

    public static AssetManager newAssetManager(URL configFile) {
        return new DesktopAssetManager(configFile);
    }

    public static AssetManager newAssetManager() {
        return new DesktopAssetManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showSettingsDialog(AppSettings sourceSettings, final boolean loadFromRegistry) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot run from EDT");
        }
        final AppSettings settings = new AppSettings(false);
        settings.copyFrom(sourceSettings);
        String iconPath = sourceSettings.getSettingsDialogImage();
        final URL iconUrl = JmeSystem.class.getResource(iconPath.startsWith("/") ? iconPath : "/" + iconPath);
        if (iconUrl == null) {
            throw new AssetNotFoundException(sourceSettings.getSettingsDialogImage());
        }
        final AtomicBoolean done = new AtomicBoolean();
        final AtomicInteger result = new AtomicInteger();
        final Object lock = new Object();
        final SettingsDialog.SelectionListener selectionListener = new SettingsDialog.SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSelection(int selection) {
                Object object = lock;
                synchronized (object) {
                    done.set(true);
                    result.set(selection);
                    lock.notifyAll();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    SettingsDialog dialog = new SettingsDialog(settings, iconUrl, loadFromRegistry);
                    dialog.setSelectionListener(selectionListener);
                    dialog.showDialog();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            while (!done.get()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ex) {}
            }
        }
        sourceSettings.copyFrom(settings);
        return result.get() == 1;
    }

    private static boolean is64Bit(String arch) {
        if (arch.equals("x86")) {
            return false;
        }
        if (arch.equals("amd64")) {
            return true;
        }
        if (arch.equals("x86_64")) {
            return true;
        }
        if (arch.equals("ppc") || arch.equals("PowerPC")) {
            return false;
        }
        if (arch.equals("ppc64")) {
            return true;
        }
        if (arch.equals("i386") || arch.equals("i686")) {
            return false;
        }
        if (arch.equals("universal")) {
            return false;
        }
        throw new UnsupportedOperationException("Unsupported architecture: " + arch);
    }

    public static Platform getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean is64 = JmeSystem.is64Bit(arch);
        if (os.contains("windows")) {
            return is64 ? Platform.Windows64 : Platform.Windows32;
        }
        if (os.contains("linux") || os.contains("freebsd") || os.contains("sunos")) {
            return is64 ? Platform.Linux64 : Platform.Linux32;
        }
        if (os.contains("mac os x") || os.contains("darwin")) {
            if (arch.startsWith("ppc")) {
                return is64 ? Platform.MacOSX_PPC64 : Platform.MacOSX_PPC32;
            }
            return is64 ? Platform.MacOSX64 : Platform.MacOSX32;
        }
        throw new UnsupportedOperationException("The specified platform: " + os + " is not supported.");
    }

    private static JmeContext newContextLwjgl(AppSettings settings, JmeContext.Type type) {
        try {
            Class<?> ctxClazz = null;
            switch (type) {
                case Canvas: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglCanvas");
                    break;
                }
                case Display: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglDisplay");
                    break;
                }
                case OffscreenSurface: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglOffscreenBuffer");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported context type " + (Object)((Object)type));
                }
            }
            return (JmeContext)ctxClazz.newInstance();
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!\nMake sure jme3_lwjgl-ogl is on the classpath.", ex);
        }
        return null;
    }

    private static JmeContext newContextJogl(AppSettings settings, JmeContext.Type type) {
        try {
            Class<?> ctxClazz = null;
            switch (type) {
                case Display: {
                    ctxClazz = Class.forName("com.jme3.system.jogl.JoglDisplay");
                    break;
                }
                case Canvas: {
                    ctxClazz = Class.forName("com.jme3.system.jogl.JoglCanvas");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported context type " + (Object)((Object)type));
                }
            }
            return (JmeContext)ctxClazz.newInstance();
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!\nMake sure jme3_jogl is on the classpath.", ex);
        }
        return null;
    }

    private static JmeContext newContextCustom(AppSettings settings, JmeContext.Type type) {
        try {
            String className = settings.getRenderer().substring("CUSTOM".length());
            Class<?> ctxClazz = null;
            ctxClazz = Class.forName(className);
            return (JmeContext)ctxClazz.newInstance();
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!", ex);
        }
        return null;
    }

    public static JmeContext newContext(AppSettings settings, JmeContext.Type contextType) {
        JmeContext ctx;
        JmeSystem.initialize(settings);
        if (settings.getRenderer() == null || settings.getRenderer().equals("NULL") || contextType == JmeContext.Type.Headless) {
            ctx = new NullContext();
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("LWJGL")) {
            ctx = JmeSystem.newContextLwjgl(settings, contextType);
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("JOGL")) {
            ctx = JmeSystem.newContextJogl(settings, contextType);
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("CUSTOM")) {
            ctx = JmeSystem.newContextCustom(settings, contextType);
            ctx.setSettings(settings);
        } else {
            throw new UnsupportedOperationException("Unrecognizable renderer specified: " + settings.getRenderer());
        }
        return ctx;
    }

    public static AudioRenderer newAudioRenderer(AppSettings settings) {
        JmeSystem.initialize(settings);
        Class<?> clazz = null;
        try {
            if (settings.getAudioRenderer().startsWith("LWJGL")) {
                clazz = Class.forName("com.jme3.audio.lwjgl.LwjglAudioRenderer");
            } else if (settings.getAudioRenderer().startsWith("JOAL")) {
                clazz = Class.forName("com.jme3.audio.joal.JoalAudioRenderer");
            } else {
                throw new UnsupportedOperationException("Unrecognizable audio renderer specified: " + settings.getAudioRenderer());
            }
            AudioRenderer ar = (AudioRenderer)clazz.newInstance();
            return ar;
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, "CRITICAL ERROR: Audio implementation class is missing!\nMake sure jme3_lwjgl-oal or jm3_joal is on the classpath.", ex);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initialize(AppSettings settings) {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            if (lowPermissions) {
                // empty if block
            }
        }
        catch (SecurityException ex) {
            logger.log(Level.SEVERE, "Security error in creating log file", ex);
        }
        logger.log(Level.INFO, "Running on {0}", JmeSystem.getFullName());
        if (lowPermissions) return;
        try {
            Natives.extractNativeLibs(JmeSystem.getPlatform(), settings);
            return;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error while copying native libraries", ex);
        }
    }
}

