/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class TextureGeneratorBlend
extends TextureGenerator {
    private static final IntensityFunction[] INTENSITY_FUNCTION = new IntensityFunction[7];

    public TextureGeneratorBlend(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, BlenderContext blenderContext) {
        int flag = ((Number)tex.getFieldValue("flag")).intValue();
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        TexturePixel texres = new TexturePixel();
        int halfW = width >> 1;
        int halfH = height >> 1;
        int halfD = depth >> 1;
        int index = 0;
        float wDelta = 1.0f / (float)halfW;
        float hDelta = 1.0f / (float)halfH;
        float dDelta = 1.0f / (float)halfD;
        float[][] colorBand = this.computeColorband(tex, blenderContext);
        TextureGenerator.BrightnessAndContrastData bacd = new TextureGenerator.BrightnessAndContrastData(tex);
        Image.Format format = colorBand != null ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 4 : 1;
        boolean flipped = (flag & 2) != 0;
        byte[] data = new byte[width * height * depth * bytesPerPixel];
        for (int i = -halfW; i < halfW; ++i) {
            float x = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                float y;
                if (flipped) {
                    y = x;
                    x = hDelta * (float)j;
                } else {
                    y = hDelta * (float)j;
                }
                for (int k = -halfD; k < halfD; ++k) {
                    texres.intensity = INTENSITY_FUNCTION[stype].getIntensity(x, y, dDelta * (float)k);
                    if (colorBand != null) {
                        int colorbandIndex = (int)(texres.intensity * 1000.0f);
                        texres.red = colorBand[colorbandIndex][0];
                        texres.green = colorBand[colorbandIndex][1];
                        texres.blue = colorBand[colorbandIndex][2];
                        this.applyBrightnessAndContrast(bacd, texres);
                        data[index++] = (byte)(texres.red * 255.0f);
                        data[index++] = (byte)(texres.green * 255.0f);
                        data[index++] = (byte)(texres.blue * 255.0f);
                        data[index++] = (byte)(colorBand[colorbandIndex][3] * 255.0f);
                        continue;
                    }
                    this.applyBrightnessAndContrast(texres, bacd.contrast, bacd.brightness);
                    data[index++] = (byte)(texres.intensity * 255.0f);
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(BufferUtils.createByteBuffer(data));
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }

    static {
        TextureGeneratorBlend.INTENSITY_FUNCTION[0] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                return (1.0f + x) * 0.5f;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[1] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = (1.0f + x) * 0.5f;
                return result * result;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[2] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = (1.0f + x) * 0.5f;
                if (result <= 0.0f) {
                    return 0.0f;
                }
                if (result >= 1.0f) {
                    return 1.0f;
                }
                return result * result * (3.0f - 2.0f * result);
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[3] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                return (2.0f + x + y) * 0.25f;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[4] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = 1.0f - (float)Math.sqrt(x * x + y * y + z * z);
                return result < 0.0f ? 0.0f : result;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[5] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = 1.0f - (float)Math.sqrt(x * x + y * y + z * z);
                return result <= 0.0f ? 0.0f : result * result;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[6] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                return (float)Math.atan2(y, x) * 0.15915494f + 0.5f;
            }
        };
    }

    private static interface IntensityFunction {
        public float getIntensity(float var1, float var2, float var3);
    }
}

