/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.objects;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class Properties
implements Cloneable,
Savable {
    private static final Logger LOGGER = Logger.getLogger(Properties.class.getName());
    public static final int IDP_STRING = 0;
    public static final int IDP_INT = 1;
    public static final int IDP_FLOAT = 2;
    public static final int IDP_ARRAY = 5;
    public static final int IDP_GROUP = 6;
    public static final int IDP_DOUBLE = 8;
    public static final int IDP_IDPARRAY = 9;
    public static final int IDP_NUMTYPES = 10;
    protected static final String RNA_PROPERTY_NAME = "_RNA_UI";
    protected static final String DEFAULT_NAME = "Unnamed property";
    private String name;
    private int type;
    private int subType;
    private Object value;
    private String description;

    public void load(Structure idPropertyStructure, BlenderContext blenderContext) throws BlenderFileException {
        this.name = idPropertyStructure.getFieldValue("name").toString();
        if (this.name == null || this.name.length() == 0) {
            this.name = DEFAULT_NAME;
        }
        this.subType = ((Number)idPropertyStructure.getFieldValue("subtype")).intValue();
        this.type = ((Number)idPropertyStructure.getFieldValue("type")).intValue();
        Structure data = (Structure)idPropertyStructure.getFieldValue("data");
        int len = ((Number)idPropertyStructure.getFieldValue("len")).intValue();
        switch (this.type) {
            case 0: {
                Pointer pointer = (Pointer)data.getFieldValue("pointer");
                BlenderInputStream bis = blenderContext.getInputStream();
                FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pointer.getOldMemoryAddress());
                bis.setPosition(dataFileBlock.getBlockPosition());
                this.value = bis.readString();
                break;
            }
            case 1: {
                int intValue = ((Number)data.getFieldValue("val")).intValue();
                this.value = intValue;
                break;
            }
            case 2: {
                int floatValue = ((Number)data.getFieldValue("val")).intValue();
                this.value = Float.valueOf(Float.intBitsToFloat(floatValue));
                break;
            }
            case 5: {
                Pointer pointer = (Pointer)data.getFieldValue("pointer");
                BlenderInputStream bis = blenderContext.getInputStream();
                FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pointer.getOldMemoryAddress());
                bis.setPosition(dataFileBlock.getBlockPosition());
                int elementAmount = dataFileBlock.getSize();
                switch (this.subType) {
                    case 1: {
                        int[] intList = new int[elementAmount /= 4];
                        for (int i = 0; i < elementAmount; ++i) {
                            intList[i] = bis.readInt();
                        }
                        this.value = intList;
                        break;
                    }
                    case 2: {
                        float[] floatList = new float[elementAmount /= 4];
                        for (int i = 0; i < elementAmount; ++i) {
                            floatList[i] = bis.readFloat();
                        }
                        this.value = floatList;
                        break;
                    }
                    case 8: {
                        double[] doubleList = new double[elementAmount /= 8];
                        for (int i = 0; i < elementAmount; ++i) {
                            doubleList[i] = bis.readDouble();
                        }
                        this.value = doubleList;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid array subtype: " + this.subType);
                    }
                }
            }
            case 6: {
                Structure group = (Structure)data.getFieldValue("group");
                List<Structure> dataList = group.evaluateListBase(blenderContext);
                ArrayList<Properties> subProperties = new ArrayList<Properties>(len);
                for (Structure d : dataList) {
                    Properties properties = new Properties();
                    properties.load(d, blenderContext);
                    subProperties.add(properties);
                }
                this.value = subProperties;
                break;
            }
            case 8: {
                int doublePart1 = ((Number)data.getFieldValue("val")).intValue();
                int doublePart2 = ((Number)data.getFieldValue("val2")).intValue();
                long doubleVal = (long)doublePart2 << 32 | (long)doublePart1;
                this.value = Double.longBitsToDouble(doubleVal);
                break;
            }
            case 9: {
                Pointer pointer = (Pointer)data.getFieldValue("pointer");
                List<Structure> arrays = pointer.fetchData(blenderContext.getInputStream());
                ArrayList<Object> result = new ArrayList<Object>(arrays.size());
                Properties temp = new Properties();
                for (Structure array : arrays) {
                    temp.load(array, blenderContext);
                    result.add(temp.value);
                }
                this.value = result;
                break;
            }
            case 10: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException("Unknown custom property type: " + this.type);
            }
        }
        this.completeLoading();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Object findValue(String propertyName) {
        if (this.name.equals(propertyName)) {
            return this.value;
        }
        if (this.type == 6) {
            List props = (List)this.value;
            for (Properties p : props) {
                Object v = p.findValue(propertyName);
                if (v == null) continue;
                return v;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, new StringBuilder());
        return sb.toString();
    }

    private void append(StringBuilder sb, StringBuilder indent) {
        sb.append((CharSequence)indent).append("name: ").append(this.name).append("\n\r");
        sb.append((CharSequence)indent).append("type: ").append(this.type).append("\n\r");
        sb.append((CharSequence)indent).append("subType: ").append(this.subType).append("\n\r");
        sb.append((CharSequence)indent).append("description: ").append(this.description).append("\n\r");
        indent.append('\t');
        sb.append((CharSequence)indent).append("value: ");
        if (this.value instanceof Properties) {
            ((Properties)this.value).append(sb, indent);
        } else if (this.value instanceof List) {
            for (Object v : (List)this.value) {
                if (v instanceof Properties) {
                    sb.append((CharSequence)indent).append("{\n\r");
                    indent.append('\t');
                    ((Properties)v).append(sb, indent);
                    indent.deleteCharAt(indent.length() - 1);
                    sb.append((CharSequence)indent).append("}\n\r");
                    continue;
                }
                sb.append(v);
            }
        } else {
            sb.append(this.value);
        }
        sb.append("\n\r");
        indent.deleteCharAt(indent.length() - 1);
    }

    protected void completeLoading() {
        if (this.type == 6) {
            List groupProperties = (List)this.value;
            Properties rnaUI = null;
            for (Properties properties : groupProperties) {
                if (!properties.name.equals(RNA_PROPERTY_NAME) || properties.type != 6) continue;
                rnaUI = properties;
                break;
            }
            if (rnaUI != null) {
                groupProperties.remove(rnaUI);
                HashMap<String, String> descriptions = new HashMap<String, String>(groupProperties.size());
                List propertiesRNA = (List)rnaUI.value;
                for (Properties properties : propertiesRNA) {
                    String name = properties.name;
                    String description = null;
                    List rnaData = (List)properties.value;
                    for (Properties rna : rnaData) {
                        if (!"description".equalsIgnoreCase(rna.name)) continue;
                        description = (String)rna.value;
                        break;
                    }
                    descriptions.put(name, description);
                }
                for (Properties properties : groupProperties) {
                    properties.description = (String)descriptions.get(properties.name);
                }
            }
        }
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", DEFAULT_NAME);
        oc.write(this.type, "type", 0);
        oc.write(this.subType, "subtype", 0);
        oc.write(this.description, "description", null);
        switch (this.type) {
            case 0: {
                oc.write((String)this.value, "value", null);
                break;
            }
            case 1: {
                oc.write((Integer)this.value, "value", 0);
                break;
            }
            case 2: {
                oc.write(((Float)this.value).floatValue(), "value", 0.0f);
                break;
            }
            case 5: {
                switch (this.subType) {
                    case 1: {
                        oc.write((int[])this.value, "value", (int[])null);
                        break;
                    }
                    case 2: {
                        oc.write((float[])this.value, "value", (float[])null);
                        break;
                    }
                    case 8: {
                        oc.write((double[])this.value, "value", null);
                        break;
                    }
                    default: {
                        LOGGER.warning("Cannot save the property's value! Invalid array subtype! Property: name: " + this.name + "; subtype: " + this.subType);
                    }
                }
            }
            case 6: {
                oc.writeSavableArrayList((ArrayList)this.value, "value", null);
                break;
            }
            case 8: {
                oc.write((Double)this.value, "value", 0.0);
                break;
            }
            case 9: {
                oc.writeSavableArrayList((ArrayList)this.value, "value", null);
                break;
            }
            case 10: {
                LOGGER.warning("Numtypes value not supported! Cannot write it!");
                break;
            }
            default: {
                LOGGER.warning("Cannot save the property's value! Invalid type! Property: name: " + this.name + "; type: " + this.type);
            }
        }
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", DEFAULT_NAME);
        this.type = ic.readInt("type", 0);
        this.subType = ic.readInt("subtype", 0);
        this.description = ic.readString("description", null);
        switch (this.type) {
            case 0: {
                this.value = ic.readString("value", null);
                break;
            }
            case 1: {
                this.value = ic.readInt("value", 0);
                break;
            }
            case 2: {
                this.value = Float.valueOf(ic.readFloat("value", 0.0f));
                break;
            }
            case 5: {
                switch (this.subType) {
                    case 1: {
                        this.value = ic.readIntArray("value", null);
                        break;
                    }
                    case 2: {
                        this.value = ic.readFloatArray("value", null);
                        break;
                    }
                    case 8: {
                        this.value = ic.readDoubleArray("value", null);
                        break;
                    }
                    default: {
                        LOGGER.warning("Cannot read the property's value! Invalid array subtype! Property: name: " + this.name + "; subtype: " + this.subType);
                    }
                }
            }
            case 6: {
                this.value = ic.readSavable("value", null);
                break;
            }
            case 8: {
                this.value = ic.readDouble("value", 0.0);
                break;
            }
            case 9: {
                this.value = ic.readSavableArrayList("value", null);
                break;
            }
            case 10: {
                LOGGER.warning("Numtypes value not supported! Cannot read it!");
                break;
            }
            default: {
                LOGGER.warning("Cannot read the property's value! Invalid type! Property: name: " + this.name + "; type: " + this.type);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.subType;
        result = 31 * result + this.type;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.subType != other.subType) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

