/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshContext;
import com.jme3.scene.plugins.blender.objects.Properties;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshHelper
extends AbstractBlenderHelper {
    public MeshHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public List<Geometry> toMesh(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        ArrayList<Geometry> geometries = (ArrayList<Geometry>)blenderContext.getLoadedFeature(structure.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (geometries != null) {
            ArrayList<Geometry> copiedGeometries = new ArrayList<Geometry>(geometries.size());
            for (Geometry geometry : geometries) {
                copiedGeometries.add(geometry.clone());
            }
            return copiedGeometries;
        }
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        String name = structure.getName();
        MeshContext meshContext = new MeshContext();
        Vector3f[] vertices = this.getVertices(structure, blenderContext);
        int verticesAmount = vertices.length;
        List<float[]> verticesColors = this.getVerticesColors(structure, blenderContext);
        HashMap meshesMap = new HashMap();
        Pointer pMFace = (Pointer)structure.getFieldValue("mface");
        List<Structure> mFaces = null;
        if (pMFace.isNotNull()) {
            mFaces = pMFace.fetchData(blenderContext.getInputStream());
            if (mFaces == null || mFaces.size() == 0) {
                return new ArrayList<Geometry>(0);
            }
        } else {
            mFaces = new ArrayList<Structure>(0);
        }
        Pointer pMTFace = (Pointer)structure.getFieldValue("mtface");
        ArrayList<Vector2f> uvCoordinates = null;
        List<Structure> mtFaces = null;
        if (pMTFace.isNotNull()) {
            mtFaces = pMTFace.fetchData(blenderContext.getInputStream());
            int facesAmount = ((Number)structure.getFieldValue("totface")).intValue();
            if (mtFaces.size() != facesAmount) {
                throw new BlenderFileException("The amount of faces uv coordinates is not equal to faces amount!");
            }
            uvCoordinates = new ArrayList<Vector2f>();
        }
        HashMap<Vector3f, Vector3f> normalMap = new HashMap<Vector3f, Vector3f>(verticesAmount);
        ArrayList normalList = new ArrayList();
        ArrayList<Vector3f> vertexList = new ArrayList<Vector3f>();
        HashMap<Integer, Texture> materialNumberToTexture = new HashMap<Integer, Texture>();
        HashMap<Integer, List<Integer>> vertexReferenceMap = new HashMap<Integer, List<Integer>>(verticesAmount);
        int vertexColorIndex = 0;
        for (int i = 0; i < mFaces.size(); ++i) {
            Texture texture;
            Structure mFace = mFaces.get(i);
            boolean smooth = (((Number)mFace.getFieldValue("flag")).byteValue() & 1) != 0;
            DynamicArray uvs = null;
            boolean materialWithoutTextures = false;
            Pointer pImage = null;
            if (mtFaces != null) {
                Structure mtFace = mtFaces.get(i);
                pImage = (Pointer)mtFace.getFieldValue("tpage");
                materialWithoutTextures = pImage.isNull();
                uvs = (DynamicArray)mtFace.getFieldValue("uv");
                uvCoordinates.add(new Vector2f(((Number)uvs.get(0, 0)).floatValue(), ((Number)uvs.get(0, 1)).floatValue()));
                uvCoordinates.add(new Vector2f(((Number)uvs.get(1, 0)).floatValue(), ((Number)uvs.get(1, 1)).floatValue()));
                uvCoordinates.add(new Vector2f(((Number)uvs.get(2, 0)).floatValue(), ((Number)uvs.get(2, 1)).floatValue()));
            }
            int matNr = ((Number)mFace.getFieldValue("mat_nr")).intValue();
            Integer materialNumber = materialWithoutTextures ? -1 * matNr - 1 : matNr;
            ArrayList<Integer> indexList = (ArrayList<Integer>)meshesMap.get(materialNumber);
            if (indexList == null) {
                indexList = new ArrayList<Integer>();
                meshesMap.put(materialNumber, indexList);
            }
            if (pImage != null && pImage.isNotNull() && !materialNumberToTexture.containsKey(materialNumber) && (texture = textureHelper.getTextureFromImage(pImage.fetchData(blenderContext.getInputStream()).get(0), blenderContext)) != null) {
                materialNumberToTexture.put(materialNumber, texture);
            }
            int v1 = ((Number)mFace.getFieldValue("v1")).intValue();
            int v2 = ((Number)mFace.getFieldValue("v2")).intValue();
            int v3 = ((Number)mFace.getFieldValue("v3")).intValue();
            int v4 = ((Number)mFace.getFieldValue("v4")).intValue();
            Vector3f n = FastMath.computeNormal(vertices[v1], vertices[v2], vertices[v3]);
            this.addNormal(n, normalMap, smooth, vertices[v1], vertices[v2], vertices[v3]);
            normalList.add(normalMap.get(vertices[v1]));
            normalList.add(normalMap.get(vertices[v2]));
            normalList.add(normalMap.get(vertices[v3]));
            this.appendVertexReference(v1, vertexList.size(), vertexReferenceMap);
            indexList.add(vertexList.size());
            vertexList.add(vertices[v1]);
            this.appendVertexReference(v2, vertexList.size(), vertexReferenceMap);
            indexList.add(vertexList.size());
            vertexList.add(vertices[v2]);
            this.appendVertexReference(v3, vertexList.size(), vertexReferenceMap);
            indexList.add(vertexList.size());
            vertexList.add(vertices[v3]);
            if (v4 > 0) {
                if (uvs != null) {
                    uvCoordinates.add(new Vector2f(((Number)uvs.get(0, 0)).floatValue(), ((Number)uvs.get(0, 1)).floatValue()));
                    uvCoordinates.add(new Vector2f(((Number)uvs.get(2, 0)).floatValue(), ((Number)uvs.get(2, 1)).floatValue()));
                    uvCoordinates.add(new Vector2f(((Number)uvs.get(3, 0)).floatValue(), ((Number)uvs.get(3, 1)).floatValue()));
                }
                this.appendVertexReference(v1, vertexList.size(), vertexReferenceMap);
                indexList.add(vertexList.size());
                vertexList.add(vertices[v1]);
                this.appendVertexReference(v3, vertexList.size(), vertexReferenceMap);
                indexList.add(vertexList.size());
                vertexList.add(vertices[v3]);
                this.appendVertexReference(v4, vertexList.size(), vertexReferenceMap);
                indexList.add(vertexList.size());
                vertexList.add(vertices[v4]);
                this.addNormal(n, normalMap, smooth, vertices[v4]);
                normalList.add(normalMap.get(vertices[v1]));
                normalList.add(normalMap.get(vertices[v3]));
                normalList.add(normalMap.get(vertices[v4]));
                if (verticesColors != null) {
                    verticesColors.add(vertexColorIndex + 3, verticesColors.get(vertexColorIndex));
                    verticesColors.add(vertexColorIndex + 4, verticesColors.get(vertexColorIndex + 2));
                }
                vertexColorIndex += 6;
                continue;
            }
            if (verticesColors == null) continue;
            verticesColors.remove(vertexColorIndex + 3);
            vertexColorIndex += 3;
        }
        meshContext.setVertexList(vertexList);
        meshContext.setVertexReferenceMap(vertexReferenceMap);
        Vector3f[] normals = normalList.toArray(new Vector3f[normalList.size()]);
        Structure parent = blenderContext.peekParent();
        Structure defbase = (Structure)parent.getFieldValue("defbase");
        List<Structure> defs = defbase.evaluateListBase(blenderContext);
        String[] verticesGroups = new String[defs.size()];
        int defIndex = 0;
        for (Structure def : defs) {
            verticesGroups[defIndex++] = def.getFieldValue("name").toString();
        }
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        Material[] materials = null;
        Material[] nonTexturedMaterials = null;
        if ((blenderContext.getBlenderKey().getFeaturesToLoad() & 3) != 0) {
            materials = materialHelper.getMaterials(structure, blenderContext);
            nonTexturedMaterials = materials == null ? null : new Material[materials.length];
        }
        geometries = new ArrayList<Geometry>(meshesMap.size());
        VertexBuffer verticesBuffer = new VertexBuffer(VertexBuffer.Type.Position);
        verticesBuffer.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(vertexList.toArray(new Vector3f[vertexList.size()])));
        VertexBuffer verticesBind = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
        verticesBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone(verticesBuffer.getData()));
        VertexBuffer normalsBuffer = new VertexBuffer(VertexBuffer.Type.Normal);
        normalsBuffer.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(normals));
        VertexBuffer normalsBind = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
        normalsBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone(normalsBuffer.getData()));
        VertexBuffer uvCoordsBuffer = null;
        if (uvCoordinates != null) {
            uvCoordsBuffer = new VertexBuffer(VertexBuffer.Type.TexCoord);
            uvCoordsBuffer.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(uvCoordinates.toArray(new Vector2f[uvCoordinates.size()])));
        }
        Properties properties = this.loadProperties(structure, blenderContext);
        FloatBuffer verticesColorsBuffer = this.createFloatBuffer(verticesColors);
        for (Map.Entry meshEntry : meshesMap.entrySet()) {
            Mesh mesh = new Mesh();
            List indexList = (List)meshEntry.getValue();
            int[] indices = new int[indexList.size()];
            for (int i = 0; i < indexList.size(); ++i) {
                indices[i] = (Integer)indexList.get(i);
            }
            mesh.setBuffer(VertexBuffer.Type.Index, 1, indices);
            mesh.setBuffer(verticesBuffer);
            mesh.setBuffer(verticesBind);
            if (verticesColorsBuffer != null) {
                mesh.setBuffer(VertexBuffer.Type.Color, 4, verticesColorsBuffer);
            }
            mesh.setBuffer(normalsBuffer);
            mesh.setBuffer(normalsBind);
            Geometry geometry = new Geometry(name + (geometries.size() + 1), mesh);
            if (materials != null) {
                Material material;
                int materialNumber = (Integer)meshEntry.getKey();
                if (materialNumber >= 0) {
                    material = materials[materialNumber];
                    if (materialNumberToTexture.containsKey(materialNumber)) {
                        if (material.getMaterialDef().getAssetName().contains("Lighting")) {
                            if (!materialHelper.hasTexture(material, "DiffuseMap")) {
                                material = material.clone();
                                material.setTexture("DiffuseMap", (Texture)materialNumberToTexture.get(materialNumber));
                            }
                        } else if (!materialHelper.hasTexture(material, "ColorMap")) {
                            material = material.clone();
                            material.setTexture("ColorMap", (Texture)materialNumberToTexture.get(materialNumber));
                        }
                    }
                } else {
                    if (nonTexturedMaterials[materialNumber = -1 * (materialNumber + 1)] == null) {
                        nonTexturedMaterials[materialNumber] = materialHelper.getNonTexturedMaterial(materials[materialNumber], 8);
                    }
                    material = nonTexturedMaterials[materialNumber];
                }
                geometry.setMaterial(material);
                if (material.isTransparent()) {
                    geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
                }
            } else {
                geometry.setMaterial(blenderContext.getDefaultMaterial());
            }
            if (properties != null && properties.getValue() != null) {
                geometry.setUserData("properties", properties);
            }
            geometries.add(geometry);
        }
        if (uvCoordsBuffer != null) {
            for (Geometry geom : geometries) {
                geom.getMesh().setBuffer(uvCoordsBuffer);
            }
        } else {
            HashMap<Material, ArrayList<Geometry>> materialMap = new HashMap<Material, ArrayList<Geometry>>();
            for (Geometry geometry : geometries) {
                Material material = geometry.getMaterial();
                ArrayList<Geometry> geomsWithCommonMaterial = (ArrayList<Geometry>)materialMap.get(material);
                if (geomsWithCommonMaterial == null) {
                    geomsWithCommonMaterial = new ArrayList<Geometry>();
                    materialMap.put(material, geomsWithCommonMaterial);
                }
                geomsWithCommonMaterial.add(geometry);
            }
            for (Map.Entry entry : materialMap.entrySet()) {
                MaterialContext materialContext = blenderContext.getMaterialContext((Material)entry.getKey());
                if (materialContext == null || materialContext.getTexturesCount() <= 0) continue;
                VertexBuffer coords = UVCoordinatesGenerator.generateUVCoordinates(materialContext.getUvCoordinatesType(), materialContext.getProjectionType(), materialContext.getTextureDimension(), materialContext.getProjection(0), (List)entry.getValue());
                for (Geometry geometry : (List)entry.getValue()) {
                    meshContext.addUVCoordinates(geometry, coords);
                }
            }
        }
        blenderContext.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, geometries);
        blenderContext.setMeshContext(structure.getOldMemoryAddress(), meshContext);
        return geometries;
    }

    public void addNormal(Vector3f normalToAdd, Map<Vector3f, Vector3f> normalMap, boolean smooth, Vector3f ... vertices) {
        for (Vector3f v : vertices) {
            Vector3f n = normalMap.get(v);
            if (!smooth || n == null) {
                normalMap.put(v, normalToAdd.clone());
                continue;
            }
            n.addLocal(normalToAdd).normalizeLocal();
        }
    }

    protected void appendVertexReference(int basicVertexIndex, int resultIndex, Map<Integer, List<Integer>> vertexReferenceMap) {
        List<Integer> referenceList = vertexReferenceMap.get(basicVertexIndex);
        if (referenceList == null) {
            referenceList = new ArrayList<Integer>();
            vertexReferenceMap.put(basicVertexIndex, referenceList);
        }
        referenceList.add(resultIndex);
    }

    public List<float[]> getVerticesColors(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pMCol = (Pointer)meshStructure.getFieldValue("mcol");
        LinkedList<float[]> verticesColors = null;
        List<Structure> mCol = null;
        if (pMCol.isNotNull()) {
            verticesColors = new LinkedList<float[]>();
            mCol = pMCol.fetchData(blenderContext.getInputStream());
            for (Structure color : mCol) {
                float r = (float)((Number)color.getFieldValue("r")).byteValue() / 256.0f;
                float g = (float)((Number)color.getFieldValue("g")).byteValue() / 256.0f;
                float b = (float)((Number)color.getFieldValue("b")).byteValue() / 256.0f;
                float a = (float)((Number)color.getFieldValue("a")).byteValue() / 256.0f;
                verticesColors.add(new float[]{b, g, r, a});
            }
        }
        return verticesColors;
    }

    public Vector3f[] getVertices(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        int verticesAmount = ((Number)meshStructure.getFieldValue("totvert")).intValue();
        Vector3f[] vertices = new Vector3f[verticesAmount];
        if (verticesAmount == 0) {
            return vertices;
        }
        Pointer pMVert = (Pointer)meshStructure.getFieldValue("mvert");
        List<Structure> mVerts = pMVert.fetchData(blenderContext.getInputStream());
        for (int i = 0; i < verticesAmount; ++i) {
            DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
            vertices[i] = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(1)).floatValue(), ((Number)coordinates.get(2)).floatValue());
        }
        return vertices;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

