/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.materials;

import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MaterialContext {
    private static final Logger LOGGER = Logger.getLogger(MaterialContext.class.getName());
    public static final int MTEX_COL = 1;
    public static final int MTEX_NOR = 2;
    public static final int MTEX_SPEC = 4;
    public static final int MTEX_EMIT = 64;
    public static final int MTEX_ALPHA = 128;
    final String name;
    final List<Structure> mTexs;
    final List<Structure> textures;
    final Map<Number, Texture> loadedTextures;
    final Map<Texture, Structure> textureToMTexMap;
    final int texturesCount;
    final Texture.Type textureType;
    final ColorRGBA diffuseColor;
    final MaterialHelper.DiffuseShader diffuseShader;
    final MaterialHelper.SpecularShader specularShader;
    final ColorRGBA specularColor;
    final ColorRGBA ambientColor;
    final float shininess;
    final boolean shadeless;
    final boolean vertexColor;
    final boolean transparent;
    final boolean vTangent;
    int uvCoordinatesType = -1;
    int projectionType;

    MaterialContext(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        this.name = structure.getName();
        int mode = ((Number)structure.getFieldValue("mode")).intValue();
        this.shadeless = (mode & 4) != 0;
        this.vertexColor = (mode & 0x80) != 0;
        this.transparent = (mode & 0x10000) != 0;
        this.vTangent = (mode & 0x4000000) != 0;
        int diff_shader = ((Number)structure.getFieldValue("diff_shader")).intValue();
        this.diffuseShader = MaterialHelper.DiffuseShader.values()[diff_shader];
        if (this.shadeless) {
            this.diffuseColor = ColorRGBA.White.clone();
            this.specularShader = null;
            this.ambientColor = null;
            this.specularColor = null;
            this.shininess = 0.0f;
        } else {
            this.diffuseColor = this.readDiffuseColor(structure, this.diffuseShader);
            int spec_shader = ((Number)structure.getFieldValue("spec_shader")).intValue();
            this.specularShader = MaterialHelper.SpecularShader.values()[spec_shader];
            this.specularColor = this.readSpecularColor(structure, this.specularShader);
            float r = ((Number)structure.getFieldValue("ambr")).floatValue();
            float g = ((Number)structure.getFieldValue("ambg")).floatValue();
            float b = ((Number)structure.getFieldValue("ambb")).floatValue();
            float alpha = ((Number)structure.getFieldValue("alpha")).floatValue();
            this.ambientColor = new ColorRGBA(r, g, b, alpha);
            float shininess = ((Number)structure.getFieldValue("emit")).floatValue();
            this.shininess = shininess > 0.0f ? shininess : 20.0f;
        }
        float[] diffuseColorArray = new float[]{this.diffuseColor.r, this.diffuseColor.g, this.diffuseColor.b, this.diffuseColor.a};
        this.mTexs = new ArrayList<Structure>();
        this.textures = new ArrayList<Structure>();
        DynamicArray mtexsArray = (DynamicArray)structure.getFieldValue("mtex");
        int separatedTextures = ((Number)structure.getFieldValue("septex")).intValue();
        Texture.Type firstTextureType = null;
        for (int i = 0; i < mtexsArray.getTotalSize(); ++i) {
            Structure tex;
            int type;
            Texture.Type textureType;
            Pointer p = (Pointer)mtexsArray.get(i);
            if (!p.isNotNull() || (separatedTextures & 1 << i) != 0) continue;
            Structure mtex = p.fetchData(blenderContext.getInputStream()).get(0);
            if (this.uvCoordinatesType == -1) {
                this.uvCoordinatesType = ((Number)mtex.getFieldValue("texco")).intValue();
                this.projectionType = ((Number)mtex.getFieldValue("mapping")).intValue();
            } else if (this.uvCoordinatesType != ((Number)mtex.getFieldValue("texco")).intValue()) {
                LOGGER.log(Level.WARNING, "The texture with index: {0} has different UV coordinates type than the first texture! This texture will NOT be loaded!", i + 1);
                continue;
            }
            Pointer pTex = (Pointer)mtex.getFieldValue("tex");
            if (!pTex.isNotNull() || (textureType = this.getType(type = ((Number)(tex = pTex.fetchData(blenderContext.getInputStream()).get(0)).getFieldValue("type")).intValue())) == null) continue;
            if (firstTextureType == null) {
                firstTextureType = textureType;
                this.mTexs.add(mtex);
                this.textures.add(tex);
                continue;
            }
            if (firstTextureType == textureType) {
                this.mTexs.add(mtex);
                this.textures.add(tex);
                continue;
            }
            LOGGER.log(Level.WARNING, "The texture with index: {0} is of different dimension than the first one! This texture will NOT be loaded!", i + 1);
        }
        Map<Number, List<Structure[]>> sortedTextures = this.sortAndFilterTextures();
        this.loadedTextures = new HashMap<Number, Texture>(sortedTextures.size());
        this.textureToMTexMap = new HashMap<Texture, Structure>();
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        for (Map.Entry<Number, List<Structure[]>> entry : sortedTextures.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            ArrayList<Texture> textures = new ArrayList<Texture>(entry.getValue().size());
            for (Structure[] mtexAndTex : entry.getValue()) {
                int texflag = ((Number)mtexAndTex[0].getFieldValue("texflag")).intValue();
                boolean negateTexture = (texflag & 4) != 0;
                Texture texture = textureHelper.getTexture(mtexAndTex[1], blenderContext);
                int blendType = ((Number)mtexAndTex[0].getFieldValue("blendtype")).intValue();
                float[] color = new float[]{((Number)mtexAndTex[0].getFieldValue("r")).floatValue(), ((Number)mtexAndTex[0].getFieldValue("g")).floatValue(), ((Number)mtexAndTex[0].getFieldValue("b")).floatValue()};
                float colfac = ((Number)mtexAndTex[0].getFieldValue("colfac")).floatValue();
                texture = textureHelper.blendTexture(diffuseColorArray, texture, color, colfac, blendType, negateTexture, blenderContext);
                texture.setWrap(Texture.WrapMode.Repeat);
                textures.add(texture);
                this.textureToMTexMap.put(texture, mtexAndTex[0]);
            }
            this.loadedTextures.put(entry.getKey(), textureHelper.mergeTextures(textures, this));
        }
        this.texturesCount = this.mTexs.size();
        this.textureType = firstTextureType;
    }

    private Map<Number, List<Structure[]>> sortAndFilterTextures() {
        HashMap<Number, List<Structure[]>> result = new HashMap<Number, List<Structure[]>>();
        for (int i = 0; i < this.mTexs.size(); ++i) {
            Structure mTex = this.mTexs.get(i);
            Structure texture = this.textures.get(i);
            Number mapto = (Number)mTex.getFieldValue("mapto");
            ArrayList<Structure[]> mtexs = (ArrayList<Structure[]>)result.get(mapto);
            if (mtexs == null) {
                mtexs = new ArrayList<Structure[]>();
                result.put(mapto, mtexs);
            }
            if (mapto.intValue() == 1 && this.isWithoutAlpha(this.textures.get(i))) {
                mtexs.clear();
            }
            mtexs.add(new Structure[]{mTex, texture});
        }
        return result;
    }

    private boolean isWithoutAlpha(Structure texture) {
        int flag = ((Number)texture.getFieldValue("flag")).intValue();
        if ((flag & 1) == 0) {
            int type = ((Number)texture.getFieldValue("type")).intValue();
            if (type == 4) {
                return true;
            }
            if (type == 12) {
                int voronoiColorType = ((Number)texture.getFieldValue("vn_coltype")).intValue();
                return voronoiColorType != 0;
            }
            if (type == 1) {
                int sType = ((Number)texture.getFieldValue("stype")).intValue();
                return sType == 1;
            }
        }
        return false;
    }

    public int getUvCoordinatesType() {
        return this.uvCoordinatesType;
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public int getTextureDimension() {
        return this.textureType == Texture.Type.TwoDimensional ? 2 : 3;
    }

    public int getTexturesCount() {
        return this.textures == null ? 0 : this.textures.size();
    }

    public int[] getProjection(int textureIndex) {
        Structure mtex = this.mTexs.get(textureIndex);
        return new int[]{((Number)mtex.getFieldValue("projx")).intValue(), ((Number)mtex.getFieldValue("projy")).intValue(), ((Number)mtex.getFieldValue("projz")).intValue()};
    }

    private ColorRGBA readDiffuseColor(Structure materialStructure, MaterialHelper.DiffuseShader diffuseShader) {
        int commonMapto = ((Number)materialStructure.getFieldValue("mapto")).intValue();
        float r = ((Number)materialStructure.getFieldValue("r")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("g")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("b")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        if ((commonMapto & 1) == 1) {
            return new ColorRGBA(r, g, b, alpha);
        }
        switch (diffuseShader) {
            case FRESNEL: 
            case ORENNAYAR: 
            case TOON: {
                break;
            }
            case MINNAERT: 
            case LAMBERT: {
                float ref = ((Number)materialStructure.getFieldValue("ref")).floatValue();
                r *= ref;
                g *= ref;
                b *= ref;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown diffuse shader type: " + diffuseShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, alpha);
    }

    private ColorRGBA readSpecularColor(Structure materialStructure, MaterialHelper.SpecularShader specularShader) {
        float r = ((Number)materialStructure.getFieldValue("specr")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("specg")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("specb")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        switch (specularShader) {
            case BLINN: 
            case COOKTORRENCE: 
            case TOON: 
            case WARDISO: {
                break;
            }
            case PHONG: {
                float spec = ((Number)materialStructure.getFieldValue("spec")).floatValue();
                r *= spec * 0.5f;
                g *= spec * 0.5f;
                b *= spec * 0.5f;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown specular shader type: " + specularShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, alpha);
    }

    private Texture.Type getType(int texType) {
        switch (texType) {
            case 8: {
                return Texture.Type.TwoDimensional;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                return Texture.Type.ThreeDimensional;
            }
            case 0: {
                return null;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                LOGGER.log(Level.WARNING, "Texture type NOT supported: {0}", texType);
                return null;
            }
        }
        throw new IllegalStateException("Unknown texture type: " + texType);
    }

    public String getName() {
        return this.name;
    }

    public ColorRGBA getDiffuseColor() {
        return this.diffuseColor.clone();
    }

    public MaterialHelper.DiffuseShader getDiffuseShader() {
        return this.diffuseShader;
    }

    public ColorRGBA getSpecularColor() {
        return this.specularColor.clone();
    }

    public MaterialHelper.SpecularShader getSpecularShader() {
        return this.specularShader;
    }

    public ColorRGBA getAmbientColor() {
        return this.ambientColor;
    }

    public float getShininess() {
        return this.shininess;
    }

    public boolean isShadeless() {
        return this.shadeless;
    }

    public boolean isVertexColor() {
        return this.vertexColor;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isvTangent() {
        return this.vTangent;
    }

    public Structure getMTex(Texture texture) {
        return this.textureToMTexMap.get(texture);
    }
}

