/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.asset.AssetManager;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class BlenderInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(BlenderInputStream.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private AssetManager assetManager;
    private int pointerSize;
    private char endianess;
    private String versionNumber;
    protected byte[] cachedBuffer;
    protected int size;
    protected int position;
    protected InputStream inputStream;

    public BlenderInputStream(InputStream inputStream, AssetManager assetManager) throws BlenderFileException {
        this.assetManager = assetManager;
        this.inputStream = inputStream;
        try {
            this.size = inputStream.available();
        }
        catch (IOException e) {
            this.size = 0;
        }
        if (this.size <= 0) {
            this.size = 0x100000;
        }
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        try {
            this.readStreamToCache(bufferedInputStream);
        }
        catch (IOException e) {
            throw new BlenderFileException("Problems occured while caching the file!", e);
        }
        try {
            this.readFileHeader();
        }
        catch (BlenderFileException e) {
            this.decompressFile();
            this.position = 0;
            this.readFileHeader();
        }
    }

    private void readStreamToCache(InputStream inputStream) throws IOException {
        int data = inputStream.read();
        this.cachedBuffer = new byte[this.size];
        this.size = 0;
        while (data != -1) {
            this.cachedBuffer[this.size++] = (byte)data;
            if (this.size >= this.cachedBuffer.length) {
                byte[] newBuffer = new byte[this.cachedBuffer.length + (this.cachedBuffer.length >> 1)];
                System.arraycopy(this.cachedBuffer, 0, newBuffer, 0, this.cachedBuffer.length);
                this.cachedBuffer = newBuffer;
            }
            data = inputStream.read();
        }
    }

    private void decompressFile() {
        GZIPInputStream gis = null;
        try {
            gis = new GZIPInputStream(new ByteArrayInputStream(this.cachedBuffer));
            this.readStreamToCache(gis);
        }
        catch (IOException e) {
            throw new IllegalStateException("IO errors occured where they should NOT! The data is already buffered at this point!", e);
        }
        finally {
            try {
                if (gis != null) {
                    gis.close();
                }
            }
            catch (IOException e) {
                LOGGER.warning(e.getMessage());
            }
        }
    }

    private void readFileHeader() throws BlenderFileException {
        byte[] identifier = new byte[7];
        int bytesRead = this.readBytes(identifier);
        if (bytesRead != 7) {
            throw new BlenderFileException("Error reading header identifier. Only " + bytesRead + " bytes read and there should be 7!");
        }
        String strIdentifier = new String(identifier);
        if (!"BLENDER".equals(strIdentifier)) {
            throw new BlenderFileException("Wrong file identifier: " + strIdentifier + "! Should be 'BLENDER'!");
        }
        char pointerSizeSign = (char)this.readByte();
        if (pointerSizeSign == '-') {
            this.pointerSize = 8;
        } else if (pointerSizeSign == '_') {
            this.pointerSize = 4;
        } else {
            throw new BlenderFileException("Invalid pointer size character! Should be '_' or '-' and there is: " + pointerSizeSign);
        }
        this.endianess = (char)this.readByte();
        if (this.endianess != 'v' && this.endianess != 'V') {
            throw new BlenderFileException("Unknown endianess value! 'v' or 'V' expected and found: " + this.endianess);
        }
        byte[] versionNumber = new byte[3];
        bytesRead = this.readBytes(versionNumber);
        if (bytesRead != 3) {
            throw new BlenderFileException("Error reading version numberr. Only " + bytesRead + " bytes read and there should be 3!");
        }
        this.versionNumber = new String(versionNumber);
    }

    public int read() throws IOException {
        return this.readByte();
    }

    public int readByte() {
        return this.cachedBuffer[this.position++] & 0xFF;
    }

    private int readBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.readByte();
        }
        return bytes.length;
    }

    public int readShort() {
        int part1 = this.readByte();
        int part2 = this.readByte();
        if (this.endianess == 'v') {
            return (part2 << 8) + part1;
        }
        return (part1 << 8) + part2;
    }

    public int readInt() {
        int part1 = this.readByte();
        int part2 = this.readByte();
        int part3 = this.readByte();
        int part4 = this.readByte();
        if (this.endianess == 'v') {
            return (part4 << 24) + (part3 << 16) + (part2 << 8) + part1;
        }
        return (part1 << 24) + (part2 << 16) + (part3 << 8) + part4;
    }

    public float readFloat() {
        int intValue = this.readInt();
        return Float.intBitsToFloat(intValue);
    }

    public long readLong() {
        long part1 = this.readInt();
        long part2 = this.readInt();
        long result = -1L;
        result = this.endianess == 'v' ? part2 << 32 | part1 : part1 << 32 | part2;
        return result;
    }

    public double readDouble() {
        long longValue = this.readLong();
        return Double.longBitsToDouble(longValue);
    }

    public long readPointer() {
        if (this.pointerSize == 4) {
            return this.readInt();
        }
        return this.readLong();
    }

    public String readString() {
        StringBuilder stringBuilder = new StringBuilder();
        int data = this.readByte();
        while (data != 0) {
            stringBuilder.append((char)data);
            data = this.readByte();
        }
        return stringBuilder.toString();
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public void alignPosition(int bytesAmount) {
        if (bytesAmount <= 0) {
            throw new IllegalArgumentException("Alignment byte number shoulf be positivbe!");
        }
        long move = this.position % bytesAmount;
        if (move > 0L) {
            this.position = (int)((long)this.position + ((long)bytesAmount - move));
        }
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

