/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.math.Quaternion;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintRotLimit
extends Constraint {
    private static final int LIMIT_XROT = 1;
    private static final int LIMIT_YROT = 2;
    private static final int LIMIT_ZROT = 4;

    public ConstraintRotLimit(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, blenderContext);
    }

    public void affectAnimation(Animation animation, int targetIndex) {
        BoneTrack track = (BoneTrack)this.getTrack(animation, targetIndex);
        if (track != null) {
            int flag = ((Number)this.data.getFieldValue("flag")).intValue();
            Quaternion[] rotations = track.getRotations();
            int maxFrames = rotations.length;
            for (int frame = 0; frame < maxFrames; ++frame) {
                float difference;
                float[] angles = rotations[frame].toAngles(null);
                float influence = this.ipo.calculateValue(frame);
                if ((flag & 1) != 0) {
                    float xmin = ((Number)this.data.getFieldValue("xmin")).floatValue() * ((float)Math.PI / 180);
                    float xmax = ((Number)this.data.getFieldValue("xmax")).floatValue() * ((float)Math.PI / 180);
                    difference = 0.0f;
                    if (angles[0] < xmin) {
                        difference = (angles[0] - xmin) * influence;
                    } else if (angles[0] > xmax) {
                        difference = (angles[0] - xmax) * influence;
                    }
                    angles[0] = angles[0] - difference;
                }
                if ((flag & 2) != 0) {
                    float ymin = ((Number)this.data.getFieldValue("ymin")).floatValue() * ((float)Math.PI / 180);
                    float ymax = ((Number)this.data.getFieldValue("ymax")).floatValue() * ((float)Math.PI / 180);
                    difference = 0.0f;
                    if (angles[1] < ymin) {
                        difference = (angles[1] - ymin) * influence;
                    } else if (angles[1] > ymax) {
                        difference = (angles[1] - ymax) * influence;
                    }
                    angles[1] = angles[1] - difference;
                }
                if ((flag & 4) != 0) {
                    float zmin = ((Number)this.data.getFieldValue("zmin")).floatValue() * ((float)Math.PI / 180);
                    float zmax = ((Number)this.data.getFieldValue("zmax")).floatValue() * ((float)Math.PI / 180);
                    difference = 0.0f;
                    if (angles[2] < zmin) {
                        difference = (angles[2] - zmin) * influence;
                    } else if (angles[2] > zmax) {
                        difference = (angles[2] - zmax) * influence;
                    }
                    angles[2] = angles[2] - difference;
                }
                rotations[frame].fromAngles(angles);
            }
            track.setKeyframes(track.getTimes(), track.getTranslations(), rotations, track.getScales());
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_ROTLIMIT;
    }
}

