/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintLocLike
extends Constraint {
    private static final int LOCLIKE_X = 1;
    private static final int LOCLIKE_Y = 2;
    private static final int LOCLIKE_Z = 4;
    private static final int LOCLIKE_X_INVERT = 16;
    private static final int LOCLIKE_Y_INVERT = 32;
    private static final int LOCLIKE_Z_INVERT = 64;
    private static final int LOCLIKE_OFFSET = 128;

    public ConstraintLocLike(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, blenderContext);
    }

    public void affectAnimation(Animation animation, int targetIndex) {
        BoneTrack track = (BoneTrack)this.getTrack(animation, targetIndex);
        if (track != null) {
            Vector3f targetLocation = this.getTargetLocation();
            int flag = ((Number)this.data.getFieldValue("flag")).intValue();
            Vector3f[] translations = track.getTranslations();
            int maxFrames = translations.length;
            for (int frame = 0; frame < maxFrames; ++frame) {
                Vector3f offset = Vector3f.ZERO;
                if ((flag & 0x80) != 0) {
                    offset = translations[frame].clone();
                }
                if ((flag & 1) != 0) {
                    translations[frame].x = targetLocation.x;
                    if ((flag & 0x10) != 0) {
                        translations[frame].x = -translations[frame].x;
                    }
                } else if ((flag & 2) != 0) {
                    translations[frame].y = targetLocation.y;
                    if ((flag & 0x20) != 0) {
                        translations[frame].y = -translations[frame].y;
                    }
                } else if ((flag & 4) != 0) {
                    translations[frame].z = targetLocation.z;
                    if ((flag & 0x40) != 0) {
                        translations[frame].z = -translations[frame].z;
                    }
                }
                translations[frame].addLocal(offset);
            }
            track.setKeyframes(track.getTimes(), translations, track.getRotations(), track.getScales());
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_LOCLIKE;
    }
}

