/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintAction;
import com.jme3.scene.plugins.blender.constraints.ConstraintChildOf;
import com.jme3.scene.plugins.blender.constraints.ConstraintClampTo;
import com.jme3.scene.plugins.blender.constraints.ConstraintDistLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintFollowPath;
import com.jme3.scene.plugins.blender.constraints.ConstraintInverseKinematics;
import com.jme3.scene.plugins.blender.constraints.ConstraintLocLike;
import com.jme3.scene.plugins.blender.constraints.ConstraintLocLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintLockTrack;
import com.jme3.scene.plugins.blender.constraints.ConstraintMinMax;
import com.jme3.scene.plugins.blender.constraints.ConstraintNull;
import com.jme3.scene.plugins.blender.constraints.ConstraintPython;
import com.jme3.scene.plugins.blender.constraints.ConstraintRigidBodyJoint;
import com.jme3.scene.plugins.blender.constraints.ConstraintRotLike;
import com.jme3.scene.plugins.blender.constraints.ConstraintRotLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintShrinkWrap;
import com.jme3.scene.plugins.blender.constraints.ConstraintSizeLike;
import com.jme3.scene.plugins.blender.constraints.ConstraintSizeLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintStretchTo;
import com.jme3.scene.plugins.blender.constraints.ConstraintTransform;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

final class ConstraintFactory {
    ConstraintFactory() {
    }

    public static Constraint createConstraint(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        int type = ((Number)constraintStructure.getFieldValue("type")).intValue();
        ConstraintType constraintType = ConstraintType.valueOf(type);
        switch (constraintType) {
            case CONSTRAINT_TYPE_ACTION: {
                return new ConstraintAction(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_CHILDOF: {
                return new ConstraintChildOf(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_CLAMPTO: {
                return new ConstraintClampTo(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_DISTLIMIT: {
                return new ConstraintDistLimit(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_FOLLOWPATH: {
                return new ConstraintFollowPath(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_KINEMATIC: {
                return new ConstraintInverseKinematics(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_LOCKTRACK: {
                return new ConstraintLockTrack(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_LOCLIKE: {
                return new ConstraintLocLike(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_LOCLIMIT: {
                return new ConstraintLocLimit(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_MINMAX: {
                return new ConstraintMinMax(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_NULL: {
                return new ConstraintNull(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_PYTHON: {
                return new ConstraintPython(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_RIGIDBODYJOINT: {
                return new ConstraintRigidBodyJoint(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_ROTLIKE: {
                return new ConstraintRotLike(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_ROTLIMIT: {
                return new ConstraintRotLimit(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_SHRINKWRAP: {
                return new ConstraintShrinkWrap(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_SIZELIKE: {
                return new ConstraintSizeLike(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_SIZELIMIT: {
                return new ConstraintSizeLimit(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_STRETCHTO: {
                return new ConstraintStretchTo(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
            case CONSTRAINT_TYPE_TRANSFORM: {
                return new ConstraintTransform(constraintStructure, boneOMA, influenceIpo, blenderContext);
            }
        }
        throw new IllegalStateException("Unknown constraint type: " + (Object)((Object)constraintType));
    }
}

