/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;

public abstract class Constraint {
    protected final String name;
    protected Long boneOMA = -1L;
    protected final Space ownerSpace;
    protected final Space targetSpace;
    protected final Structure data;
    protected final Ipo ipo;
    protected BlenderContext blenderContext;

    public Constraint(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        this.name = constraintStructure.getFieldValue("name").toString();
        ConstraintType constraintType = ConstraintType.valueOf(((Number)constraintStructure.getFieldValue("type")).intValue());
        if (constraintType != this.getType()) {
            throw new IllegalStateException("Constraint structure does not match its type for constraint: " + this.name);
        }
        Pointer pData = (Pointer)constraintStructure.getFieldValue("data");
        if (!pData.isNotNull()) {
            throw new BlenderFileException("The constraint has no data specified!");
        }
        this.data = pData.fetchData(blenderContext.getInputStream()).get(0);
        this.boneOMA = boneOMA;
        this.ownerSpace = Space.valueOf(((Number)constraintStructure.getFieldValue("ownspace")).byteValue());
        this.targetSpace = Space.valueOf(((Number)constraintStructure.getFieldValue("tarspace")).byteValue());
        this.ipo = influenceIpo;
    }

    public String getName() {
        return this.name;
    }

    public Long getBoneOMA() {
        return this.boneOMA;
    }

    public abstract ConstraintType getType();

    protected Track getTrack(Animation animation, int targetIndex) {
        if (this.boneOMA >= 0L) {
            for (Track track : animation.getTracks()) {
                if (((BoneTrack)track).getTargetBoneIndex() != targetIndex) continue;
                return track;
            }
        } else {
            return animation.getTracks()[0];
        }
        return null;
    }

    protected Object getTarget(BlenderContext.LoadedFeatureDataType loadedFeatureDataType) throws BlenderFileException {
        String subtargetName;
        ObjectHelper objectHelper = (ObjectHelper)this.blenderContext.getHelper(ObjectHelper.class);
        Long targetOMA = ((Pointer)this.data.getFieldValue("tar")).getOldMemoryAddress();
        Structure objectStructure = this.blenderContext.getFileBlock(targetOMA).getStructure(this.blenderContext);
        Object result = objectHelper.toObject(objectStructure, this.blenderContext);
        Object subtarget = this.data.getFieldValue("subtarget");
        String string = subtargetName = subtarget == null ? null : subtarget.toString();
        if (subtargetName != null && subtargetName.length() > 0) {
            result = this.blenderContext.getLoadedFeature(subtargetName, loadedFeatureDataType);
        }
        return result;
    }

    protected Vector3f getTargetLocation() {
        Long targetOMA = ((Pointer)this.data.getFieldValue("tar")).getOldMemoryAddress();
        Node targetObject = (Node)this.blenderContext.getLoadedFeature(targetOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        switch (this.targetSpace) {
            case CONSTRAINT_SPACE_LOCAL: {
                return targetObject.getLocalTranslation();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return targetObject.getWorldTranslation();
            }
        }
        throw new IllegalStateException("Invalid space type for target object: " + this.targetSpace.toString());
    }

    protected Vector3f getTargetLocation(int frame) {
        return this.getTargetLocation();
    }

    protected Quaternion getTargetRotation() {
        Long targetOMA = ((Pointer)this.data.getFieldValue("tar")).getOldMemoryAddress();
        Node targetObject = (Node)this.blenderContext.getLoadedFeature(targetOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        switch (this.targetSpace) {
            case CONSTRAINT_SPACE_LOCAL: {
                return targetObject.getLocalRotation();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return targetObject.getWorldRotation();
            }
        }
        throw new IllegalStateException("Invalid space type for target object: " + this.targetSpace.toString());
    }

    protected Vector3f getTargetScale() {
        Long targetOMA = ((Pointer)this.data.getFieldValue("tar")).getOldMemoryAddress();
        Node targetObject = (Node)this.blenderContext.getLoadedFeature(targetOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        switch (this.targetSpace) {
            case CONSTRAINT_SPACE_LOCAL: {
                return targetObject.getLocalScale();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return targetObject.getWorldScale();
            }
        }
        throw new IllegalStateException("Invalid space type for target object: " + this.targetSpace.toString());
    }

    public abstract void affectAnimation(Animation var1, int var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Space {
        CONSTRAINT_SPACE_WORLD,
        CONSTRAINT_SPACE_LOCAL,
        CONSTRAINT_SPACE_POSE,
        CONSTRAINT_SPACE_PARLOCAL,
        CONSTRAINT_SPACE_INVALID;


        public static Space valueOf(byte c) {
            switch (c) {
                case 0: {
                    return CONSTRAINT_SPACE_WORLD;
                }
                case 1: {
                    return CONSTRAINT_SPACE_LOCAL;
                }
                case 2: {
                    return CONSTRAINT_SPACE_POSE;
                }
                case 3: {
                    return CONSTRAINT_SPACE_PARLOCAL;
                }
            }
            return CONSTRAINT_SPACE_INVALID;
        }
    }
}

