/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Arrays;

public class CalculationBone
extends Node {
    private Bone bone;
    private BoneTrack track;
    private Vector3f startTranslation;
    private Quaternion startRotation;
    private Vector3f startScale;
    private Vector3f[] translations;
    private Quaternion[] rotations;
    private Vector3f[] scales;

    public CalculationBone(Bone bone, int boneFramesCount) {
        this.bone = bone;
        this.startRotation = bone.getModelSpaceRotation().clone();
        this.startTranslation = bone.getModelSpacePosition().clone();
        this.startScale = bone.getModelSpaceScale().clone();
        this.reset();
        if (boneFramesCount > 0) {
            this.translations = new Vector3f[boneFramesCount];
            this.rotations = new Quaternion[boneFramesCount];
            this.scales = new Vector3f[boneFramesCount];
            Arrays.fill(this.translations, 0, boneFramesCount, this.startTranslation);
            Arrays.fill(this.rotations, 0, boneFramesCount, this.startRotation);
            Arrays.fill(this.scales, 0, boneFramesCount, this.startScale);
        }
    }

    public CalculationBone(Bone bone, BoneTrack track) {
        this(bone, 0);
        this.track = track;
        this.translations = track.getTranslations();
        this.rotations = track.getRotations();
        this.scales = track.getScales();
    }

    public int getBoneFramesCount() {
        return this.translations == null ? 0 : this.translations.length;
    }

    public Vector3f getEndPoint() {
        if (this.getParent() == null) {
            return new Vector3f(0.0f, this.getLocalScale().y, 0.0f);
        }
        Node parent = this.getParent();
        return parent.getWorldTranslation().subtract(this.getWorldTranslation()).multLocal(this.getWorldScale());
    }

    public void reset() {
        this.setLocalTranslation(this.startTranslation);
        this.setLocalRotation(this.startRotation);
        this.setLocalScale(this.startScale);
    }

    public int attachChild(Spatial child) {
        if (this.getChildren() != null && this.getChildren().size() > 1) {
            throw new IllegalStateException(this.getClass().getName() + " class instance can only have one child!");
        }
        return super.attachChild(child);
    }

    public Spatial rotate(Quaternion rot, int frame) {
        Spatial spatial = super.rotate(rot);
        this.updateWorldTransforms();
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            CalculationBone child = (CalculationBone)this.getChild(0);
            child.updateWorldTransforms();
        }
        this.rotations[frame].set(this.getLocalRotation());
        this.translations[frame].set(this.getLocalTranslation());
        if (this.scales != null) {
            this.scales[frame].set(this.getLocalScale());
        }
        return spatial;
    }

    public void applyCalculatedTracks() {
        if (this.track != null) {
            this.track.setKeyframes(this.track.getTimes(), this.translations, this.rotations, this.scales);
        } else {
            this.bone.setUserControl(true);
            this.bone.setUserTransforms(this.translations[0], this.rotations[0], this.scales[0]);
            this.bone.setUserControl(false);
            this.bone.updateWorldVectors();
        }
    }

    public String toString() {
        return this.bone.getName() + ": " + this.getLocalRotation() + " " + this.getLocalTranslation();
    }
}

