/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.light.Light;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.AbstractBlenderLoader;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.ArmatureHelper;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.modifiers.ModifierHelper;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.plugins.blender.particles.ParticlesHelper;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlenderLoader
extends AbstractBlenderLoader {
    private static final Logger LOGGER = Logger.getLogger(BlenderLoader.class.getName());
    protected List<FileBlockHeader> blocks;

    public Spatial load(AssetInfo assetInfo) throws IOException {
        try {
            this.setup(assetInfo);
            BlenderKey blenderKey = this.blenderContext.getBlenderKey();
            BlenderKey.LoadingResults loadingResults = blenderKey.prepareLoadingResults();
            BlenderKey.WorldData worldData = null;
            for (FileBlockHeader block : this.blocks) {
                switch (block.getCode()) {
                    case 1329725440: {
                        Object object = this.toObject(block.getStructure(this.blenderContext));
                        if (object instanceof Node) {
                            if ((blenderKey.getFeaturesToLoad() & 0xB) == 0) break;
                            LOGGER.log(Level.INFO, "{0}: {1}--> {2}", new Object[]{((Node)object).getName(), ((Node)object).getLocalTranslation().toString(), ((Node)object).getParent() == null ? "null" : ((Node)object).getParent().getName()});
                            if (!this.isRootObject(loadingResults, (Node)object)) break;
                            loadingResults.addObject((Node)object);
                            break;
                        }
                        if (object instanceof Camera) {
                            if ((blenderKey.getFeaturesToLoad() & 0x20) == 0) break;
                            loadingResults.addCamera((Camera)object);
                            break;
                        }
                        if (!(object instanceof Light) || (blenderKey.getFeaturesToLoad() & 0x10) == 0) break;
                        loadingResults.addLight((Light)object);
                        break;
                    }
                    case 1296105472: {
                        if (!blenderKey.isLoadUnlinkedAssets() || (blenderKey.getFeaturesToLoad() & 3) == 0) break;
                        loadingResults.addMaterial(this.toMaterial(block.getStructure(this.blenderContext)));
                        break;
                    }
                    case 1396899840: {
                        if ((blenderKey.getFeaturesToLoad() & 0xFFFF) == 0) break;
                        loadingResults.addScene(this.toScene(block.getStructure(this.blenderContext)));
                        break;
                    }
                    case 1464795136: {
                        if (!blenderKey.isLoadUnlinkedAssets() || worldData != null) break;
                        Structure worldStructure = block.getStructure(this.blenderContext);
                        String worldName = worldStructure.getName();
                        if (blenderKey.getUsedWorld() != null && !blenderKey.getUsedWorld().equals(worldName)) break;
                        worldData = this.toWorldData(worldStructure);
                        if ((blenderKey.getFeaturesToLoad() & 0x10) == 0) break;
                        loadingResults.addLight(worldData.getAmbientLight());
                    }
                }
            }
            this.blenderContext.dispose();
            return loadingResults;
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected boolean isRootObject(BlenderKey.LoadingResults loadingResults, Spatial spatial) {
        if (spatial.getParent() == null) {
            return true;
        }
        for (Node scene : loadingResults.getScenes()) {
            if (!spatial.getParent().equals(scene)) continue;
            return true;
        }
        return false;
    }

    protected void setup(AssetInfo assetInfo) throws BlenderFileException {
        FileBlockHeader fileBlock;
        BlenderKey blenderKey;
        ModelKey modelKey = (ModelKey)assetInfo.getKey();
        if (modelKey instanceof BlenderKey) {
            blenderKey = (BlenderKey)modelKey;
        } else {
            blenderKey = new BlenderKey(modelKey.getName());
            blenderKey.setAssetRootPath(modelKey.getFolder());
        }
        BlenderInputStream inputStream = new BlenderInputStream(assetInfo.openStream(), assetInfo.getManager());
        this.blocks = new ArrayList<FileBlockHeader>();
        this.blenderContext = new BlenderContext();
        this.blenderContext.setAssetManager(assetInfo.getManager());
        this.blenderContext.setInputStream(inputStream);
        this.blenderContext.setBlenderKey(blenderKey);
        this.blenderContext.putHelper(ArmatureHelper.class, new ArmatureHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(TextureHelper.class, new TextureHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(MeshHelper.class, new MeshHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(ObjectHelper.class, new ObjectHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(CurvesHelper.class, new CurvesHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(LightHelper.class, new LightHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(CameraHelper.class, new CameraHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(ModifierHelper.class, new ModifierHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(MaterialHelper.class, new MaterialHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(ConstraintHelper.class, new ConstraintHelper(inputStream.getVersionNumber(), this.blenderContext));
        this.blenderContext.putHelper(IpoHelper.class, new IpoHelper(inputStream.getVersionNumber()));
        this.blenderContext.putHelper(ParticlesHelper.class, new ParticlesHelper(inputStream.getVersionNumber()));
        if (blenderKey.isFixUpAxis()) {
            AbstractBlenderHelper helper = (AbstractBlenderHelper)this.blenderContext.getHelper(ObjectHelper.class);
            helper.setyIsUpAxis(true);
            helper = (AbstractBlenderHelper)this.blenderContext.getHelper(CurvesHelper.class);
            helper.setyIsUpAxis(true);
            helper = (AbstractBlenderHelper)this.blenderContext.getHelper(ArmatureHelper.class);
            helper.setyIsUpAxis(true);
        }
        MaterialHelper materialHelper = (MaterialHelper)this.blenderContext.getHelper(MaterialHelper.class);
        materialHelper.setFaceCullMode(blenderKey.getFaceCullMode());
        FileBlockHeader sceneFileBlock = null;
        do {
            if ((fileBlock = new FileBlockHeader(inputStream, this.blenderContext)).isDnaBlock()) continue;
            this.blocks.add(fileBlock);
            if (fileBlock.getCode() != 1396899840 || blenderKey.getLayersToLoad() >= 0) continue;
            sceneFileBlock = fileBlock;
        } while (!fileBlock.isLastBlock());
        if (sceneFileBlock != null) {
            int lay = ((Number)sceneFileBlock.getStructure(this.blenderContext).getFieldValue("lay")).intValue();
            this.blenderContext.getBlenderKey().setLayersToLoad(lay);
        }
    }
}

