/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.asset.AssetManager;
import com.jme3.asset.BlenderKey;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DnaBlockData;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.meshes.MeshContext;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlenderContext {
    private static final Logger LOGGER = Logger.getLogger(BlenderContext.class.getName());
    private BlenderKey blenderKey;
    private DnaBlockData dnaBlockData;
    private BlenderInputStream inputStream;
    private AssetManager assetManager;
    private Map<Long, FileBlockHeader> fileBlockHeadersByOma = new HashMap<Long, FileBlockHeader>();
    private Map<Integer, List<FileBlockHeader>> fileBlockHeadersByCode = new HashMap<Integer, List<FileBlockHeader>>();
    private Map<Long, Object[]> loadedFeatures = new HashMap<Long, Object[]>();
    private Map<String, Object[]> loadedFeaturesByName = new HashMap<String, Object[]>();
    private Stack<Structure> parentStack = new Stack();
    private Map<Long, Ipo> loadedIpos = new HashMap<Long, Ipo>();
    protected Map<Long, List<Modifier>> modifiers = new HashMap<Long, List<Modifier>>();
    protected Map<Long, List<Constraint>> constraints = new HashMap<Long, List<Constraint>>();
    protected Map<Long, MeshContext> meshContexts = new HashMap<Long, MeshContext>();
    protected Map<Material, MaterialContext> materialContexts = new HashMap<Material, MaterialContext>();
    private Map<String, AbstractBlenderHelper> helpers = new HashMap<String, AbstractBlenderHelper>();

    public void setBlenderKey(BlenderKey blenderKey) {
        this.blenderKey = blenderKey;
    }

    public BlenderKey getBlenderKey() {
        return this.blenderKey;
    }

    public void setBlockData(DnaBlockData dnaBlockData) {
        this.dnaBlockData = dnaBlockData;
    }

    public DnaBlockData getDnaBlockData() {
        return this.dnaBlockData;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public BlenderInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(BlenderInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void addFileBlockHeader(Long oldMemoryAddress, FileBlockHeader fileBlockHeader) {
        this.fileBlockHeadersByOma.put(oldMemoryAddress, fileBlockHeader);
        List<FileBlockHeader> headers = this.fileBlockHeadersByCode.get(fileBlockHeader.getCode());
        if (headers == null) {
            headers = new ArrayList<FileBlockHeader>();
            this.fileBlockHeadersByCode.put(fileBlockHeader.getCode(), headers);
        }
        headers.add(fileBlockHeader);
    }

    public FileBlockHeader getFileBlock(Long oldMemoryAddress) {
        return this.fileBlockHeadersByOma.get(oldMemoryAddress);
    }

    public List<FileBlockHeader> getFileBlocks(Integer code) {
        return this.fileBlockHeadersByCode.get(code);
    }

    public void clearFileBlocks() {
        this.fileBlockHeadersByOma.clear();
        this.fileBlockHeadersByCode.clear();
    }

    public <T> void putHelper(Class<T> clazz, AbstractBlenderHelper helper) {
        this.helpers.put(clazz.getSimpleName(), helper);
    }

    public <T> T getHelper(Class<?> clazz) {
        return (T)this.helpers.get(clazz.getSimpleName());
    }

    public void addLoadedFeatures(Long oldMemoryAddress, String featureName, Structure structure, Object feature) {
        if (oldMemoryAddress == null || structure == null || feature == null) {
            throw new IllegalArgumentException("One of the given arguments is null!");
        }
        Object[] storedData = new Object[]{structure, feature};
        this.loadedFeatures.put(oldMemoryAddress, storedData);
        if (featureName != null) {
            this.loadedFeaturesByName.put(featureName, storedData);
        }
    }

    public Object getLoadedFeature(Long oldMemoryAddress, LoadedFeatureDataType loadedFeatureDataType) {
        Object[] result = this.loadedFeatures.get(oldMemoryAddress);
        if (result != null) {
            return result[loadedFeatureDataType.getIndex()];
        }
        return null;
    }

    public Object getLoadedFeature(String featureName, LoadedFeatureDataType loadedFeatureDataType) {
        Object[] result = this.loadedFeaturesByName.get(featureName);
        if (result != null) {
            return result[loadedFeatureDataType.getIndex()];
        }
        return null;
    }

    public void clearLoadedFeatures() {
        this.loadedFeatures.clear();
    }

    public void pushParent(Structure parent) {
        this.parentStack.push(parent);
    }

    public Structure popParent() {
        try {
            return this.parentStack.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Structure peekParent() {
        try {
            return this.parentStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void addIpo(Long ownerOMA, Ipo ipo) {
        this.loadedIpos.put(ownerOMA, ipo);
    }

    public Ipo removeIpo(Long ownerOma) {
        return this.loadedIpos.remove(ownerOma);
    }

    public Ipo getIpo(Long ownerOMA) {
        return this.loadedIpos.get(ownerOMA);
    }

    public void addModifier(Long ownerOMA, Modifier modifier) {
        List<Modifier> objectModifiers = this.modifiers.get(ownerOMA);
        if (objectModifiers == null) {
            objectModifiers = new ArrayList<Modifier>();
            this.modifiers.put(ownerOMA, objectModifiers);
        }
        objectModifiers.add(modifier);
    }

    public List<Modifier> getModifiers(Long objectOMA, String type) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        List<Modifier> readModifiers = this.modifiers.get(objectOMA);
        if (readModifiers != null && readModifiers.size() > 0) {
            for (Modifier modifier : readModifiers) {
                if (type != null && !type.isEmpty() && !modifier.getType().equals(type)) continue;
                result.add(modifier);
            }
        }
        return result;
    }

    public void addConstraints(Long ownerOMA, List<Constraint> constraints) {
        List<Constraint> objectConstraints = this.constraints.get(ownerOMA);
        if (objectConstraints == null) {
            objectConstraints = new ArrayList<Constraint>();
            this.constraints.put(ownerOMA, objectConstraints);
        }
        objectConstraints.addAll(constraints);
    }

    public List<Constraint> getConstraints(Long objectOMA) {
        return this.constraints.get(objectOMA);
    }

    public void setMeshContext(Long meshOMA, MeshContext meshContext) {
        this.meshContexts.put(meshOMA, meshContext);
    }

    public MeshContext getMeshContext(Long meshOMA) {
        return this.meshContexts.get(meshOMA);
    }

    public void setMaterialContext(Material material, MaterialContext materialContext) {
        this.materialContexts.put(material, materialContext);
    }

    public MaterialContext getMaterialContext(Material material) {
        return this.materialContexts.get(material);
    }

    public synchronized Material getDefaultMaterial() {
        if (this.blenderKey.getDefaultMaterial() == null) {
            Material defaultMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            defaultMaterial.setColor("Color", ColorRGBA.DarkGray);
            this.blenderKey.setDefaultMaterial(defaultMaterial);
        }
        return this.blenderKey.getDefaultMaterial();
    }

    public void dispose() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.loadedFeatures.clear();
        this.loadedFeaturesByName.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadedFeatureDataType {
        LOADED_STRUCTURE(0),
        LOADED_FEATURE(1);

        private int index;

        private LoadedFeatureDataType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

