/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.queue;

import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.GuiComparator;
import com.jme3.renderer.queue.NullComparator;
import com.jme3.renderer.queue.OpaqueComparator;
import com.jme3.renderer.queue.TransparentComparator;
import com.jme3.scene.Geometry;

public class RenderQueue {
    private GeometryList opaqueList = new GeometryList(new OpaqueComparator());
    private GeometryList guiList = new GeometryList(new GuiComparator());
    private GeometryList transparentList = new GeometryList(new TransparentComparator());
    private GeometryList translucentList = new GeometryList(new TransparentComparator());
    private GeometryList skyList = new GeometryList(new NullComparator());
    private GeometryList shadowRecv = new GeometryList(new OpaqueComparator());
    private GeometryList shadowCast = new GeometryList(new OpaqueComparator());

    public void setGeometryComparator(Bucket bucket, GeometryComparator c) {
        switch (bucket) {
            case Gui: {
                this.guiList = new GeometryList(c);
                break;
            }
            case Opaque: {
                this.opaqueList = new GeometryList(c);
                break;
            }
            case Sky: {
                this.skyList = new GeometryList(c);
                break;
            }
            case Transparent: {
                this.transparentList = new GeometryList(c);
                break;
            }
            case Translucent: {
                this.translucentList = new GeometryList(c);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown bucket type: " + (Object)((Object)bucket));
            }
        }
    }

    public void addToShadowQueue(Geometry g, ShadowMode shadBucket) {
        switch (shadBucket) {
            case Inherit: {
                break;
            }
            case Off: {
                break;
            }
            case Cast: {
                this.shadowCast.add(g);
                break;
            }
            case Receive: {
                this.shadowRecv.add(g);
                break;
            }
            case CastAndReceive: {
                this.shadowCast.add(g);
                this.shadowRecv.add(g);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized shadow bucket type: " + (Object)((Object)shadBucket));
            }
        }
    }

    public void addToQueue(Geometry g, Bucket bucket) {
        switch (bucket) {
            case Gui: {
                this.guiList.add(g);
                break;
            }
            case Opaque: {
                this.opaqueList.add(g);
                break;
            }
            case Sky: {
                this.skyList.add(g);
                break;
            }
            case Transparent: {
                this.transparentList.add(g);
                break;
            }
            case Translucent: {
                this.translucentList.add(g);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown bucket type: " + (Object)((Object)bucket));
            }
        }
    }

    public GeometryList getShadowQueueContent(ShadowMode shadBucket) {
        switch (shadBucket) {
            case Cast: {
                return this.shadowCast;
            }
            case Receive: {
                return this.shadowRecv;
            }
        }
        throw new IllegalArgumentException("Only Cast or Receive are allowed");
    }

    private void renderGeometryList(GeometryList list, RenderManager rm, Camera cam, boolean clear) {
        list.setCamera(cam);
        list.sort();
        for (int i = 0; i < list.size(); ++i) {
            Geometry obj = list.get(i);
            assert (obj != null);
            if (obj instanceof Geometry) {
                Geometry g = obj;
                rm.renderGeometry(g);
            }
            if (obj == null) continue;
            obj.queueDistance = Float.NEGATIVE_INFINITY;
        }
        if (clear) {
            list.clear();
        }
    }

    public void renderShadowQueue(GeometryList list, RenderManager rm, Camera cam, boolean clear) {
        this.renderGeometryList(list, rm, cam, clear);
    }

    public void renderShadowQueue(ShadowMode shadBucket, RenderManager rm, Camera cam, boolean clear) {
        switch (shadBucket) {
            case Cast: {
                this.renderGeometryList(this.shadowCast, rm, cam, clear);
                break;
            }
            case Receive: {
                this.renderGeometryList(this.shadowRecv, rm, cam, clear);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected shadow bucket: " + (Object)((Object)shadBucket));
            }
        }
    }

    public boolean isQueueEmpty(Bucket bucket) {
        switch (bucket) {
            case Gui: {
                return this.guiList.size() == 0;
            }
            case Opaque: {
                return this.opaqueList.size() == 0;
            }
            case Sky: {
                return this.skyList.size() == 0;
            }
            case Transparent: {
                return this.transparentList.size() == 0;
            }
            case Translucent: {
                return this.translucentList.size() == 0;
            }
        }
        throw new UnsupportedOperationException("Unsupported bucket type: " + (Object)((Object)bucket));
    }

    public void renderQueue(Bucket bucket, RenderManager rm, Camera cam) {
        this.renderQueue(bucket, rm, cam, true);
    }

    public void renderQueue(Bucket bucket, RenderManager rm, Camera cam, boolean clear) {
        switch (bucket) {
            case Gui: {
                this.renderGeometryList(this.guiList, rm, cam, clear);
                break;
            }
            case Opaque: {
                this.renderGeometryList(this.opaqueList, rm, cam, clear);
                break;
            }
            case Sky: {
                this.renderGeometryList(this.skyList, rm, cam, clear);
                break;
            }
            case Transparent: {
                this.renderGeometryList(this.transparentList, rm, cam, clear);
                break;
            }
            case Translucent: {
                this.renderGeometryList(this.translucentList, rm, cam, clear);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported bucket type: " + (Object)((Object)bucket));
            }
        }
    }

    public void clear() {
        this.opaqueList.clear();
        this.guiList.clear();
        this.transparentList.clear();
        this.translucentList.clear();
        this.skyList.clear();
        this.shadowCast.clear();
        this.shadowRecv.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Bucket {
        Opaque,
        Transparent,
        Sky,
        Translucent,
        Gui,
        Inherit;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShadowMode {
        Off,
        Cast,
        Receive,
        CastAndReceive,
        Inherit;

    }
}

